/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.store;

import java.util.Arrays;
import java.util.Map;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.WrapperStore;
import org.ehcache.core.store.StoreSupport;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;

@OptionalServiceDependencies(value={"org.ehcache.core.spi.service.StatisticsService"})
public abstract class AbstractWrapperStoreProvider
implements WrapperStore.Provider {
    private volatile ServiceProvider<Service> serviceProvider;
    private final Map<Store<?, ?>, StoreReference<?, ?>> createdStores = new ConcurrentWeakIdentityHashMap();

    @Override
    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        Store.Provider underlyingStoreProvider = StoreSupport.selectStoreProvider(this.serviceProvider, storeConfig.getResourcePools().getResourceTypeSet(), Arrays.asList(serviceConfigs));
        Store<K, V> store = underlyingStoreProvider.createStore(storeConfig, serviceConfigs);
        Store<K, V> wrappedStore = this.wrap(store, storeConfig, serviceConfigs);
        StatisticsService statisticsService = (StatisticsService)this.serviceProvider.getService(StatisticsService.class);
        if (statisticsService != null) {
            statisticsService.registerWithParent(store, wrappedStore);
        }
        this.createdStores.put(wrappedStore, new StoreReference<K, V>(store, underlyingStoreProvider));
        return wrappedStore;
    }

    protected abstract <K, V> Store<K, V> wrap(Store<K, V> var1, Store.Configuration<K, V> var2, ServiceConfiguration<?, ?> ... var3);

    @Override
    public void releaseStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.remove(resource);
        if (storeRef != null) {
            storeRef.release();
        }
    }

    @Override
    public void initStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.get(resource);
        if (storeRef != null) {
            storeRef.init();
        }
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
        this.createdStores.clear();
        this.serviceProvider = null;
    }

    private static class StoreReference<K, V> {
        private final Store<K, V> store;
        private final Store.Provider provider;

        public StoreReference(Store<K, V> store, Store.Provider provider) {
            this.store = store;
            this.provider = provider;
        }

        public void release() {
            this.provider.releaseStore(this.store);
        }

        public void init() {
            this.provider.initStore(this.store);
        }
    }
}

