/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.modular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;

@Entity
@Table(name="BUDGET_MODULAR")
public class BudgetModular
extends KcPersistableBusinessObjectBase
implements BudgetModularContract {
    @Column(name="BUDGET_PERIOD_NUMBER", insertable=false, updatable=false)
    private Long budgetPeriodId;
    @Id
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_PERIOD_NUMBER", referencedColumnName="BUDGET_PERIOD_NUMBER", insertable=true, updatable=true)
    private BudgetPeriod budgetPeriodObj;
    @Column(name="BUDGET_ID")
    private Long budgetId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="DIRECT_COST_LESS_CONSOR_FNA")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal directCostLessConsortiumFna;
    @Column(name="CONSORTIUM_FNA")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal consortiumFna;
    @Column(name="TOTAL_DIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalDirectCost;
    @OneToMany(mappedBy="budgetModular", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();
    @Transient
    private ScaleTwoDecimal totalRequestedCost;
    @Transient
    private ScaleTwoDecimal totalFnaRequested;

    public BudgetModular() {
        this.directCostLessConsortiumFna = ScaleTwoDecimal.ZERO;
        this.consortiumFna = ScaleTwoDecimal.ZERO;
        this.totalDirectCost = ScaleTwoDecimal.ZERO;
    }

    public BudgetModular(BudgetPeriod budgetPeriod) {
        this();
        this.setBudgetPeriodObj(budgetPeriod);
        this.setBudgetId(budgetPeriod.getBudgetId());
        this.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public ScaleTwoDecimal getConsortiumFna() {
        return this.consortiumFna;
    }

    public void setConsortiumFna(ScaleTwoDecimal consortiumFna) {
        this.consortiumFna = consortiumFna;
    }

    public ScaleTwoDecimal getDirectCostLessConsortiumFna() {
        return this.directCostLessConsortiumFna;
    }

    public void setDirectCostLessConsortiumFna(ScaleTwoDecimal directCostLessConsortiumFna) {
        this.directCostLessConsortiumFna = directCostLessConsortiumFna;
    }

    public ScaleTwoDecimal getTotalDirectCost() {
        return this.totalDirectCost;
    }

    public void setTotalDirectCost(ScaleTwoDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public ScaleTwoDecimal getTotalFnaRequested() {
        return this.totalFnaRequested;
    }

    public void setTotalFnaRequested(ScaleTwoDecimal totalFnaRequested) {
        this.totalFnaRequested = totalFnaRequested;
    }

    public ScaleTwoDecimal getTotalRequestedCost() {
        return this.totalRequestedCost;
    }

    public void setTotalRequestedCost(ScaleTwoDecimal totalRequestedCost) {
        this.totalRequestedCost = totalRequestedCost;
    }

    public List<BudgetModularIdc> getBudgetModularIdcs() {
        return this.budgetModularIdcs;
    }

    public void setBudgetModularIdcs(List<BudgetModularIdc> budgetModularIdcs) {
        this.budgetModularIdcs = budgetModularIdcs;
    }

    public BudgetModularIdc getBudgetModularIdc(int index) {
        while (this.getBudgetModularIdcs().size() <= index) {
            this.getBudgetModularIdcs().add(new BudgetModularIdc());
        }
        return this.getBudgetModularIdcs().get(index);
    }

    public void calculateAllTotals() {
        this.calculateTotalDirectCost();
        this.calculateTotalFnaRequested();
        this.calculateTotalRequestedCost();
    }

    public void calculateTotalDirectCost() {
        ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
        if (this.getDirectCostLessConsortiumFna() != null) {
            totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)this.getDirectCostLessConsortiumFna());
        }
        if (this.getConsortiumFna() != null) {
            totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)this.getConsortiumFna());
        }
        this.setTotalDirectCost(totalDirectCost);
    }

    public void calculateTotalFnaRequested() {
        ScaleTwoDecimal fnaRequested = ScaleTwoDecimal.ZERO;
        for (BudgetModularIdc budgetModularIdc : this.getBudgetModularIdcs()) {
            budgetModularIdc.calculateFundsRequested();
            if (budgetModularIdc.getFundsRequested() == null) continue;
            fnaRequested = (ScaleTwoDecimal)fnaRequested.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
        }
        this.setTotalFnaRequested(fnaRequested);
    }

    public void calculateTotalRequestedCost() {
        ScaleTwoDecimal requestedCost = ScaleTwoDecimal.ZERO;
        if (this.getTotalDirectCost() != null) {
            requestedCost = (ScaleTwoDecimal)requestedCost.add((AbstractDecimal)this.getTotalDirectCost());
        }
        if (this.getTotalFnaRequested() != null) {
            requestedCost = (ScaleTwoDecimal)requestedCost.add((AbstractDecimal)this.getTotalFnaRequested());
        }
        this.setTotalRequestedCost(requestedCost);
    }

    public void addNewBudgetModularIdcBaseUnrounded(BudgetModularIdc budgetModularIdc) {
        budgetModularIdc.setBudgetId(this.getBudgetId());
        budgetModularIdc.setBudgetPeriod(this.getBudgetPeriod());
        for (BudgetModularIdc currentModularIdc : this.getBudgetModularIdcs()) {
            if (!currentModularIdc.getIdcRate().equals((Object)budgetModularIdc.getIdcRate()) || !currentModularIdc.getDescription().equals(budgetModularIdc.getDescription())) continue;
            if (currentModularIdc.getIdcBase() == null) {
                currentModularIdc.setIdcBase(budgetModularIdc.getIdcBase());
            } else {
                currentModularIdc.setIdcBase((ScaleTwoDecimal)currentModularIdc.getIdcBase().add((AbstractDecimal)budgetModularIdc.getIdcBase()));
            }
            if (currentModularIdc.getFundsRequested() == null) {
                currentModularIdc.setFundsRequested(budgetModularIdc.getFundsRequested());
            } else {
                currentModularIdc.setFundsRequested((ScaleTwoDecimal)currentModularIdc.getFundsRequested().add((AbstractDecimal)budgetModularIdc.getFundsRequested()));
            }
            return;
        }
        this.getBudgetModularIdcs().add(budgetModularIdc);
    }

    public void addNewBudgetModularIdcBaseRounded(BudgetModularIdc budgetModularIdc) {
        budgetModularIdc.setBudgetId(this.getBudgetId());
        budgetModularIdc.setBudgetPeriod(this.getBudgetPeriod());
        for (BudgetModularIdc currentModularIdc : this.getBudgetModularIdcs()) {
            if (!currentModularIdc.getIdcRate().equals((Object)budgetModularIdc.getIdcRate()) || !currentModularIdc.getDescription().equals(budgetModularIdc.getDescription())) continue;
            currentModularIdc.setIdcBase(budgetModularIdc.getIdcBase());
            if (budgetModularIdc.getStartDate() != null && budgetModularIdc.getStartDate().before(currentModularIdc.getStartDate())) {
                currentModularIdc.setStartDate(budgetModularIdc.getStartDate());
            }
            if (budgetModularIdc.getEndDate() != null && budgetModularIdc.getEndDate().after(currentModularIdc.getEndDate())) {
                currentModularIdc.setEndDate(budgetModularIdc.getEndDate());
            }
            if (currentModularIdc.getHierarchyProposalNumber() == null) {
                currentModularIdc.setHierarchyProposalNumber(budgetModularIdc.getHierarchyProposalNumber());
            } else {
                String currentProps = currentModularIdc.getHierarchyProposalNumber();
                String thisProp = budgetModularIdc.getHierarchyProposalNumber();
                ArrayList<String> propNums = new ArrayList<String>(Arrays.asList(currentProps.split(",")));
                if (!propNums.contains(thisProp)) {
                    propNums.add(thisProp);
                    Collections.sort(propNums);
                    currentModularIdc.setHierarchyProposalNumber(StringUtils.join(propNums, (String)","));
                }
            }
            if (currentModularIdc.getIdcBaseUnrounded() == null) {
                currentModularIdc.setIdcBaseUnrounded(budgetModularIdc.getIdcBaseUnrounded());
            } else {
                currentModularIdc.setIdcBaseUnrounded((ScaleTwoDecimal)currentModularIdc.getIdcBaseUnrounded().add((AbstractDecimal)budgetModularIdc.getIdcBaseUnrounded()));
            }
            if (currentModularIdc.getFundsRequested() == null) {
                currentModularIdc.setFundsRequested(budgetModularIdc.getFundsRequested());
            } else {
                currentModularIdc.calculateFundsRequested();
            }
            return;
        }
        this.getBudgetModularIdcs().add(budgetModularIdc);
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public BudgetPeriod getBudgetPeriodObj() {
        return this.budgetPeriodObj;
    }

    public void setBudgetPeriodObj(BudgetPeriod budgetPeriodObj) {
        if (budgetPeriodObj != null) {
            this.setBudgetPeriodId(budgetPeriodObj.getBudgetPeriodId());
        } else {
            this.setBudgetPeriodId(null);
        }
        this.budgetPeriodObj = budgetPeriodObj;
    }
}

