/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.deliverer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.commons.validator.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.EmailService;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.RecipientPreferenceService;

public class EmailMessageDeliverer
implements MessageDeliverer {
    private static Logger LOG = LogManager.getLogger(EmailMessageDeliverer.class);
    private EmailService emailService;
    private RecipientPreferenceService recipientPreferenceService;
    public static final String NAME = "Email";
    public static final String EMAIL_ADDR_PREF_KEY = "email_address";
    public static final String EMAIL_DELIV_FRMT_PREF_KEY = "email_delivery_format";

    @Override
    public void deliver(MessageDelivery messageDelivery) throws MessageDeliveryException {
        try {
            String recipientEmailAddressPrefKey = this.getName() + ".email_address";
            String recipientEmailFormatPrefKey = this.getName() + ".email_delivery_format";
            String recipientEmailAddress = this.getRecipientPreferenceService().getRecipientPreference(messageDelivery.getMessage().getRecipient(), recipientEmailAddressPrefKey).getValue();
            String recipientEmailFormat = this.getRecipientPreferenceService().getRecipientPreference(messageDelivery.getMessage().getRecipient(), recipientEmailFormatPrefKey).getValue();
            Long emailMessageId = this.getEmailService().sendEmail(messageDelivery, recipientEmailAddress, recipientEmailFormat);
            String deliverySystemId = null;
            if (emailMessageId != null) {
                deliverySystemId = emailMessageId.toString();
            }
            messageDelivery.setDelivererSystemId(deliverySystemId);
        }
        catch (Exception we) {
            LOG.error("Error delivering email notification", (Throwable)we);
            throw new MessageDeliveryException("Error delivering email notification", (Throwable)we);
        }
    }

    @Override
    public void dismiss(MessageDelivery messageDelivery, String user, String cause) {
    }

    @Override
    public String getDescription() {
        return "Enter an Email Address and Email Delivery Format below and select the channels for which you would like email delivery notifications. Select \"None\" in the channel list to remove a delivery type for all channels.  Only one Email Address and Email Delivery Format may be specified. Any data entered and saved will override prior Delivery Type selections.";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Email Message Delivery";
    }

    @Override
    public LinkedHashMap<String, String> getPreferenceKeys() {
        LinkedHashMap<String, String> prefKeys = new LinkedHashMap<String, String>();
        prefKeys.put(EMAIL_ADDR_PREF_KEY, "Email Address (\"abc@def.edu\")");
        prefKeys.put(EMAIL_DELIV_FRMT_PREF_KEY, "Email Delivery Format (text or html)");
        return prefKeys;
    }

    @Override
    public void validatePreferenceValues(HashMap<String, String> prefs) throws ErrorList {
        boolean error = false;
        ErrorList errorList = new ErrorList();
        String[] validformats = new String[]{"text", "html"};
        if (!prefs.containsKey(this.getName() + ".email_address")) {
            errorList.addError("Email Address is a required field.");
            error = true;
        } else {
            String addressValue = prefs.get(this.getName() + ".email_address");
            EmailValidator validator = EmailValidator.getInstance();
            if (!validator.isValid(addressValue)) {
                errorList.addError("Email Address is required and must be properly formatted - \"abc@def.edu\".");
                error = true;
            }
        }
        if (!prefs.containsKey(this.getName() + ".email_delivery_format")) {
            errorList.addError("Email Delivery Format is required.");
            error = true;
        } else {
            String formatValue = prefs.get(this.getName() + ".email_delivery_format");
            HashSet formats = new HashSet();
            Collections.addAll(formats, validformats);
            if (!formats.contains(formatValue)) {
                errorList.addError("Email Delivery Format is required and must be entered as \"text\" or \"html\".");
                error = true;
            }
        }
        if (error) {
            throw errorList;
        }
    }

    private EmailService getEmailService() {
        if (this.emailService == null) {
            this.emailService = GlobalKCBServiceLocator.getInstance().getEmailService();
        }
        return this.emailService;
    }

    private RecipientPreferenceService getRecipientPreferenceService() {
        if (this.recipientPreferenceService == null) {
            this.recipientPreferenceService = GlobalKCBServiceLocator.getInstance().getRecipientPreferenceService();
        }
        return this.recipientPreferenceService;
    }
}

