/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow.service.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDecimal;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeInteger;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.WorkflowAttributePropertyResolutionService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.DocumentCollectionPath;
import org.kuali.rice.krad.datadictionary.DocumentValuePathGroup;
import org.kuali.rice.krad.datadictionary.RoutingAttribute;
import org.kuali.rice.krad.datadictionary.RoutingTypeDefinition;
import org.kuali.rice.krad.datadictionary.SearchingTypeDefinition;
import org.kuali.rice.krad.datadictionary.WorkflowAttributes;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.DataTypeUtil;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class WorkflowAttributePropertyResolutionServiceImpl
implements WorkflowAttributePropertyResolutionService {
    private PersistenceStructureService persistenceStructureService;
    private BusinessObjectMetaDataService businessObjectMetaDataService;

    public List<Map<String, String>> resolveRoutingTypeQualifiers(Document document, RoutingTypeDefinition routingTypeDefinition) {
        ArrayList<Map<String, String>> qualifiers = new ArrayList<Map<String, String>>();
        if (routingTypeDefinition != null) {
            document.populateDocumentForRouting();
            RoutingAttributeTracker routingAttributeTracker = new RoutingAttributeTracker(routingTypeDefinition.getRoutingAttributes());
            for (DocumentValuePathGroup documentValuePathGroup : routingTypeDefinition.getDocumentValuePathGroups()) {
                qualifiers.addAll(this.resolveDocumentValuePath(document, documentValuePathGroup, routingAttributeTracker));
                routingAttributeTracker.reset();
            }
        }
        return qualifiers;
    }

    protected List<Map<String, String>> resolveDocumentValuePath(Object businessObject, DocumentValuePathGroup group, RoutingAttributeTracker routingAttributeTracker) {
        List<Object> qualifiers;
        HashMap<String, String> qualifier = new HashMap<String, String>();
        if (group.getDocumentValues() == null && group.getDocumentCollectionPath() == null) {
            throw new IllegalStateException("A document value path group must have the documentValues property set, the documentCollectionPath property set, or both.");
        }
        if (group.getDocumentValues() != null) {
            this.addPathValuesToQualifier(businessObject, group.getDocumentValues(), routingAttributeTracker, qualifier);
        }
        if (group.getDocumentCollectionPath() != null) {
            qualifiers = this.resolveDocumentCollectionPath(businessObject, group.getDocumentCollectionPath(), routingAttributeTracker);
            qualifiers = this.cleanCollectionQualifiers(qualifiers);
            for (Map map : qualifiers) {
                this.copyQualifications(qualifier, map);
            }
        } else {
            qualifiers = new ArrayList<HashMap<String, String>>();
            qualifiers.add(qualifier);
        }
        return qualifiers;
    }

    protected List<Map<String, String>> resolveDocumentCollectionPath(Object businessObject, DocumentCollectionPath collectionPath, RoutingAttributeTracker routingAttributeTracker) {
        ArrayList<Map<String, String>> qualifiers;
        block5: {
            qualifiers = new ArrayList<Map<String, String>>();
            Collection collectionByPath = this.getCollectionByPath(businessObject, collectionPath.getCollectionPath());
            if (ObjectUtils.isNull((Object)collectionByPath)) break block5;
            if (collectionPath.getNestedCollection() != null) {
                for (Object collectionElement : collectionByPath) {
                    if (!(collectionElement instanceof BusinessObject)) continue;
                    List<Map<String, String>> childQualifiers = this.resolveDocumentCollectionPath((BusinessObject)collectionElement, collectionPath.getNestedCollection(), routingAttributeTracker);
                    for (Map<String, String> childQualifier : childQualifiers) {
                        HashMap<String, String> qualifier = new HashMap<String, String>();
                        routingAttributeTracker.checkPoint();
                        this.addPathValuesToQualifier(collectionElement, collectionPath.getDocumentValues(), routingAttributeTracker, qualifier);
                        this.copyQualifications(childQualifier, qualifier);
                        qualifiers.add(qualifier);
                        routingAttributeTracker.backUpToCheckPoint();
                    }
                }
            } else {
                for (Object collectionElement : collectionByPath) {
                    HashMap<String, String> qualifier = new HashMap<String, String>();
                    routingAttributeTracker.checkPoint();
                    this.addPathValuesToQualifier(collectionElement, collectionPath.getDocumentValues(), routingAttributeTracker, qualifier);
                    qualifiers.add(qualifier);
                    routingAttributeTracker.backUpToCheckPoint();
                }
            }
        }
        return qualifiers;
    }

    protected Collection getCollectionByPath(Object businessObject, String collectionPath) {
        return (Collection)this.getPropertyByPath(businessObject, collectionPath.trim());
    }

    protected void addPathValuesToQualifier(Object businessObject, List<String> paths, RoutingAttributeTracker routingAttributes, Map<String, String> qualifier) {
        if (ObjectUtils.isNotNull(paths)) {
            for (String path : paths) {
                Object value = this.getPropertyByPath(businessObject, path.trim());
                if (value != null) {
                    qualifier.put(routingAttributes.getCurrentRoutingAttribute().getQualificationAttributeName(), value.toString());
                }
                routingAttributes.moveToNext();
            }
        }
    }

    protected void copyQualifications(Map<String, String> source, Map<String, String> target) {
        for (String key : source.keySet()) {
            target.put(key, source.get(key));
        }
    }

    public List<DocumentAttribute> resolveSearchableAttributeValues(Document document, WorkflowAttributes workflowAttributes) {
        ArrayList<DocumentAttribute> valuesToIndex = new ArrayList<DocumentAttribute>();
        if (workflowAttributes != null && workflowAttributes.getSearchingTypeDefinitions() != null) {
            for (SearchingTypeDefinition definition : workflowAttributes.getSearchingTypeDefinitions()) {
                valuesToIndex.addAll(this.aardvarkValuesForSearchingTypeDefinition(document, definition));
            }
        }
        return valuesToIndex;
    }

    protected List<DocumentAttribute> aardvarkValuesForSearchingTypeDefinition(Document document, SearchingTypeDefinition searchingTypeDefinition) {
        ArrayList<DocumentAttribute> searchAttributes = new ArrayList<DocumentAttribute>();
        List<Object> searchValues = this.aardvarkSearchValuesForPaths(document, searchingTypeDefinition.getDocumentValues());
        for (Object value : searchValues) {
            try {
                DocumentAttribute searchableAttributeValue = this.buildSearchableAttribute(Class.forName(searchingTypeDefinition.getSearchingAttribute().getBusinessObjectClassName()), searchingTypeDefinition.getSearchingAttribute().getAttributeName(), value);
                if (searchableAttributeValue == null) continue;
                searchAttributes.add(searchableAttributeValue);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not find instance of class " + searchingTypeDefinition.getSearchingAttribute().getBusinessObjectClassName(), cnfe);
            }
        }
        return searchAttributes;
    }

    protected List<Object> aardvarkSearchValuesForPaths(Document document, List<String> paths) {
        ArrayList<Object> searchValues = new ArrayList<Object>();
        for (String path : paths) {
            this.flatAdd(searchValues, this.getPropertyByPath(document, path.trim()));
        }
        return searchValues;
    }

    protected List<Map<String, String>> cleanCollectionQualifiers(List<Map<String, String>> qualifiers) {
        ArrayList<Map<String, String>> cleanedQualifiers = new ArrayList<Map<String, String>>();
        for (Map<String, String> qualifier : qualifiers) {
            if (qualifier.size() <= 0) continue;
            cleanedQualifiers.add(qualifier);
        }
        return cleanedQualifiers;
    }

    public String determineFieldDataType(Class<? extends BusinessObject> businessObjectClass, String attributeName) {
        return DataTypeUtil.determineFieldDataType(businessObjectClass, (String)attributeName);
    }

    public DocumentAttribute buildSearchableAttribute(Class<? extends BusinessObject> businessObjectClass, String attributeKey, Object value) {
        if (value == null) {
            return null;
        }
        String fieldDataType = this.determineFieldDataType(businessObjectClass, attributeKey);
        if (fieldDataType.equals("string")) {
            return this.buildSearchableStringAttribute(attributeKey, value);
        }
        if (fieldDataType.equals("float") && DataTypeUtil.isDecimaltastic(value.getClass())) {
            return this.buildSearchableRealAttribute(attributeKey, value);
        }
        if (fieldDataType.equals("datetime") && DataTypeUtil.isDateLike(value.getClass())) {
            return this.buildSearchableDateTimeAttribute(attributeKey, value);
        }
        if (fieldDataType.equals("long") && DataTypeUtil.isIntsy(value.getClass())) {
            return this.buildSearchableFixnumAttribute(attributeKey, value);
        }
        if (fieldDataType.equals("boolean") && DataTypeUtil.isBooleanable(value.getClass())) {
            return this.buildSearchableYesNoAttribute(attributeKey, value);
        }
        return this.buildSearchableStringAttribute(attributeKey, value);
    }

    protected DocumentAttributeDateTime buildSearchableDateTimeAttribute(String attributeKey, Object value) {
        return DocumentAttributeFactory.createDateTimeAttribute((String)attributeKey, (DateTime)new DateTime(value));
    }

    protected DocumentAttributeDecimal buildSearchableRealAttribute(String attributeKey, Object value) {
        BigDecimal decimalValue = null;
        decimalValue = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof KualiDecimal ? ((KualiDecimal)value).bigDecimalValue() : new BigDecimal(((Number)value).doubleValue()));
        return DocumentAttributeFactory.createDecimalAttribute((String)attributeKey, (BigDecimal)decimalValue);
    }

    protected DocumentAttributeInteger buildSearchableFixnumAttribute(String attributeKey, Object value) {
        BigInteger integerValue = null;
        integerValue = value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(((Number)value).longValue());
        return DocumentAttributeFactory.createIntegerAttribute((String)attributeKey, (BigInteger)integerValue);
    }

    protected DocumentAttributeString buildSearchableStringAttribute(String attributeKey, Object value) {
        return DocumentAttributeFactory.createStringAttribute((String)attributeKey, (String)value.toString());
    }

    protected DocumentAttributeString buildSearchableYesNoAttribute(String attributeKey, Object value) {
        String boolValueAsString = this.booleanValueAsString((Boolean)value);
        return DocumentAttributeFactory.createStringAttribute((String)attributeKey, (String)boolValueAsString);
    }

    private String booleanValueAsString(Boolean booleanValue) {
        if (booleanValue == null) {
            return "";
        }
        if (booleanValue.booleanValue()) {
            return "Y";
        }
        return "N";
    }

    public Object getPropertyByPath(Object object, String path) {
        Object headValue;
        if (object instanceof Collection) {
            return this.getPropertyOfCollectionByPath((Collection)object, path);
        }
        String[] splitPath = this.headAndTailPath(path);
        String head = splitPath[0];
        String tail = splitPath[1];
        if (object instanceof PersistableBusinessObject && tail != null && this.getBusinessObjectMetaDataService().getBusinessObjectRelationship((Object)((BusinessObject)object), head) != null) {
            ((PersistableBusinessObject)object).refreshReferenceObject(head);
        }
        if (!ObjectUtils.isNull((Object)(headValue = ObjectUtils.getPropertyValue((Object)object, (String)head)))) {
            if (tail == null) {
                return headValue;
            }
            if (headValue instanceof Collection) {
                Collection values = this.makeNewCollectionOfSameType((Collection)headValue);
                for (Object currentElement : (Collection)headValue) {
                    this.flatAdd(values, this.getPropertyByPath(currentElement, tail));
                }
                return values;
            }
            return this.getPropertyByPath(headValue, tail);
        }
        return null;
    }

    public Collection getPropertyOfCollectionByPath(Collection collection, String path) {
        Collection values = this.makeNewCollectionOfSameType(collection);
        for (Object o : collection) {
            this.flatAdd(values, this.getPropertyByPath(o, path));
        }
        return values;
    }

    public Collection makeNewCollectionOfSameType(Collection collection) {
        if (collection instanceof List) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new HashSet();
        }
        try {
            return (Collection)collection.getClass().newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Couldn't instantiate class of collection we'd already instantiated??", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal Access on class of collection we'd already accessed??", iae);
        }
    }

    protected String[] headAndTailPath(String path) {
        int firstDot = path.indexOf(46);
        if (firstDot < 0) {
            return new String[]{path, null};
        }
        return new String[]{path.substring(0, firstDot), path.substring(firstDot + 1)};
    }

    protected void flatAdd(Collection c, Object o) {
        if (o instanceof Collection) {
            c.addAll((Collection)o);
        } else {
            c.add(o);
        }
    }

    public PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    static class RoutingAttributeTracker {
        private List<RoutingAttribute> routingAttributes;
        private int currentRoutingAttributeIndex;
        private Stack<Integer> checkPoints;

        public RoutingAttributeTracker(List<RoutingAttribute> routingAttributes) {
            this.routingAttributes = routingAttributes;
            this.checkPoints = new Stack();
        }

        public RoutingAttribute getCurrentRoutingAttribute() {
            return this.routingAttributes.get(this.currentRoutingAttributeIndex);
        }

        public void moveToNext() {
            ++this.currentRoutingAttributeIndex;
        }

        public void checkPoint() {
            this.checkPoints.push(new Integer(this.currentRoutingAttributeIndex));
        }

        public void backUpToCheckPoint() {
            this.currentRoutingAttributeIndex = this.checkPoints.pop();
        }

        public void reset() {
            this.currentRoutingAttributeIndex = 0;
            this.checkPoints.clear();
        }
    }
}

