/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.type.ValidationRuleType;
import org.kuali.rice.krms.framework.type.ValidationRuleTypeService;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.kuali.rice.krms.impl.validation.RadioButtonTypeServiceUtil;
import org.kuali.rice.krms.impl.validation.ValidationRule;

public final class ValidationRuleTypeServiceImpl
extends KrmsTypeServiceBase
implements ValidationRuleTypeService {
    private RepositoryToEngineTranslator translator;

    private ValidationRuleTypeServiceImpl() {
    }

    public static ValidationRuleTypeService getInstance() {
        return new ValidationRuleTypeServiceImpl();
    }

    public Rule loadRule(RuleDefinition validationRuleDefinition) {
        if (validationRuleDefinition == null) {
            throw new RiceIllegalArgumentException("validationRuleDefinition must not be null");
        }
        if (validationRuleDefinition.getAttributes() == null) {
            throw new RiceIllegalArgumentException("validationRuleDefinition must not be null");
        }
        if (!validationRuleDefinition.getAttributes().containsKey("ruleTypeCode")) {
            throw new RiceIllegalArgumentException("validationRuleDefinition does not contain an ruleTypeCode attribute");
        }
        String validationRuleTypeCode = (String)validationRuleDefinition.getAttributes().get("ruleTypeCode");
        if (StringUtils.isBlank((String)validationRuleTypeCode)) {
            throw new RiceIllegalArgumentException("ruleTypeCode attribute must not be null or blank");
        }
        if (ValidationRuleType.VALID.getCode().equals(validationRuleTypeCode)) {
            return new ValidationRule(ValidationRuleType.VALID, validationRuleDefinition.getName(), this.translator.translatePropositionDefinition(validationRuleDefinition.getProposition()), this.translator.translateActionDefinitions(validationRuleDefinition.getActions()));
        }
        if (ValidationRuleType.INVALID.getCode().equals(validationRuleTypeCode)) {
            return new ValidationRule(ValidationRuleType.INVALID, validationRuleDefinition.getName(), this.translator.translatePropositionDefinition(validationRuleDefinition.getProposition()), this.translator.translateActionDefinitions(validationRuleDefinition.getActions()));
        }
        return null;
    }

    public void setRepositoryToEngineTranslator(RepositoryToEngineTranslator translator) {
        this.translator = translator;
    }

    @Override
    public List<RemotableAttributeField> getAttributeFields(@WebParam(name="krmsTypeId") String krmsTypeId) throws RiceIllegalArgumentException {
        TreeMap<String, String> keyLabels = new TreeMap<String, String>();
        keyLabels.put(ValidationRuleType.VALID.getCode(), "Action Executed When False");
        keyLabels.put(ValidationRuleType.INVALID.getCode(), "Action Executed When True");
        return this.getAttributeFields(krmsTypeId, keyLabels);
    }

    private List<RemotableAttributeField> getAttributeFields(@WebParam(name="krmsTypeId") String krmsTypeId, Map<String, String> keyLabels) throws RiceIllegalArgumentException {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsTypeId must be a valid id of a KRMS type");
        }
        List typeAttributes = krmsType.getAttributes();
        if (!CollectionUtils.isEmpty((Collection)typeAttributes)) {
            KrmsTypeRepositoryService typeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
            RadioButtonTypeServiceUtil util = new RadioButtonTypeServiceUtil();
            for (KrmsTypeAttribute typeAttribute : typeAttributes) {
                KrmsAttributeDefinition attributeDefinition = typeRepositoryService.getAttributeDefinitionById(typeAttribute.getAttributeDefinitionId());
                if (!"ruleTypeCode".equals(attributeDefinition.getName())) continue;
                RemotableAttributeField attributeField = util.translateTypeAttribute(attributeDefinition, keyLabels);
                results.add(attributeField);
            }
        }
        return results;
    }
}

