/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

public class HtmlMainIndexPage
extends HtmlFormatter {
    private static HtmlMainIndexPage instance = new HtmlMainIndexPage();
    private final NumberFormat integerFormatter = NumberFormat.getIntegerInstance();

    private HtmlMainIndexPage() {
    }

    public static HtmlMainIndexPage getInstance() {
        return instance;
    }

    public void write(Database database, Collection<Table> collection, Collection<Table> collection2, LineWriter lineWriter) throws IOException {
        Comparator<Table> comparator = new Comparator<Table>(this){

            @Override
            public int compare(Table table, Table table2) {
                return table.compareTo(table2);
            }
        };
        TreeSet<Table> treeSet = new TreeSet<Table>(comparator);
        treeSet.addAll(collection);
        collection = treeSet;
        treeSet = new TreeSet<Table>(comparator);
        treeSet.addAll(collection2);
        collection2 = treeSet;
        treeSet = null;
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        for (Table table : collection) {
            if (table.isView()) {
                ++n;
            }
            bl |= table.getId() != null;
            if (table.getComments() == null) continue;
            bl2 = true;
        }
        this.writeLocalsHeader(database, collection.size() - n, n, bl, bl2, lineWriter);
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        for (Table table : collection) {
            this.writeLineItem(table, bl, lineWriter);
            if (!table.isView()) {
                n2 += table.getColumns().size();
            } else {
                n3 += table.getColumns().size();
            }
            l += table.getNumRows() > 0L ? table.getNumRows() : 0L;
        }
        this.writeLocalsFooter(collection.size() - n, n2, n, n3, l, lineWriter);
        if (!collection2.isEmpty()) {
            this.writeRemotesHeader(database, bl, bl2, lineWriter);
            for (Table table : collection2) {
                this.writeLineItem(table, bl, lineWriter);
            }
            this.writeRemotesFooter(lineWriter);
        }
        this.writeFooter(lineWriter);
    }

    private void writeLocalsHeader(Database database, int n, int n2, boolean bl, boolean bl2, LineWriter lineWriter) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("$(function(){");
        arrayList.add("  associate($('#showTables'), $('.tbl'));");
        arrayList.add("  associate($('#showViews'),  $('.view'));");
        arrayList.add("  jQuery.fn.alternateRowColors = function() {");
        arrayList.add("    $('tbody tr:visible').each(function(i) {");
        arrayList.add("      if (i % 2 == 0) {");
        arrayList.add("        $(this).removeClass('even').addClass('odd');");
        arrayList.add("      } else {");
        arrayList.add("        $(this).removeClass('odd').addClass('even');");
        arrayList.add("      }");
        arrayList.add("    });");
        arrayList.add("    return this;");
        arrayList.add("  };");
        arrayList.add("  $('#showTables, #showViews').click(function() {");
        arrayList.add("    $('table.dataTable').alternateRowColors();");
        arrayList.add("  });");
        arrayList.add("  $('table.dataTable').alternateRowColors();");
        arrayList.add("})");
        this.writeHeader(database, null, null, arrayList, lineWriter);
        lineWriter.writeln("<table width='100%'>");
        lineWriter.writeln(" <tr><td class='container'>");
        this.writeGeneratedOn(database.getConnectTime(), lineWriter);
        lineWriter.writeln(" </td></tr>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='container'>Database Type: ");
        lineWriter.write(database.getDatabaseProduct());
        lineWriter.writeln("  </td>");
        lineWriter.writeln("  <td class='container' align='right' valign='top' rowspan='3'>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("    <a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a><br>");
        }
        lineWriter.writeln("    <br>");
        lineWriter.writeln("  </td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='container'>");
        Object object = database.getName();
        if (database.getSchema() != null) {
            object = (String)object + "." + database.getSchema();
        } else if (database.getCatalog() != null) {
            object = (String)object + "." + database.getCatalog();
        }
        lineWriter.write("<br><a href='" + (String)object + ".xml' title='XML Representation'>XML Representation</a>");
        lineWriter.write("<br><a href='insertionOrder.txt' title='Useful for loading data into a database'>Insertion Order</a>&nbsp;");
        lineWriter.write("<a href='deletionOrder.txt' title='Useful for purging data from a database'>Deletion Order</a>");
        lineWriter.writeln("</td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<div class='indent'>");
        lineWriter.write("<p>");
        lineWriter.write("<b>");
        if (n2 == 0) {
            lineWriter.writeln("<label for='showTables' style='display:none;'><input type='checkbox' id='showTables' checked></label>");
        } else if (n == 0) {
            lineWriter.writeln("<label for='showViews' style='display:none;'><input type='checkbox' id='showViews' checked></label>");
        } else {
            lineWriter.write("<label for='showTables'><input type='checkbox' id='showTables' checked>Tables</label>");
            lineWriter.write(" <label for='showViews'><input type='checkbox' id='showViews' checked>Views</label>");
        }
        lineWriter.writeln(" <label for='showComments'><input type=checkbox " + (bl2 ? "checked " : "") + "id='showComments'>Comments</label>");
        lineWriter.writeln("</b>");
        lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
        int n3 = 4 + (bl ? 1 : 0) + (this.displayNumRows ? 1 : 0);
        for (int i = 0; i < n3; ++i) {
            lineWriter.writeln("<colgroup>");
        }
        lineWriter.writeln("<colgroup class='comment'>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        String string = n2 == 0 ? "Table" : (n == 0 ? "View" : "Table / View");
        lineWriter.writeln("  <th valign='bottom'>" + string + "</th>");
        if (bl) {
            lineWriter.writeln("  <th align='center' valign='bottom'>ID</th>");
        }
        lineWriter.writeln("  <th align='right' valign='bottom'>Children</th>");
        lineWriter.writeln("  <th align='right' valign='bottom'>Parents</th>");
        lineWriter.writeln("  <th align='right' valign='bottom'>Columns</th>");
        if (this.displayNumRows) {
            lineWriter.writeln("  <th align='right' valign='bottom'>Rows</th>");
        }
        lineWriter.writeln("  <th class='comment' align='left' valign='bottom'>Comments</th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
        lineWriter.writeln("<tbody>");
    }

    private void writeRemotesHeader(Database database, boolean bl, boolean bl2, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<p><br><b>Related tables in other schemas</b>");
        lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
        int n = 3 + (bl ? 1 : 0);
        for (int i = 0; i < n; ++i) {
            lineWriter.writeln("<colgroup>");
        }
        lineWriter.writeln("<colgroup class='comment'>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        lineWriter.writeln("  <th rowspan='2'>Table</th>");
        if (bl) {
            lineWriter.writeln("  <th align='center' valign='bottom' rowspan='2'>ID</th>");
        }
        lineWriter.writeln("  <th valign='bottom' colspan='2' style='text-align: center;'>In this schema</th>");
        lineWriter.writeln("  <th class='comment' align='left' valign='bottom' rowspan='2'>Comments</th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("<tr>");
        lineWriter.writeln("  <th align='right' valign='bottom'>Children</th>");
        lineWriter.writeln("  <th align='right' valign='bottom'>Parents</th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
        lineWriter.writeln("<tbody>");
    }

    private void writeLineItem(Table table, boolean bl, LineWriter lineWriter) throws IOException {
        lineWriter.write(" <tr class='" + (table.isView() ? "view" : "tbl") + "' valign='top'>");
        lineWriter.write("  <td class='detail'>");
        String string = table.getName();
        if (table.isRemote() && !Config.getInstance().isOneOfMultipleSchemas()) {
            lineWriter.write(table.getContainer());
            lineWriter.write(46);
            lineWriter.write(string);
        } else {
            if (table.isRemote()) {
                lineWriter.write("<a href='../" + HtmlMainIndexPage.urlEncode(table.getContainer()) + "/index.html'>");
                lineWriter.write(table.getContainer());
                lineWriter.write("</a>.");
            }
            lineWriter.write("<a href='tables/");
            if (table.isRemote()) {
                lineWriter.write("../../" + HtmlMainIndexPage.urlEncode(table.getContainer()) + "/tables/");
            }
            lineWriter.write(HtmlMainIndexPage.urlEncode(string));
            lineWriter.write(".html'>");
            lineWriter.write(string);
            lineWriter.write("</a>");
        }
        lineWriter.writeln("</td>");
        if (bl) {
            lineWriter.write("  <td class='detail' align='right'>");
            Object object = table.getId();
            if (object != null) {
                lineWriter.write(String.valueOf(object));
            } else {
                lineWriter.writeln("&nbsp;");
            }
            lineWriter.writeln("</td>");
        }
        lineWriter.write("  <td class='detail' align='right'>");
        int n = table.getNumNonImpliedChildren();
        if (n != 0) {
            lineWriter.write(String.valueOf(this.integerFormatter.format(n)));
        }
        lineWriter.writeln("</td>");
        lineWriter.write("  <td class='detail' align='right'>");
        n = table.getNumNonImpliedParents();
        if (n != 0) {
            lineWriter.write(String.valueOf(this.integerFormatter.format(n)));
        }
        lineWriter.writeln("</td>");
        if (!table.isRemote()) {
            lineWriter.write("  <td class='detail' align='right'>");
            lineWriter.write(String.valueOf(this.integerFormatter.format(table.getColumns().size())));
            lineWriter.writeln("</td>");
            if (this.displayNumRows) {
                lineWriter.write("  <td class='detail' align='right'>");
                if (!table.isView()) {
                    if (table.getNumRows() >= 0L) {
                        lineWriter.write(String.valueOf(this.integerFormatter.format(table.getNumRows())));
                    } else {
                        lineWriter.write("<span title='Row count not available'>&nbsp;</span>");
                    }
                } else {
                    lineWriter.write("<span title='Views contain no real rows'>view</span>");
                }
                lineWriter.writeln("</td>");
            }
        }
        lineWriter.write("  <td class='comment detail'>");
        String string2 = table.getComments();
        if (string2 != null) {
            if (this.encodeComments) {
                for (int i = 0; i < string2.length(); ++i) {
                    lineWriter.write(HtmlEncoder.encodeToken(string2.charAt(i)));
                }
            } else {
                lineWriter.write(string2);
            }
        }
        lineWriter.writeln("</td>");
        lineWriter.writeln("  </tr>");
    }

    protected void writeLocalsFooter(int n, int n2, int n3, int n4, long l, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("  <tr>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        if (this.displayNumRows) {
            lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        }
        lineWriter.writeln("    <td class='comment detail'>&nbsp;</td>");
        lineWriter.writeln("  </tr>");
        String string = n == 1 ? " Table" : " Tables";
        lineWriter.writeln("  <tr class='tbl'>");
        lineWriter.writeln("    <td class='detail'><b>" + this.integerFormatter.format(n) + string + "</b></td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail' align='right'><b>" + this.integerFormatter.format(n2) + "</b></td>");
        if (this.displayNumRows) {
            lineWriter.writeln("    <td class='detail' align='right'><b>" + this.integerFormatter.format(l) + "</b></td>");
        }
        lineWriter.writeln("    <td class='comment detail'>&nbsp;</td>");
        lineWriter.writeln("  </tr>");
        string = n3 == 1 ? " View" : " Views";
        lineWriter.writeln("  <tr class='view'>");
        lineWriter.writeln("    <td class='detail'><b>" + this.integerFormatter.format(n3) + string + "</b></td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        lineWriter.writeln("    <td class='detail' align='right'><b>" + this.integerFormatter.format(n4) + "</b></td>");
        if (this.displayNumRows) {
            lineWriter.writeln("    <td class='detail'>&nbsp;</td>");
        }
        lineWriter.writeln("    <td class='comment detail'>&nbsp;</td>");
        lineWriter.writeln("  </tr>");
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
    }

    protected void writeRemotesFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
    }

    @Override
    protected boolean isMainIndex() {
        return true;
    }
}

