/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.util.Collection;
import java.util.stream.Collectors;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.extensibility.EventTelemetryModel;

public class MigrateTelemetryModel
extends EventTelemetryModel {
    private Collection<String> migrationCategories;
    private Collection<String> migrationTypes;
    private int migrationsExecuted;
    private boolean success;
    private int warningCount;

    public MigrateTelemetryModel(FlywayTelemetryManager flywayTelemetryManager) {
        super("migrate", flywayTelemetryManager);
    }

    public void setFromMigrateResult(MigrateResult result) {
        this.migrationCategories = result.migrations.stream().map(m -> m.category).collect(Collectors.toSet());
        this.migrationTypes = result.migrations.stream().map(m -> m.type).collect(Collectors.toSet());
        this.migrationsExecuted = result.migrationsExecuted;
        this.success = result.success;
        this.warningCount = result.warnings.size();
    }

    public Collection<String> getMigrationCategories() {
        return this.migrationCategories;
    }

    public Collection<String> getMigrationTypes() {
        return this.migrationTypes;
    }

    public int getMigrationsExecuted() {
        return this.migrationsExecuted;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

