/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.widget.Help;
import org.kuali.rice.krad.uif.widget.Tooltip;

public abstract class ContainerBase
extends ComponentBase
implements Container {
    private static final long serialVersionUID = -4182226230601746657L;
    private int defaultItemPosition = 1;
    private Help help;
    private LayoutManager layoutManager;
    private Header header;
    private Group footer;
    private String instructionalText;
    private Message instructionalMessage;
    @DelayedCopy
    private ValidationMessages validationMessages;
    private String enterKeyAction;

    @Override
    public boolean isProcessRemoteFieldHolders() {
        return true;
    }

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if ((StringUtils.isNotBlank((String)this.instructionalText) || this.getPropertyExpression("instructionalText") != null) && this.instructionalMessage == null) {
            this.instructionalMessage = ComponentFactory.getInstructionalMessage();
        }
        if (this.layoutManager != null && !this.getItems().isEmpty()) {
            this.layoutManager.performInitialization(model);
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.instructionalMessage != null && StringUtils.isBlank((String)this.instructionalMessage.getMessageText())) {
            this.instructionalMessage.setMessageText(this.instructionalText);
        }
        if (this.layoutManager != null && !this.getItems().isEmpty()) {
            this.layoutManager.performApplyModel(model, this);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.header != null) {
            this.header.addDataAttribute("header_for", this.getId());
        }
        if (this.layoutManager != null && !this.getItems().isEmpty()) {
            this.layoutManager.performFinalize(model, this);
        }
        if (this.validationMessages != null) {
            this.validationMessages.generateMessages(ViewLifecycle.getView(), model, this);
        }
        if (this.getEnterKeyAction() != null && StringUtils.isNotBlank((String)this.getEnterKeyAction())) {
            this.addDataAttribute("enter_key", this.getEnterKeyAction());
        }
    }

    @Override
    public List<String> getAdditionalTemplates() {
        List<String> additionalTemplates = super.getAdditionalTemplates();
        if (this.layoutManager != null) {
            if (additionalTemplates.isEmpty()) {
                additionalTemplates = new ArrayList<String>();
            }
            additionalTemplates.add(this.layoutManager.getTemplate());
        }
        return additionalTemplates;
    }

    @Override
    public void sortItems() {
        List<? extends Component> sortedItems = ComponentUtils.sort(this.getItems(), this.defaultItemPosition);
        this.setItems(sortedItems);
    }

    @Override
    @ViewLifecycleRestriction
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public ValidationMessages getValidationMessages() {
        return this.validationMessages;
    }

    @Override
    public void setValidationMessages(ValidationMessages validationMessages) {
        this.validationMessages = validationMessages;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Help getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(Help help) {
        this.help = help;
    }

    @Override
    public void setTooltipOfComponent(Tooltip tooltip) {
        this.getHeader().setToolTip(tooltip);
    }

    @Override
    public String getHelpTitle() {
        return this.getHeader().getHeaderText();
    }

    @Override
    @BeanTagAttribute
    public abstract List<? extends Component> getItems();

    @Override
    public abstract void setItems(List<? extends Component> var1);

    @BeanTagAttribute
    public int getDefaultItemPosition() {
        return this.defaultItemPosition;
    }

    public void setDefaultItemPosition(int defaultItemPosition) {
        this.defaultItemPosition = defaultItemPosition;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.BYTYPE)
    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECT)
    public Group getFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(Group footer) {
        this.footer = footer;
    }

    public void setRenderHeader(boolean renderHeader) {
        if (this.header != null) {
            this.header.setRender(renderHeader);
        }
    }

    @BeanTagAttribute
    public String getHeaderText() {
        if (this.header != null && this.header.getHeaderText() != null) {
            return this.header.getHeaderText();
        }
        return "";
    }

    public void setHeaderText(String headerText) {
        if (this.header != null) {
            this.header.setHeaderText(headerText);
        }
    }

    public void setRenderFooter(boolean renderFooter) {
        if (this.footer != null) {
            this.footer.setRender(renderFooter);
        }
    }

    @BeanTagAttribute
    public String getInstructionalText() {
        return this.instructionalText;
    }

    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    @Override
    @BeanTagAttribute
    public Message getInstructionalMessage() {
        return this.instructionalMessage;
    }

    @Override
    public void setInstructionalMessage(Message instructionalMessage) {
        this.instructionalMessage = instructionalMessage;
    }

    @Override
    @BeanTagAttribute
    public String getEnterKeyAction() {
        return this.enterKeyAction;
    }

    @Override
    public void setEnterKeyAction(String enterKeyAction) {
        this.enterKeyAction = enterKeyAction;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getInstructionalText() != null && this.getInstructionalMessage() != null) {
            String[] currentValues = new String[]{"instructionalMessage.text = " + this.getInstructionalMessage().getMessageText(), "instructionalText = " + this.getInstructionalText()};
            tracer.createWarning("InstructionalMessage will override instructioanlText", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

