/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.view.ViewSessionPolicy;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.web.bind.annotation.RequestMethod;

public class UifSessionTimeoutFilter
implements Filter {
    private int sessionTimeoutErrorCode = 403;

    public void init(FilterConfig filterConfig) throws ServletException {
        String timeoutErrorCode = filterConfig.getInitParameter("sessionTimeoutErrorCode");
        if (timeoutErrorCode != null) {
            this.sessionTimeoutErrorCode = Integer.parseInt(timeoutErrorCode);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filerChain) throws IOException, ServletException {
        UifFormManager uifFormManager;
        String viewId;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpServletRequest.getSession(false);
        boolean timeoutOccurred = false;
        if (request.getParameter("sessionId") != null) {
            String requestedSessionId = request.getParameter("sessionId");
            if (httpSession == null || !StringUtils.equals((String)httpSession.getId(), (String)requestedSessionId)) {
                timeoutOccurred = true;
            }
        }
        if (StringUtils.isBlank((String)(viewId = this.getViewIdFromRequest(httpServletRequest)))) {
            filerChain.doFilter(request, response);
            return;
        }
        boolean isGetRequest = RequestMethod.GET.name().equals(httpServletRequest.getMethod());
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((String)formKeyParam) && !isGetRequest && this.getViewDictionaryService().isSessionStorageEnabled(viewId) && httpSession != null && (uifFormManager = (UifFormManager)httpSession.getAttribute("formManager")) != null && !uifFormManager.hasSessionForm(formKeyParam)) {
            timeoutOccurred = true;
        }
        if (!timeoutOccurred) {
            filerChain.doFilter(request, response);
            return;
        }
        ViewSessionPolicy sessionPolicy = this.getViewDictionaryService().getViewSessionPolicy(viewId);
        if (sessionPolicy.isRedirectToHome() || StringUtils.isNotBlank((String)sessionPolicy.getRedirectUrl()) || sessionPolicy.isRenderTimeoutView()) {
            String redirectUrl = this.getRedirectUrl(sessionPolicy, httpServletRequest);
            this.sendRedirect(httpServletRequest, (HttpServletResponse)response, redirectUrl);
        }
    }

    protected String getViewIdFromRequest(HttpServletRequest request) {
        String viewId = request.getParameter("viewId");
        if (StringUtils.isBlank((String)viewId)) {
            String viewTypeName = request.getParameter("viewTypeName");
            UifConstants.ViewType viewType = null;
            if (StringUtils.isNotBlank((String)viewTypeName)) {
                viewType = UifConstants.ViewType.valueOf(viewTypeName);
            }
            if (viewType != null) {
                Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
                viewId = UifSessionTimeoutFilter.getViewService().getViewIdForViewType(viewType, parameterMap);
            }
        }
        if (StringUtils.isNotBlank((String)viewId)) {
            request.setAttribute("viewId", (Object)viewId);
        }
        return viewId;
    }

    protected String getRedirectUrl(ViewSessionPolicy sessionPolicy, HttpServletRequest httpServletRequest) {
        String redirectUrl = null;
        if (sessionPolicy.isRedirectToHome()) {
            redirectUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        } else if (StringUtils.isNotBlank((String)sessionPolicy.getRedirectUrl())) {
            redirectUrl = sessionPolicy.getRedirectUrl();
        } else if (sessionPolicy.isRenderTimeoutView()) {
            String kradUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.url");
            redirectUrl = KRADUtils.buildViewUrl(kradUrl, "sessionTimout", "Uif-SessionTimeoutView");
        }
        return redirectUrl;
    }

    protected void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String redirectUrl) throws IOException {
        boolean ajaxRequest = false;
        String ajaxHeader = httpServletRequest.getHeader("x-requested-with");
        if ("XMLHttpRequest".equals(ajaxHeader)) {
            ajaxRequest = true;
        }
        if (ajaxRequest) {
            httpServletResponse.setContentType("text/html; charset=UTF-8");
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.setStatus(this.sessionTimeoutErrorCode);
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(redirectUrl);
            printWriter.flush();
        } else {
            httpServletResponse.sendRedirect(redirectUrl);
        }
    }

    protected static ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    protected ViewDictionaryService getViewDictionaryService() {
        return KRADServiceLocatorWeb.getViewDictionaryService();
    }

    public void destroy() {
    }
}

