/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.LongDataPacket;
import org.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;

public final class ExecutePacket
implements RedoableWithPrepareClientMessage {
    private final String command;
    private final ServerPreparedStatement prep;
    private final InputStream localInfileInputStream;
    private Prepare prepareResult;
    private Parameters parameters;

    public ExecutePacket(Prepare prepareResult, Parameters parameters, String command, ServerPreparedStatement prep, InputStream localInfileInputStream) {
        this.parameters = parameters;
        this.prepareResult = prepareResult;
        this.command = command;
        this.prep = prep;
        this.localInfileInputStream = localInfileInputStream;
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            org.mariadb.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public int encode(Writer writer, Context context, Prepare newPrepareResult) throws IOException, SQLException {
        int statementId = newPrepareResult != null && newPrepareResult.getStatementId() != -1 ? newPrepareResult.getStatementId() : (this.prepareResult != null ? this.prepareResult.getStatementId() : -1);
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            org.mariadb.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            new LongDataPacket(statementId, p, i).encode(writer, context);
        }
        writer.initPacket();
        writer.writeByte(23);
        writer.writeInt(statementId);
        writer.writeByte(0);
        writer.writeInt(1);
        if (parameterCount > 0) {
            org.mariadb.jdbc.client.util.Parameter p;
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            int initialPos = writer.pos();
            writer.pos(initialPos + nullCount);
            writer.writeByte(1);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                writer.writeByte(p.getBinaryEncodeType());
                writer.writeByte(0);
                if (!p.isNull()) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | (byte)(1 << i % 8));
            }
            writer.writeBytesAtPos(nullBitsBuffer, initialPos);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                if (p.isNull() || p.canEncodeLongData()) continue;
                p.encodeBinary(writer, context);
            }
        }
        writer.flush();
        return 1;
    }

    @Override
    public boolean canSkipMeta() {
        return true;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String description() {
        return "EXECUTE " + this.command;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.command, this.parameters, fileName, context);
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

