/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.users;

import com.codiform.moo.curry.Translate;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.impl.users.UserDTO;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="researchUsersRestController")
public class ResearchUsersRestController
extends RestController {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    @RequestMapping(value={"/api/v1/research-users/current/"}, method={RequestMethod.GET})
    @ResponseBody
    public UserDTO getCurrentResearchUser() throws Exception {
        String principalId = this.globalVariableService.getUserSession().getPrincipalId();
        KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(principalId);
        return this.convertToUserDTO(kcPerson);
    }

    protected UserDTO convertToUserDTO(KcPersonContract kcPerson) {
        return (UserDTO)Translate.to(UserDTO.class).from((Object)kcPerson);
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

