/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.sequence.associate.SequenceAssociate;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.excon.project.ExconProject;

public abstract class ExconProjectAssociate
extends KcPersistableBusinessObjectBase
implements SequenceAssociate<ExconProject>,
Serializable {
    private static final long serialVersionUID = -1966175324490120727L;
    private String projectNumber;
    private Integer sequenceNumber;
    private ExconProject exconProject;

    public String getProjectNumber() {
        return this.projectNumber;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ExconProject getExconProject() {
        return this.exconProject;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setExconProject(ExconProject exconProject) {
        this.exconProject = exconProject;
        if (exconProject != null) {
            this.setSequenceNumber(exconProject.getSequenceNumber());
            this.setProjectNumber(exconProject.getProjectNumber());
        } else {
            this.setSequenceNumber(0);
            this.setProjectNumber("");
        }
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        if (this.exconProject != null && !StringUtils.equals((CharSequence)this.exconProject.getProjectNumber(), (CharSequence)this.getProjectNumber())) {
            this.setSequenceNumber(this.exconProject.getSequenceNumber());
            this.setProjectNumber(this.exconProject.getProjectNumber());
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.projectNumber == null ? 0 : this.projectNumber.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExconProjectAssociate)) {
            return false;
        }
        ExconProjectAssociate other = (ExconProjectAssociate)obj;
        if (this.projectNumber == null ? other.projectNumber != null : !this.projectNumber.equals(other.projectNumber)) {
            return false;
        }
        return !(this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber));
    }

    @Override
    public ExconProject getSequenceOwner() {
        return this.getExconProject();
    }

    @Override
    public void setSequenceOwner(ExconProject newlyVersionedOwner) {
        this.setExconProject(newlyVersionedOwner);
    }
}

