/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.cache;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

@XmlRootElement(name="cacheTarget")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CacheTargetType", propOrder={"cache", "key", "_futureElements"})
public final class CacheTarget
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -7143135771254777648L;
    @XmlElement(name="cache", required=true)
    private final String cache;
    @XmlElement(name="key", required=false)
    private final String key;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private CacheTarget() {
        this.cache = null;
        this.key = null;
    }

    private CacheTarget(String cache, String key) {
        if (StringUtils.isBlank((String)cache)) {
            throw new IllegalArgumentException("cache is blank or null");
        }
        this.cache = cache;
        this.key = key;
    }

    public static CacheTarget entireCache(String cache) {
        return new CacheTarget(cache, null);
    }

    public static CacheTarget singleEntry(String cache, String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("a blank or null key does not target a single entry");
        }
        return new CacheTarget(cache, key);
    }

    public boolean containsKey() {
        return this.key != null;
    }

    public String getCache() {
        return this.cache;
    }

    public String getKey() {
        return this.key;
    }

    static class Elements {
        static final String CACHE = "cache";
        static final String KEY = "key";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "cacheTarget";
        static final String TYPE_NAME = "CacheTargetType";

        Constants() {
        }
    }
}

