/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.system.globalLibraryV20.AddressDataType;
import gov.grants.apply.system.globalLibraryV20.AddressDataTypeV3;
import gov.grants.apply.system.globalLibraryV20.ContactPersonDataType;
import gov.grants.apply.system.globalLibraryV20.ContactPersonDataTypeV3;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.universalCodesV20.CountryCodeDataType;
import gov.grants.apply.system.universalCodesV20.CountryCodeDataTypeV3;
import gov.grants.apply.system.universalCodesV20.StateCodeDataType;
import gov.grants.apply.system.universalCodesV20.StateCodeDataTypeV3;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.country.CountryContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.state.StateContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.location.S2SLocationService;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@FormGenerator(value="GlobalLibraryV2_0Generator")
public class GlobalLibraryV2_0Generator {
    private static final int PRIMARY_TITLE_MAX_LENGTH = 45;
    @Autowired
    @Qualifier(value="s2SLocationService")
    private S2SLocationService s2SLocationService;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    private DepartmentalPersonService departmentalPersonService;

    public Optional<CountryCodeDataType.Enum> getCountryCodeDataType(String countryCode) {
        CountryContract country = this.s2SLocationService.getCountryFromCode(countryCode);
        if (country != null && StringUtils.isNotBlank((CharSequence)country.getName())) {
            String matchValue = String.format("%s: %s", country.getAlternateCode(), country.getName());
            for (int i = 1; i <= CountryCodeDataType.Enum.table.lastInt(); ++i) {
                CountryCodeDataType.Enum countryEnum = CountryCodeDataType.Enum.forInt(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)countryEnum.toString(), (CharSequence)matchValue)) continue;
                return Optional.of(countryEnum);
            }
        }
        return Optional.empty();
    }

    public Optional<CountryCodeDataTypeV3.Enum> getCountryCodeDataTypeV3(String countryCode) {
        CountryContract country = this.s2SLocationService.getCountryFromCode(countryCode);
        if (country != null && StringUtils.isNotBlank((CharSequence)country.getNameV3())) {
            String matchValue = String.format("%s: %s", country.getAlternateCode(), country.getNameV3());
            for (int i = 1; i <= CountryCodeDataTypeV3.Enum.table.lastInt(); ++i) {
                CountryCodeDataTypeV3.Enum countryEnum = CountryCodeDataTypeV3.Enum.forInt(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)countryEnum.toString(), (CharSequence)matchValue)) continue;
                return Optional.of(countryEnum);
            }
        }
        return Optional.empty();
    }

    private static Optional<CountryCodeDataTypeV3.Enum> getMatchingCountryV3Enum(String code, String name) {
        String matchValue = String.format("%s: %s", code, name);
        for (int i = 1; i <= CountryCodeDataTypeV3.Enum.table.lastInt(); ++i) {
            CountryCodeDataTypeV3.Enum countryEnum = CountryCodeDataTypeV3.Enum.forInt(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)countryEnum.toString(), (CharSequence)matchValue)) continue;
            return Optional.of(countryEnum);
        }
        return Optional.empty();
    }

    public Optional<StateCodeDataType.Enum> getStateCodeDataType(String countryAlternateCode, String stateCode) {
        StateContract state = this.s2SLocationService.getStateFromCode(countryAlternateCode, stateCode);
        if (state != null && StringUtils.isNotBlank((CharSequence)state.getName())) {
            String matchValue = String.format("%s: %s", stateCode, state.getName());
            for (int i = 1; i <= StateCodeDataType.Enum.table.lastInt(); ++i) {
                StateCodeDataType.Enum stateEnum = StateCodeDataType.Enum.forInt(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)stateEnum.toString(), (CharSequence)matchValue)) continue;
                return Optional.of(stateEnum);
            }
        }
        return Optional.empty();
    }

    public Optional<StateCodeDataTypeV3.Enum> getStateCodeDataTypeV3(String countryAlternateCode, String stateCode) {
        StateContract state = this.s2SLocationService.getStateFromCode(countryAlternateCode, stateCode);
        if (state != null && StringUtils.isNotBlank((CharSequence)state.getNameV3())) {
            String matchValue = String.format("%s: %s", stateCode, state.getNameV3());
            for (int i = 1; i <= StateCodeDataTypeV3.Enum.table.lastInt(); ++i) {
                StateCodeDataTypeV3.Enum stateEnum = StateCodeDataTypeV3.Enum.forInt(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)stateEnum.toString(), (CharSequence)matchValue)) continue;
                return Optional.of(stateEnum);
            }
        }
        return Optional.empty();
    }

    public AddressDataType getAddressDataType(Addressable addressable) {
        AddressDataType addressDataType = (AddressDataType)AddressDataType.Factory.newInstance();
        if (addressable != null) {
            String postalCode;
            String street1 = addressable.getAddressLine1();
            addressDataType.setStreet1(Transformers.truncateStreetAddress(street1));
            String street2 = addressable.getAddressLine2();
            if (StringUtils.isNotBlank((CharSequence)street2)) {
                addressDataType.setStreet2(street2);
            }
            String city = addressable.getCity();
            addressDataType.setCity(city);
            String county = addressable.getCounty();
            if (StringUtils.isNotBlank((CharSequence)county)) {
                addressDataType.setCounty(county);
            }
            if (StringUtils.isNotBlank((CharSequence)(postalCode = addressable.getPostalCode()))) {
                addressDataType.setZipPostalCode(postalCode);
            }
            this.setAddressEnums(addressDataType, addressable.getCountryCode(), addressable.getState());
        }
        return addressDataType;
    }

    private void setAddressEnums(AddressDataType address, String country, String state) {
        Optional<CountryCodeDataType.Enum> countryCodeDataType = this.getCountryCodeDataType(country);
        countryCodeDataType.ifPresent(address::setCountry);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            countryCodeDataType.filter(arg_0 -> CountryCodeDataType.USA_UNITED_STATES.equals(arg_0)).flatMap(countryEnum -> this.getStateCodeDataType(country, state)).ifPresentOrElse(address::setState, () -> address.setProvince(state));
        }
    }

    public AddressDataTypeV3 getAddressDataTypeV3(Addressable addressable) {
        AddressDataTypeV3 addressDataType = (AddressDataTypeV3)AddressDataTypeV3.Factory.newInstance();
        if (addressable != null) {
            String postalCode;
            String street1 = addressable.getAddressLine1();
            addressDataType.setStreet1(Transformers.truncateStreetAddress(street1));
            String street2 = addressable.getAddressLine2();
            if (StringUtils.isNotBlank((CharSequence)street2)) {
                addressDataType.setStreet2(street2);
            }
            String city = addressable.getCity();
            addressDataType.setCity(city);
            String county = addressable.getCounty();
            if (StringUtils.isNotBlank((CharSequence)county)) {
                addressDataType.setCounty(county);
            }
            if (StringUtils.isNotBlank((CharSequence)(postalCode = addressable.getPostalCode()))) {
                addressDataType.setZipPostalCode(postalCode);
            }
            this.setAddressEnumsV3(addressDataType, addressable.getCountryCode(), addressable.getState());
        }
        return addressDataType;
    }

    private void setAddressEnumsV3(AddressDataTypeV3 address, String country, String state) {
        Optional<CountryCodeDataTypeV3.Enum> countryCodeDataType = this.getCountryCodeDataTypeV3(country);
        countryCodeDataType.ifPresent(address::setCountry);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            countryCodeDataType.filter(arg_0 -> CountryCodeDataTypeV3.USA_UNITED_STATES.equals(arg_0)).flatMap(countryEnum -> this.getStateCodeDataTypeV3(country, state)).ifPresentOrElse(address::setState, () -> address.setProvince(state));
        }
    }

    public HumanNameDataType getHumanNameDataType(ProposalPersonContract person) {
        HumanNameDataType humanName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.isEmpty()) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(DepartmentalPersonDto person) {
        HumanNameDataType humanName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.isEmpty()) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(RolodexContract rolodex) {
        HumanNameDataType humanName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
        if (rolodex != null) {
            humanName.setFirstName(rolodex.getFirstName());
            humanName.setLastName(rolodex.getLastName());
            String middleName = rolodex.getMiddleName();
            if (middleName != null && !middleName.isEmpty()) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(S2SKeyPersonDto keyPerson) {
        HumanNameDataType humanName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
        if (keyPerson != null) {
            humanName.setFirstName(keyPerson.getFirstName());
            humanName.setLastName(keyPerson.getLastName());
            String middleName = keyPerson.getMiddleName();
            if (middleName != null && !middleName.isEmpty()) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public ContactPersonDataType getContactPersonDataType(ProposalPersonContract person) {
        ContactPersonDataType contactPerson = (ContactPersonDataType)ContactPersonDataType.Factory.newInstance();
        if (person != null) {
            String fax;
            String title;
            String email;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.isEmpty()) {
                contactPerson.setPhone(phone);
            }
            if ((email = person.getEmailAddress()) != null && !email.isEmpty()) {
                contactPerson.setEmail(email);
            }
            if ((title = person.getPrimaryTitle()) != null && !title.isEmpty()) {
                contactPerson.setTitle(title);
            }
            if (StringUtils.isNotEmpty((CharSequence)(fax = person.getFaxNumber()))) {
                contactPerson.setFax(fax);
            }
            contactPerson.setAddress(this.getAddressDataType((Addressable)person));
        }
        return contactPerson;
    }

    public ContactPersonDataTypeV3 getContactPersonDataTypeV3(ProposalPersonContract person) {
        ContactPersonDataTypeV3 contactPerson = (ContactPersonDataTypeV3)ContactPersonDataTypeV3.Factory.newInstance();
        if (person != null) {
            String fax;
            String title;
            String email;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.isEmpty()) {
                contactPerson.setPhone(phone);
            }
            if ((email = person.getEmailAddress()) != null && !email.isEmpty()) {
                contactPerson.setEmail(email);
            }
            if ((title = person.getPrimaryTitle()) != null && !title.isEmpty()) {
                contactPerson.setTitle(title);
            }
            if (StringUtils.isNotEmpty((CharSequence)(fax = person.getFaxNumber()))) {
                contactPerson.setFax(fax);
            }
            contactPerson.setAddress(this.getAddressDataTypeV3((Addressable)person));
        }
        return contactPerson;
    }

    public ContactPersonDataType getContactPersonDataType(ProposalDevelopmentDocumentContract proposalDocument) {
        DepartmentalPersonDto person = this.departmentalPersonService.getContactPerson(proposalDocument);
        return this.getContactPersonDataType(person);
    }

    public ContactPersonDataType getContactPersonDataType(DepartmentalPersonDto person) {
        ContactPersonDataType contactPerson = (ContactPersonDataType)ContactPersonDataType.Factory.newInstance();
        if (person != null) {
            String title;
            String email;
            String fax;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.isEmpty()) {
                contactPerson.setPhone(phone);
            }
            if (StringUtils.isNotEmpty((CharSequence)(fax = person.getFaxNumber()))) {
                contactPerson.setFax(fax);
            }
            if ((email = person.getEmailAddress()) != null && !email.isEmpty()) {
                contactPerson.setEmail(person.getEmailAddress());
            }
            if ((title = person.getPrimaryTitle()) != null && !title.isEmpty()) {
                contactPerson.setTitle(StringUtils.substring((String)title, (int)0, (int)45));
            }
            contactPerson.setAddress(this.getAddressDataType(person));
        }
        return contactPerson;
    }

    public ContactPersonDataTypeV3 getContactPersonDataTypeV3(ProposalDevelopmentDocumentContract proposalDocument) {
        DepartmentalPersonDto person = this.departmentalPersonService.getContactPerson(proposalDocument);
        return this.getContactPersonDataTypeV3(person);
    }

    public ContactPersonDataTypeV3 getContactPersonDataTypeV3(DepartmentalPersonDto person) {
        ContactPersonDataTypeV3 contactPerson = (ContactPersonDataTypeV3)ContactPersonDataTypeV3.Factory.newInstance();
        if (person != null) {
            String title;
            String email;
            String fax;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.isEmpty()) {
                contactPerson.setPhone(phone);
            }
            if (StringUtils.isNotEmpty((CharSequence)(fax = person.getFaxNumber()))) {
                contactPerson.setFax(fax);
            }
            if ((email = person.getEmailAddress()) != null && !email.isEmpty()) {
                contactPerson.setEmail(person.getEmailAddress());
            }
            if ((title = person.getPrimaryTitle()) != null && !title.isEmpty()) {
                contactPerson.setTitle(StringUtils.substring((String)title, (int)0, (int)45));
            }
            contactPerson.setAddress(this.getAddressDataTypeV3(person));
        }
        return contactPerson;
    }

    public S2SLocationService getS2SLocationService() {
        return this.s2SLocationService;
    }

    public void setS2SLocationService(S2SLocationService s2SLocationService) {
        this.s2SLocationService = s2SLocationService;
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }
}

