/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398Checklist13V13.PHS398Checklist13Document;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398ChecklistBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398ChecklistV1_3Generator")
public class PHS398ChecklistV1_3Generator
extends PHS398ChecklistBaseGenerator<PHS398Checklist13Document>
implements S2SFormGeneratorPdfFillable<PHS398Checklist13Document> {
    private static final Integer YNQANSWER_121 = 121;
    private static final int FEDERAL_ID_MAX_LENGTH = 30;
    List<? extends AnswerHeaderContract> answerHeaders;
    YesNoDataType.Enum ynqAnswer;
    @Value(value="http://apply.grants.gov/forms/PHS398_Checklist_1_3-V1.3")
    private String namespace;
    @Value(value="PHS398_Checklist_1_3-V1.3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_Checklist-V1.3.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_Checklist_1_3-V1.3.pdf")
    private Resource pdfForm;
    @Value(value="230")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private PHS398Checklist13Document getPHS398Checklist() {
        PHS398Checklist13Document phsChecklistDocument = (PHS398Checklist13Document)PHS398Checklist13Document.Factory.newInstance();
        PHS398Checklist13Document.PHS398Checklist13 phsChecklist = (PHS398Checklist13Document.PHS398Checklist13)PHS398Checklist13Document.PHS398Checklist13.Factory.newInstance();
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        this.setPhsCheckListBasicProperties(phsChecklist);
        this.setFormerPDNameAndIsChangeOfPDPI(phsChecklist);
        this.setFormerInstitutionNameAndChangeOfInstitution(phsChecklist);
        this.setIsInventionsAndPatentsAndIsPreviouslyReported(phsChecklist);
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            PHS398ChecklistV1_3Generator.setIncomeBudgetPeriods(phsChecklist, budget.getBudgetProjectIncomes());
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        }
        this.ynqAnswer = this.getYNQAnswer(YNQANSWER_121);
        phsChecklist.setDisclosurePermission(this.ynqAnswer);
        phsChecklistDocument.setPHS398Checklist13(phsChecklist);
        return phsChecklistDocument;
    }

    private void setPhsCheckListBasicProperties(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        phsChecklist.setFormVersion(FormVersion.v1_3.getVersion());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        PHS398Checklist13Document.PHS398Checklist13.ApplicationType.Enum applicationEnum = null;
        if (developmentProposal.getProposalType() != null && Integer.parseInt(developmentProposal.getProposalType().getCode()) < 6) {
            applicationEnum = PHS398Checklist13Document.PHS398Checklist13.ApplicationType.Enum.forInt(Integer.valueOf(developmentProposal.getProposalType().getCode()));
        }
        phsChecklist.setApplicationType(applicationEnum);
        String federalId = this.getSubmissionInfoService().getFederalId(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (federalId != null) {
            phsChecklist.setFederalID(StringUtils.left((String)federalId.trim(), (int)30));
        }
    }

    private static void setIncomeBudgetPeriods(PHS398Checklist13Document.PHS398Checklist13 phsChecklist, List<? extends BudgetProjectIncomeContract> projectIncomes) {
        if (projectIncomes.isEmpty()) {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.Y_YES);
        }
        phsChecklist.setIncomeBudgetPeriodArray(PHS398ChecklistV1_3Generator.getIncomeBudgetPeriod(projectIncomes));
    }

    private static PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod[] getIncomeBudgetPeriod(List<? extends BudgetProjectIncomeContract> projectIncomes) {
        TreeMap<Integer, PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod>();
        for (BudgetProjectIncomeContract budgetProjectIncomeContract : projectIncomes) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = budgetProjectIncomeContract.getBudgetPeriodNumber();
            PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod incomeBudgPeriod = (PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = (PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod)PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber);
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(budgetProjectIncomeContract.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = PHS398ChecklistV1_3Generator.getProjectIncomeDescription(budgetProjectIncomeContract);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        Collection incomeBudgetPeriodCollection = incomeBudgetPeriodMap.values();
        return incomeBudgetPeriodCollection.toArray(new PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod[0]);
    }

    protected static String getProjectIncomeDescription(BudgetProjectIncomeContract projectIncome) {
        String description = null;
        if (projectIncome.getDescription() != null) {
            description = projectIncome.getDescription().length() > 150 ? projectIncome.getDescription().substring(0, 150) : projectIncome.getDescription();
        }
        return description;
    }

    private void setIsInventionsAndPatentsAndIsPreviouslyReported(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_118, this.answerHeaders);
        if (answer != null && !answer.equals("No") && YnqConstant.YES.code().equals(answer)) {
            String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_119, this.answerHeaders);
            if (explanation != null && !explanation.equals("No")) {
                if (YnqConstant.YES.code().equals(explanation)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    String subQuestionExplanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_120, this.answerHeaders);
                    if (subQuestionExplanation != null && !subQuestionExplanation.equals("No")) {
                        if (YnqConstant.YES.code().equals(subQuestionExplanation)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.Y_YES);
                        } else if (YnqConstant.NO.code().equals(subQuestionExplanation)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                        }
                    } else {
                        phsChecklist.setIsPreviouslyReported(null);
                    }
                } else if (YnqConstant.NO.code().equals(explanation)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.N_NO);
                }
            } else {
                phsChecklist.setIsInventionsAndPatents(null);
            }
        }
    }

    private void setFormerInstitutionNameAndChangeOfInstitution(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_116, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_117, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (explanation != null) {
                phsChecklist.setFormerInstitutionName(explanation);
            } else {
                phsChecklist.setFormerInstitutionName(null);
            }
        } else {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
    }

    private void setFormerPDNameAndIsChangeOfPDPI(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_114, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_115, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (explanation != null) {
                RolodexContract rolodex = this.rolodexService.getRolodex(Integer.valueOf(explanation));
                HumanNameDataType formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex);
                if (formerPDName != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                    phsChecklist.setFormerPDName(formerPDName);
                }
            } else {
                phsChecklist.setFormerPDName(null);
            }
        } else {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
    }

    private YesNoDataType.Enum getYNQAnswer(Integer questionID) {
        YesNoDataType.Enum answerType = null;
        String answer = this.getAnswer(questionID, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            answerType = "Y".equals(answer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            return answerType;
        }
        return null;
    }

    @Override
    public PHS398Checklist13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398Checklist();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398Checklist13Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<PHS398Checklist13Document> factory() {
        return PHS398Checklist13Document.Factory;
    }
}

