/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionAnswerService;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class PHS398FellowshipSupplementalBaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    protected S2SProposalPersonService s2SProposalPersonService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    protected S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="questionAnswerService")
    protected QuestionAnswerService questionAnswerService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;
    protected static final String NSR_SUPPORT_NO = "No";
    protected static final String NSR_SUPPORT_YES = "Yes";
    protected static final String QUESTION_ANSWER_NO = "N";
    protected static final String QUESTION_ANSWER_YES = "Y";
    protected static final char STRING_SEPRATOR = '-';
    protected static final String SUB_CATEGORY_NOT_FOUND = "SUB CATEGORY NOT FOUND";
    protected static final int INTRODUCTION_TO_APPLICATION = 97;
    protected static final int SPECIFIC_AIMS = 98;
    protected static final int INCLUSION_ENROLLMENT_REPORT = 102;
    protected static final int PROGRESS_REPORT_PUBLICATION_LIST = 103;
    protected static final int PROTECTION_OF_HUMAN_SUBJECTS = 104;
    protected static final int INCLUSION_OF_WOMEN_AND_MINORITIES = 105;
    protected static final int TARGETED_PLANNED_ENROLLMENT = 106;
    protected static final int INCLUSION_OF_CHILDREN = 107;
    protected static final int VERTEBRATE_ANIMALS = 108;
    protected static final int SELECT_AGENT_RESEARCH = 109;
    protected static final int RESOURCE_SHARING_PLANS = 110;
    protected static final int RESPECTIVE_CONTRIBUTIONS = 88;
    protected static final int SELECTION_OF_SPONSOR_AND_INSTITUTION = 89;
    protected static final int RESPONSIBLE_CONDUCT_OF_RESEARCH = 90;
    protected static final int RESEARCH_STRATEGY = 127;
    protected static final int CONCURRENT_SUPPORT = 91;
    protected static final int FELLOWSHIP = 92;
    protected static final int DISSERTATION = 93;
    protected static final int ACTIVITIES = 94;
    private static final String APPENDIX = "96";
    protected static final int HUMAN = 1;
    protected static final int VERT = 4;
    protected static final int CLINICAL = 2;
    protected static final int PHASE3CLINICAL = 3;
    protected static final int STEMCELLS = 5;
    protected static final int KIRST_START_KNOWN = 43;
    protected static final int KIRST_END_KNOWN = 49;
    protected static final int KIRST_START_DT = 44;
    protected static final int KIRST_END_DT = 45;
    protected static final int KIRST_GRANT_KNOWN = 46;
    protected static final int KIRST_GRANT_NUM = 27;
    protected static final int PRE_OR_POST = 32;
    protected static final int IND_OR_INST = 33;
    protected static final int STEMCELLLINES = 7;
    protected static final int CELLLINEIND = 6;
    protected static final int DEG_EXP_COMP_DATE = 35;
    protected static final int NRSA_SUPPORT = 24;
    protected static final int FIELD_TRAINING = 22;
    protected static final int BROAD_TRAINING = 23;
    protected static final int OTHER_MASTERS = 16;
    protected static final int OTHER_DOCT = 17;
    protected static final int OTHER_DDOT = 18;
    protected static final int OTHER_VDOT = 19;
    protected static final int OTHER_MDOT = 21;
    protected static final int SUBMITTED_DIFF_INST = 28;
    protected static final int FORMER_INST = 29;
    protected static final int SENIOR_FELL = 36;
    protected static final int OTHER_SUPP_SOURCE = 37;
    protected static final int SUPP_FUNDING_AMT = 38;
    protected static final int SUPP_MONTHS = 51;
    protected static final int SUPP_SOURCE = 41;
    protected static final int SUPP_TYPE = 40;
    protected static final int SALARY_MONTHS = 50;
    protected static final int ACAD_PERIOD = 48;
    protected static final int BASE_SALARY = 47;
    protected static final String SPECIAL_REVIEW_HUMAN_SUBJECTS_CODE = "1";
    protected static final String SPECIAL_REVIEW_VERTEBRATE_ANIMALS_CODE = "2";
    protected static final Comparator<KirschsteinBean> BY_QUESTION_NUMBER = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o2 != null) {
            return ObjectUtils.compare((Comparable)o1.questionNumber, (Comparable)o2.questionNumber);
        }
        return o1 != null ? -1 : 1;
    };

    protected List<String> getCostElementsByParam(String costElementParam) {
        String costElementsParamValue = this.s2SConfigurationService.getValueAsString(costElementParam);
        String[] costElements = costElementsParamValue.split(",");
        ArrayList<String> costElementList = new ArrayList<String>();
        Collections.addAll(costElementList, costElements);
        return costElementList;
    }

    protected ScaleTwoDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        BigDecimal monthCount = ScaleTwoDecimal.ZERO.bigDecimalValue();
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return ScaleTwoDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BigDecimal startMonthFraction = new ScaleTwoDecimal(++startMonthDays).bigDecimalValue().divide(new ScaleTwoDecimal(startMonthMaxDays).bigDecimalValue(), RoundingMode.HALF_UP);
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BigDecimal endMonthFraction = new ScaleTwoDecimal(endMonthDays).bigDecimalValue().divide(new ScaleTwoDecimal(endMonthMaxDays).bigDecimalValue(), RoundingMode.HALF_UP);
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = monthCount.add(new ScaleTwoDecimal(--fullMonthCount).bigDecimalValue()).add(startMonthFraction).add(endMonthFraction);
        return new ScaleTwoDecimal(monthCount);
    }

    protected AttachmentGroupMin0Max100DataType getAppendix() {
        AttachmentGroupMin0Max100DataType attachmentGroupType = null;
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null || !code.equalsIgnoreCase(APPENDIX) || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        if (attachedFileDataTypeList.size() != 0) {
            attachmentGroupType = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
            attachmentGroupType.setAttachedFileArray(attachedFileDataTypeList.toArray(new AttachedFileDataType[0]));
        }
        return attachmentGroupType;
    }

    protected List<? extends AnswerHeaderContract> findQuestionnaireWithAnswers(DevelopmentProposalContract developmentProposal) {
        return this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(developmentProposal.getProposalNumber(), this.getNamespace(), this.getFormName());
    }

    protected List<AnswerContract> getAnswers(Long questonnaireQuestionId, AnswerHeaderContract answerHeader) {
        ArrayList<AnswerContract> returnAnswers = new ArrayList<AnswerContract>();
        if (answerHeader != null) {
            List answers = answerHeader.getAnswers();
            for (AnswerContract answer : answers) {
                if (!answer.getQuestionnaireQuestionsId().equals(questonnaireQuestionId)) continue;
                returnAnswers.add(answer);
            }
        }
        return returnAnswers;
    }

    protected List<AnswerContract> getAnswers(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        return this.getAnswers(questionnaireQuestion.getId(), answerHeader);
    }

    protected AnswerContract getAnswer(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        List<AnswerContract> returnAnswers = this.getAnswers(questionnaireQuestion, answerHeader);
        return !returnAnswers.isEmpty() ? returnAnswers.get(0) : null;
    }

    protected YesNoDataType.Enum getYesNoEnum(String answer) {
        return answer.equals(QUESTION_ANSWER_YES) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public QuestionAnswerService getQuestionAnswerService() {
        return this.questionAnswerService;
    }

    @Override
    public void setQuestionAnswerService(QuestionAnswerService questionAnswerService) {
        this.questionAnswerService = questionAnswerService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    public static class KirschsteinBean {
        String answer;
        Integer questionId;
        Integer questionNumber;
        Integer parentQuestionNumber;

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public Integer getQuestionId() {
            return this.questionId;
        }

        public void setQuestionId(Integer questionId) {
            this.questionId = questionId;
        }

        public Integer getQuestionNumber() {
            return this.questionNumber;
        }

        public void setQuestionNumber(Integer questionNumber) {
            this.questionNumber = questionNumber;
        }

        public Integer getParentQuestionNumber() {
            return this.parentQuestionNumber;
        }

        public void setParentQuestionNumber(Integer parentQuestionNumber) {
            this.parentQuestionNumber = parentQuestionNumber;
        }
    }
}

