/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudgetV11.BudgetTypeDataType;
import gov.grants.apply.forms.rrBudgetV11.BudgetYear1DataType;
import gov.grants.apply.forms.rrBudgetV11.BudgetYearDataType;
import gov.grants.apply.forms.rrBudgetV11.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrBudgetV11.KeyPersonDataType;
import gov.grants.apply.forms.rrBudgetV11.OtherPersonnelDataType;
import gov.grants.apply.forms.rrBudgetV11.RRBudgetDocument;
import gov.grants.apply.forms.rrBudgetV11.SectBCompensationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetPeriodDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCompensationDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SEquipmentDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDetailsDto;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherDirectCostInfoDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherPersonnelDto;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.RRBudgetBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.UnsupportedOtherCostsErrorBuilder;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRBudgetV1_1Generator")
public class RRBudgetV1_1Generator
extends RRBudgetBaseGenerator<RRBudgetDocument> {
    private static final Logger LOG = LogManager.getLogger(RRBudgetV1_1Generator.class);
    private static final int SUPPORTED_OTHER_COSTS = 3;
    @Value(value="http://apply.grants.gov/forms/RR_Budget-V1.1")
    private String namespace;
    @Value(value="RR_Budget-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_Budget-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="165")
    private int sortIndex;

    private RRBudgetDocument getRRBudget() {
        this.deleteAutoGenNarratives();
        RRBudgetDocument rrBudgetDocument = (RRBudgetDocument)RRBudgetDocument.Factory.newInstance();
        RRBudgetDocument.RRBudget rrBudget = (RRBudgetDocument.RRBudget)RRBudgetDocument.RRBudget.Factory.newInstance();
        rrBudget.setFormVersion(FormVersion.v1_1.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
            rrBudget.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
        rrBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        rrBudget.setBudgetYear1((BudgetYear1DataType)BudgetYear1DataType.Factory.newInstance());
        this.validateBudgetForForm(this.pdDoc);
        S2SBudgetDto budgetSummary = this.s2sBudgetInfoService.getBudgetInfo(this.pdDoc);
        List budgetPeriodList = budgetSummary.getBudgetPeriods();
        for (S2SBudgetPeriodDto budgetPeriodData : budgetPeriodList) {
            if (budgetPeriodData.getBudgetPeriod() == BudgetPeriodNum.P1.getNum()) {
                rrBudget.setBudgetYear1(this.getBudgetYear1DataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == BudgetPeriodNum.P2.getNum()) {
                rrBudget.setBudgetYear2(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == BudgetPeriodNum.P3.getNum()) {
                rrBudget.setBudgetYear3(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == BudgetPeriodNum.P4.getNum()) {
                rrBudget.setBudgetYear4(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() != BudgetPeriodNum.P5.getNum()) continue;
            rrBudget.setBudgetYear5(this.getBudgetYearDataType(budgetPeriodData));
        }
        for (S2SBudgetPeriodDto budgetPeriodData : budgetPeriodList) {
            if (budgetPeriodData.getBudgetPeriod() != BudgetPeriodNum.P1.getNum()) continue;
            rrBudget.setBudgetYear1(this.getBudgetJustificationAttachment(rrBudget.getBudgetYear1()));
        }
        rrBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrBudgetDocument.setRRBudget(rrBudget);
        return rrBudgetDocument;
    }

    private BudgetYear1DataType getBudgetYear1DataType(S2SBudgetPeriodDto periodInfo) {
        BudgetYear1DataType budgetYear = (BudgetYear1DataType)BudgetYear1DataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt(periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            budgetYear.setDirectCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue().add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
        }
        return budgetYear;
    }

    private BudgetYear1DataType getBudgetJustificationAttachment(BudgetYear1DataType budgetYear) {
        NarrativeContract narrative;
        AttachedFileDataType attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        Iterator iterator = this.pdDoc.getDevelopmentProposal().getNarratives().iterator();
        while (iterator.hasNext() && ((narrative = (NarrativeContract)iterator.next()).getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 7 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null)) {
        }
        budgetYear.setBudgetJustificationAttachment(attachedFileDataType);
        return budgetYear;
    }

    private BudgetYearDataType getBudgetYearDataType(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType budgetYear = (BudgetYearDataType)BudgetYearDataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt(periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            BigDecimal directCosts = periodInfo.getDirectCostsTotal().bigDecimalValue();
            budgetYear.setDirectCosts(directCosts);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            budgetYear.setIndirectCosts(indirectCosts);
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            if (indirectCosts != null) {
                budgetYear.setTotalCosts(directCosts.add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getTotalCosts().bigDecimalValue());
            }
        }
        return budgetYear;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary getBudgetSummary(S2SBudgetDto budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary budgetSummary = (RRBudgetDocument.RRBudget.BudgetSummary)RRBudgetDocument.RRBudget.BudgetSummary.Factory.newInstance();
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
            budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
        }
        if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
            budgetSummary.setCumulativeTotalFundsRequestedPersonnel(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
        }
        budgetSummary.setCumulativeEquipments(this.getCumulativeEquipments(budgetSummaryData));
        budgetSummary.setCumulativeTravels(this.getCumulativeTravels(budgetSummaryData));
        budgetSummary.setCumulativeTrainee(this.getCumulativeTrainee(budgetSummaryData));
        budgetSummary.setCumulativeOtherDirect(this.getCumulativeOtherDirect(budgetSummaryData));
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
        budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
        budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
        if (budgetSummaryData.getCumFee() != null) {
            budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
        }
        return budgetSummary;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments getCumulativeEquipments(S2SBudgetDto budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments cumulativeEquipments = (RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments)RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments.Factory.newInstance();
        if (budgetSummaryData != null && budgetSummaryData.getCumEquipmentFunds() != null) {
            cumulativeEquipments.setCumulativeTotalFundsRequestedEquipment(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
        }
        return cumulativeEquipments;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels getCumulativeTravels(S2SBudgetDto budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels cumulativeTravels = (RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels)RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels.Factory.newInstance();
        if (budgetSummaryData.getCumDomesticTravel() != null) {
            cumulativeTravels.setCumulativeDomesticTravelCosts(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumForeignTravel() != null) {
            cumulativeTravels.setCumulativeForeignTravelCosts(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumTravel() != null) {
            cumulativeTravels.setCumulativeTotalFundsRequestedTravel(budgetSummaryData.getCumTravel().bigDecimalValue());
        }
        return cumulativeTravels;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee getCumulativeTrainee(S2SBudgetDto budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee cumulativeTrainee = (RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee)RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee.Factory.newInstance();
        cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null) {
            cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(((ScaleTwoDecimal)budgetSummaryData.getPartOtherCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartStipendCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTravelCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTuition().add((AbstractDecimal)budgetSummaryData.getPartSubsistence())))))))).bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeTuitionFeesHealthInsurance(budgetSummaryData.getPartTuition().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeStipends(budgetSummaryData.getPartStipendCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeTravel(budgetSummaryData.getPartTravelCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeTraineeSubsistence(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            cumulativeTrainee.setCumulativeOtherTraineeCost(budgetSummaryData.getPartOtherCost().bigDecimalValue());
            cumulativeTrainee.setCumulativeNoofTrainees(budgetSummaryData.getParticipantCount());
        }
        return cumulativeTrainee;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect getCumulativeOtherDirect(S2SBudgetDto budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect cumulativeOtherDirect = (RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect)RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect.Factory.newInstance();
        cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null && budgetSummaryData.getOtherDirectCosts() != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                List cvOthers;
                cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(cumOtherDirect.getTotalOtherDirect().bigDecimalValue());
                if (cumOtherDirect.getMaterials() != null) {
                    cumulativeOtherDirect.setCumulativeMaterialAndSupplies(cumOtherDirect.getMaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getPublications() != null) {
                    cumulativeOtherDirect.setCumulativePublicationCosts(cumOtherDirect.getPublications().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultants() != null) {
                    cumulativeOtherDirect.setCumulativeConsultantServices(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getComputer() != null) {
                    cumulativeOtherDirect.setCumulativeADPComputerServices(cumOtherDirect.getComputer().bigDecimalValue());
                }
                if (cumOtherDirect.getSubAwards() != null) {
                    cumulativeOtherDirect.setCumulativeSubawardConsortiumContractualCosts(cumOtherDirect.getSubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRental() != null) {
                    cumulativeOtherDirect.setCumulativeEquipmentFacilityRentalFees(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterations() != null) {
                    cumulativeOtherDirect.setCumulativeAlterationsAndRenovations(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if ((cvOthers = cumOtherDirect.getOtherCosts()).size() > 3) {
                    this.getAuditErrors().add(UnsupportedOtherCostsErrorBuilder.build(3));
                    continue;
                }
                for (int j = 0; j < cvOthers.size(); ++j) {
                    S2SOtherCostDto hmCosts = (S2SOtherCostDto)cvOthers.get(j);
                    if (j == 0) {
                        cumulativeOtherDirect.setCumulativeOther1DirectCost(hmCosts.getCost().bigDecimalValue());
                        continue;
                    }
                    if (j == 1) {
                        cumulativeOtherDirect.setCumulativeOther2DirectCost(hmCosts.getCost().bigDecimalValue());
                        continue;
                    }
                    cumulativeOtherDirect.setCumulativeOther3DirectCost(hmCosts.getCost().bigDecimalValue());
                }
            }
        }
        return cumulativeOtherDirect;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = (BudgetYearDataType.ParticipantTraineeSupportCosts)BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            traineeSupportCosts.setTuitionFeeHealthInsurance(periodInfo.getPartTuition().bigDecimalValue());
            traineeSupportCosts.setStipends(periodInfo.getPartStipendCost().bigDecimalValue());
            traineeSupportCosts.setTravel(periodInfo.getPartTravelCost().bigDecimalValue());
            traineeSupportCosts.setSubsistence(periodInfo.getPartSubsistence().bigDecimalValue());
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getParticipantCount());
            traineeSupportCosts.setTotalCost(traineeSupportCosts.getTuitionFeeHealthInsurance().add(traineeSupportCosts.getStipends().add(traineeSupportCosts.getTravel().add(traineeSupportCosts.getSubsistence().add(traineeSupportCosts.getOther().getCost())))));
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = (BudgetYearDataType.ParticipantTraineeSupportCosts.Other)BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        ScaleTwoDecimal otherCost = ScaleTwoDecimal.ZERO;
        if (periodInfo != null && periodInfo.getPartOtherCost() != null) {
            otherCost = periodInfo.getPartOtherCost();
        }
        other.setCost(otherCost.bigDecimalValue());
        return other;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = (BudgetYearDataType.OtherDirectCosts)BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications() != null) {
                otherDirectCosts.setPublicationCosts(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials() != null) {
                otherDirectCosts.setMaterialsSupplies(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                otherDirectCosts.setConsultantServices(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer() != null) {
                otherDirectCosts.setADPComputerServices(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards() != null) {
                otherDirectCosts.setSubawardConsortiumContractualCosts(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                otherDirectCosts.setAlterationsRenovations(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                otherDirectCosts.setEquipmentRentalFee(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().bigDecimalValue());
            }
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect() != null) {
                otherDirectCosts.setTotalOtherDirectCost(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect().bigDecimalValue());
            }
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            int IndirectCostCount = 0;
            for (S2SIndirectCostDetailsDto indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = (BudgetYearDataType.IndirectCosts.IndirectCost)BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getFunds() != null) {
                    indirectCost.setFundRequested(indirectCostDetails.getFunds().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn("Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = (BudgetYearDataType.IndirectCosts)BudgetYearDataType.IndirectCosts.Factory.newInstance();
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(new BudgetYearDataType.IndirectCosts.IndirectCost[0]));
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    indirectCosts.setTotalIndirectCosts(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
            }
        }
        return indirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others others = (BudgetYearDataType.OtherDirectCosts.Others)BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            for (S2SOtherDirectCostInfoDto otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                if (!CollectionUtils.isNotEmpty((Collection)otherDirectCostInfo.getOtherCosts())) continue;
                for (S2SOtherCostDto oc : otherDirectCostInfo.getOtherCosts()) {
                    BudgetYearDataType.OtherDirectCosts.Others.Other other = others.addNewOther();
                    other.setCost(oc.getCost().bigDecimalValue());
                    other.setDescription(oc.getDescription());
                }
            }
        }
        return others;
    }

    private BudgetYearDataType.Travel getTravel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.Travel travel = (BudgetYearDataType.Travel)BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            travel.setDomesticTravelCost(periodInfo.getDomesticTravelCost().bigDecimalValue());
            travel.setForeignTravelCost(periodInfo.getForeignTravelCost().bigDecimalValue());
            travel.setTotalTravelCost(periodInfo.getTotalTravelCost().bigDecimalValue());
        }
        return travel;
    }

    private BudgetYearDataType.Equipment getEquipment(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.Equipment equipment = (BudgetYearDataType.Equipment)BudgetYearDataType.Equipment.Factory.newInstance();
        NarrativeContract extraEquipmentNarr = null;
        if (periodInfo != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            ArrayList<Object> equipmentArrayList = new ArrayList<Object>();
            ScaleTwoDecimal totalFund = ScaleTwoDecimal.ZERO;
            for (S2SCostDto costInfo : ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = (BudgetYearDataType.Equipment.EquipmentList)BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                if (costInfo.getCost() != null) {
                    equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
                }
                totalFund = (ScaleTwoDecimal)totalFund.add((AbstractDecimal)costInfo.getCost());
                equipmentArrayList.add(equipmentList);
            }
            ArrayList<S2SCostDto> extraEquipmentArrayList = new ArrayList<S2SCostDto>();
            ScaleTwoDecimal totalExtraEquipFund = ScaleTwoDecimal.ZERO;
            for (S2SCostDto costInfo : ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getExtraEquipmentList()) {
                extraEquipmentArrayList.add(costInfo);
                totalExtraEquipFund = (ScaleTwoDecimal)totalExtraEquipFund.add((AbstractDecimal)costInfo.getCost());
            }
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = equipmentArrayList.toArray(new BudgetYearDataType.Equipment.EquipmentList[0]);
            equipment.setEquipmentListArray(equipmentArray);
            BudgetYearDataType.Equipment.TotalFundForAttachedEquipment totalFundForAttachedEquipment = (BudgetYearDataType.Equipment.TotalFundForAttachedEquipment)BudgetYearDataType.Equipment.TotalFundForAttachedEquipment.Factory.newInstance();
            totalFundForAttachedEquipment.setTotalFundForAttachedEquipmentExist(YesNoDataType.Y_YES);
            totalFundForAttachedEquipment.setBigDecimalValue(totalExtraEquipFund.bigDecimalValue());
            equipment.setTotalFundForAttachedEquipment(totalFundForAttachedEquipment);
            totalFund = (ScaleTwoDecimal)totalFund.add((AbstractDecimal)totalExtraEquipFund);
            equipment.setTotalFund(totalFund.bigDecimalValue());
            extraEquipmentNarr = this.saveAdditionalEquipments(periodInfo, extraEquipmentArrayList);
        }
        if (extraEquipmentNarr != null) {
            BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment equipmentAttachment = (BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment)BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            equipmentAttachment.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraEquipmentNarr);
            fileLocation.setHref(contentId);
            equipmentAttachment.setFileLocation(fileLocation);
            equipmentAttachment.setFileName(extraEquipmentNarr.getNarrativeAttachment().getName());
            equipmentAttachment.setMimeType("application/octet-stream");
            if (extraEquipmentNarr.getNarrativeAttachment() != null) {
                HashValueDocument.HashValue hashValue = this.getHashValue(extraEquipmentNarr.getNarrativeAttachment().getData());
                equipmentAttachment.setHashValue(hashValue);
                this.addAttachment(new AttachmentData(extraEquipmentNarr.getNarrativeAttachment().getFileDataId(), extraEquipmentNarr.getNarrativeAttachment().getName(), contentId, extraEquipmentNarr.getNarrativeAttachment().getData(), "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), extraEquipmentNarr.getNarrativeAttachment().getUploadUser(), extraEquipmentNarr.getNarrativeAttachment().getUploadTimestamp()));
                equipmentAttachment.setTotalFundForAttachedEquipmentExist(YesNoDataType.Y_YES);
                equipment.setAdditionalEquipmentsAttachment(equipmentAttachment);
            }
        }
        return equipment;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = (BudgetYearDataType.OtherPersonnel)BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        if (periodInfo != null) {
            for (S2SOtherPersonnelDto otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (OtherpersonalCount >= 6) continue;
                OtherPersonnelDataType otherPersonnelDataType = (OtherPersonnelDataType)OtherPersonnelDataType.Factory.newInstance();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setCompensation(this.getSectBCompensationDataType(otherPersonnelInfo.getCompensation()));
                otherPersonnelList.add(otherPersonnelDataType);
                ++OtherpersonalCount;
            }
            otherPersonnel.setOtherArray(otherPersonnelList.toArray(new OtherPersonnelDataType[0]));
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                otherPersonnel.setTotalOtherPersonnelFund(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = (BudgetYearDataType.OtherPersonnel.PostDocAssociates)BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            postDocAssociates.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = (BudgetYearDataType.OtherPersonnel.GraduateStudents)BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = (BudgetYearDataType.OtherPersonnel.UndergraduateStudents)BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = (BudgetYearDataType.OtherPersonnel.SecretarialClerical)BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            secretarialClerical.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarialClerical;
    }

    private SectBCompensationDataType getSectBCompensationDataType(S2SCompensationDto compensation) {
        SectBCompensationDataType sectBCompensation = (SectBCompensationDataType)SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            sectBCompensation.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            sectBCompensation.setFundsRequested(compensation.getFundsRequested().bigDecimalValue());
            sectBCompensation.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
        }
        return sectBCompensation;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = (BudgetYearDataType.KeyPersons)BudgetYearDataType.KeyPersons.Factory.newInstance();
        ScaleTwoDecimal extraFunds = ScaleTwoDecimal.ZERO;
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList keyPersonList = new ArrayList();
                int keyPersonCount = 0;
                for (S2SKeyPersonDto keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    KeyPersonDataType keyPersonDataType = (KeyPersonDataType)KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (this.isSponsorNIH(this.pdDoc) && "CO-PD/PI".equals(keyPerson.getRole())) {
                        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
                        for (ProposalPersonContract proposalPerson : developmentProposal.getInvestigators()) {
                            if (!this.isProposalPersonEqualsKeyPerson(proposalPerson, keyPerson)) continue;
                            if (proposalPerson.isMultiplePi()) {
                                keyPersonDataType.setProjectRole("PD/PI");
                                continue;
                            }
                            keyPersonDataType.setProjectRole("CO-INVESTIGATOR");
                        }
                    } else if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson, periodInfo.getBudgetPeriod()));
                    keyPersonList.add(keyPersonDataType);
                    LOG.info("keyPersonCount:" + ++keyPersonCount);
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new KeyPersonDataType[0]));
            }
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                keyPersons.setTotalFundForKeyPersons(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            for (S2SKeyPersonDto keyPerson : periodInfo.getExtraKeyPersons()) {
                extraFunds = (ScaleTwoDecimal)extraFunds.add((AbstractDecimal)keyPerson.getCompensation().getFundsRequested());
            }
        }
        BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons totalFundForAttachedKeyPersons = (BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons)BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons.Factory.newInstance();
        totalFundForAttachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.Y_YES);
        totalFundForAttachedKeyPersons.setBigDecimalValue(extraFunds.bigDecimalValue());
        keyPersons.setTotalFundForAttachedKeyPersons(totalFundForAttachedKeyPersons);
        NarrativeContract extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo);
        if (extraKeyPersonNarr != null) {
            BudgetYearDataType.KeyPersons.AttachedKeyPersons attachedKeyPersons = (BudgetYearDataType.KeyPersons.AttachedKeyPersons)BudgetYearDataType.KeyPersons.AttachedKeyPersons.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            attachedKeyPersons.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraKeyPersonNarr);
            fileLocation.setHref(contentId);
            attachedKeyPersons.setFileLocation(fileLocation);
            attachedKeyPersons.setFileName(extraKeyPersonNarr.getNarrativeAttachment().getName());
            attachedKeyPersons.setMimeType("application/octet-stream");
            byte[] narrativeContent = null;
            if (extraKeyPersonNarr.getNarrativeAttachment() != null) {
                narrativeContent = extraKeyPersonNarr.getNarrativeAttachment().getData();
            }
            if (narrativeContent != null && narrativeContent.length > 0) {
                HashValueDocument.HashValue hashValue = this.getHashValue(narrativeContent);
                attachedKeyPersons.setHashValue(hashValue);
                this.addAttachment(new AttachmentData(extraKeyPersonNarr.getNarrativeAttachment().getFileDataId(), extraKeyPersonNarr.getNarrativeAttachment().getName(), contentId, narrativeContent, "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), extraKeyPersonNarr.getNarrativeAttachment().getUploadUser(), extraKeyPersonNarr.getNarrativeAttachment().getUploadTimestamp()));
                attachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.Y_YES);
                keyPersons.setAttachedKeyPersons(attachedKeyPersons);
            }
        }
        return keyPersons;
    }

    private KeyPersonCompensationDataType getCompensation(S2SKeyPersonDto keyPerson, int budgetPeriod) {
        KeyPersonCompensationDataType compensation = (KeyPersonCompensationDataType)KeyPersonCompensationDataType.Factory.newInstance();
        if (keyPerson != null) {
            compensation.setAcademicMonths(keyPerson.getCompensation().getAcademicMonths().bigDecimalValue());
            compensation.setCalendarMonths(keyPerson.getCompensation().getCalendarMonths().bigDecimalValue());
            compensation.setSummerMonths(keyPerson.getCompensation().getSummerMonths().bigDecimalValue());
            compensation.setFringeBenefits(keyPerson.getCompensation().getFringe().bigDecimalValue());
            compensation.setRequestedSalary(keyPerson.getCompensation().getRequestedSalary().bigDecimalValue());
            compensation.setFundsRequested(keyPerson.getCompensation().getFundsRequested().bigDecimalValue());
            if (this.pdDoc.getDevelopmentProposal().getBudgets() != null) {
                ScaleTwoDecimal baseSalaryByPeriod = keyPerson.getCompensation().getBaseSalary();
                if (baseSalaryByPeriod != null && baseSalaryByPeriod.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    compensation.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                } else if (keyPerson.getCompensation().getBaseSalary() != null) {
                    compensation.setBaseSalary(keyPerson.getCompensation().getBaseSalary().bigDecimalValue());
                }
            } else {
                compensation.setBaseSalary(keyPerson.getCompensation().getBaseSalary().bigDecimalValue());
            }
        }
        return compensation;
    }

    @Override
    public RRBudgetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRBudget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRBudgetDocument> factory() {
        return RRBudgetDocument.Factory;
    }
}

