/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrKeyPersonExpanded30V30.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded30V30.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded30V30.RRKeyPersonExpanded30Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.ProposalPersonComparator;
import org.kuali.coeus.s2sgen.impl.generate.support.RRKeyPersonExpandedBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRKeyPersonExpandedV3_0Generator")
public class RRKeyPersonExpandedV3_0Generator
extends RRKeyPersonExpandedBaseGenerator<RRKeyPersonExpanded30Document>
implements S2SFormGeneratorPdfFillable<RRKeyPersonExpanded30Document> {
    private static final int MAX_KEY_PERSON_COUNT = 100;
    private static final String CHILD = "C";
    RolodexContract rolodex;
    @Value(value="http://apply.grants.gov/forms/RR_KeyPersonExpanded_3_0-V3.0")
    private String namespace;
    @Value(value="RR_KeyPersonExpanded_3_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_KeyPersonExpanded-V3.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_KeyPersonExpanded_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="155")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private RRKeyPersonExpanded30Document getRRKeyPersonExpanded() {
        RRKeyPersonExpanded30Document rrKeyPersonExpandedDocument = (RRKeyPersonExpanded30Document)RRKeyPersonExpanded30Document.Factory.newInstance();
        RRKeyPersonExpanded30Document.RRKeyPersonExpanded30 rrKeyPersonExpanded = (RRKeyPersonExpanded30Document.RRKeyPersonExpanded30)RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.Factory.newInstance();
        this.setRRKeyPersonExpandedAttributes(rrKeyPersonExpanded);
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded30(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }

    private void setRRKeyPersonExpandedAttributes(RRKeyPersonExpanded30Document.RRKeyPersonExpanded30 rrKeyPersonExpanded) {
        rrKeyPersonExpanded.setFormVersion(FormVersion.v3_0.getVersion());
        rrKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        PersonProfileDataType[] keyPersonArray = this.getPersonProfileKeyPerson();
        if (keyPersonArray.length > 0) {
            rrKeyPersonExpanded.setKeyPersonArray(keyPersonArray);
        }
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            for (ProposalPersonContract extraPerson : this.extraPersons) {
                this.setBioSketchAttchment(rrKeyPersonExpanded, extraPerson);
                this.setCurrentPendingTypeAttachment(rrKeyPersonExpanded, extraPerson);
            }
            for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
                if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 18) continue;
                this.setProfileTypeAttachment(rrKeyPersonExpanded, narrative);
            }
        }
    }

    private void setProfileTypeAttachment(RRKeyPersonExpanded30Document.RRKeyPersonExpanded30 rrKeyPersonExpanded, NarrativeContract narrative) {
        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
        if (attachedFileDataType != null) {
            RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.AdditionalProfilesAttached additionalProfilesAttached = (RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.AdditionalProfilesAttached)RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            rrKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
        }
    }

    private void setCurrentPendingTypeAttachment(RRKeyPersonExpanded30Document.RRKeyPersonExpanded30 rrKeyPersonExpanded, ProposalPersonContract extraPerson) {
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "2");
        if (supportAttachment != null) {
            RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.SupportsAttached supportsAttached = (RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.SupportsAttached)RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            rrKeyPersonExpanded.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttchment(RRKeyPersonExpanded30Document.RRKeyPersonExpanded30 rrKeyPersonExpanded, ProposalPersonContract extraPerson) {
        RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.BioSketchsAttached personBioSketch = (RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.BioSketchsAttached)RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "1");
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        rrKeyPersonExpanded.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            this.setPersonalProfileDetailsToProfile(profileDataType, profile, PI);
        }
        return profileDataType;
    }

    private void setPersonalProfileDetailsToProfile(PersonProfileDataType profileDataType, PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        ProposalPersonDegreeContract proposalPersonDegree;
        this.assignRolodexId(PI);
        profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
        this.setDirectoryTitleToProfile(profile, PI);
        profile.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)PI));
        profile.setPhone(PI.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
            profile.setFax(PI.getFaxNumber());
        }
        if (PI.getDegree() != null) {
            profile.setDegreeType(PI.getDegree());
        }
        if (PI.getYearGraduated() != null) {
            profile.setDegreeYear(PI.getYearGraduated());
        }
        if (PI.getDegree() == null && PI.getYearGraduated() == null && PI.getProposalPersonDegrees() != null && PI.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegreeContract)PI.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profile.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profile.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profile.setEmail(PI.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profile, developmentProposal);
        this.setDepartmentNameToProfile(profile, PI);
        String divisionName = this.getS2sDivisionService().getDivision(PI);
        if (divisionName != null) {
            profile.setDivisionName(divisionName);
        }
        if (PI.getEraCommonsUserName() != null) {
            profile.setCredential(PI.getEraCommonsUserName());
        } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity", new String[0]));
        }
        if (CHILD.equalsIgnoreCase(developmentProposal.getHierarchyStatus())) {
            profile.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
            PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRoleCategory = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
            otherProjectRoleCategory.setStringValue("Project Lead");
            profile.setOtherProjectRoleCategory(otherProjectRoleCategory);
        } else {
            profile.setProjectRole(ProjectRoleDataType.PD_PI);
        }
        this.setAttachments(profile, PI);
        profileDataType.setProfile(profile);
    }

    private void setDepartmentNameToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract keyPerson) {
        if (keyPerson.getHomeUnit() != null && keyPerson.getPerson() != null && keyPerson.getPerson().getUnit() != null) {
            String departmentName = keyPerson.getPerson().getUnit().getUnitName();
            profile.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
        } else if (keyPerson.getRolodexId() != null && keyPerson.getDirectoryDepartment() != null) {
            profile.setDepartmentName(StringUtils.substring((String)keyPerson.getDirectoryDepartment(), (int)0, (int)30));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            profile.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
        }
    }

    private void setDirectoryTitleToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                profile.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private void assignRolodexId(ProposalPersonContract PI) {
        if (PI.getPersonId() != null) {
            this.pIPersonOrRolodexId = PI.getPersonId();
            this.rolodex = null;
        } else if (PI.getRolodexId() != null) {
            this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            this.rolodex = this.rolodexService.getRolodex(Integer.valueOf(this.pIPersonOrRolodexId));
        }
    }

    private void setAttachments(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        this.setBioSketchAttachment(profile, PI);
        this.setCurrentPendingAttachment(profile, PI);
    }

    private void setCurrentPendingAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
        if (supportAttachment != null) {
            PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            profile.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
        if (bioSketchAttachment != null) {
            personBioSketch.setBioSketchAttached(bioSketchAttachment);
            profile.setBioSketchsAttached(personBioSketch);
        }
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        List keyPersons = developmentProposal.getProposalPersons();
        if (keyPersons != null) {
            keyPersons.sort(new ProposalPersonComparator());
        }
        List<ProposalPersonContract> nKeyPersons = this.s2SProposalPersonService.getNKeyPersons(keyPersons, 100);
        List list = this.extraPersons = keyPersons != null ? keyPersons.stream().filter(kp -> !nKeyPersons.contains(kp)).collect(Collectors.toList()) : Collections.emptyList();
        if (nKeyPersons.size() > 0) {
            this.setKeyPersonToPersonProfileDataType(personProfileDataTypeList, nKeyPersons);
        }
        return personProfileDataTypeList.toArray(new PersonProfileDataType[0]);
    }

    private void setKeyPersonToPersonProfileDataType(List<PersonProfileDataType> personProfileDataTypeList, List<ProposalPersonContract> nKeyPersons) {
        for (ProposalPersonContract keyPerson : nKeyPersons) {
            if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
            PersonProfileDataType.Profile profileKeyPerson = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
            this.setAllkeyPersonDetailsToKeyPerson(keyPerson, profileKeyPerson);
            this.setAttachments(profileKeyPerson, keyPerson);
            PersonProfileDataType personProfileDataTypeKeyPerson = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
            personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
            personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
        }
    }

    private void setAllkeyPersonDetailsToKeyPerson(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        ProposalPersonDegreeContract proposalPersonDegree;
        this.assignRolodexId(keyPerson);
        profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
        this.setDirectoryTitleToProfile(profileKeyPerson, keyPerson);
        profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)keyPerson));
        profileKeyPerson.setPhone(keyPerson.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)keyPerson.getFaxNumber())) {
            profileKeyPerson.setFax(keyPerson.getFaxNumber());
        }
        if (keyPerson.getDegree() != null) {
            profileKeyPerson.setDegreeType(keyPerson.getDegree());
        }
        if (keyPerson.getYearGraduated() != null) {
            profileKeyPerson.setDegreeYear(keyPerson.getYearGraduated());
        }
        if (keyPerson.getDegree() == null && keyPerson.getYearGraduated() == null && keyPerson.getProposalPersonDegrees() != null && keyPerson.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegreeContract)keyPerson.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profileKeyPerson.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profileKeyPerson.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profileKeyPerson.setEmail(keyPerson.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profileKeyPerson, developmentProposal);
        this.setDepartmentNameToProfile(profileKeyPerson, keyPerson);
        String divisionName = this.getS2sDivisionService().getDivision(keyPerson);
        if (divisionName != null) {
            profileKeyPerson.setDivisionName(divisionName);
        }
        if (keyPerson.getEraCommonsUserName() != null) {
            profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
        } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode()) && keyPerson.isMultiplePi()) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity", new String[0]));
        }
        if (keyPerson.isMultiplePi() || keyPerson.isCoInvestigator()) {
            if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                if (keyPerson.isMultiplePi()) {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_INVESTIGATOR);
                }
            } else {
                profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
            }
        } else {
            this.setProjectRoleCategoryToProfile(keyPerson, profileKeyPerson);
        }
    }

    private void setOrganizationName(PersonProfileDataType.Profile profileKeyPerson, DevelopmentProposalContract developmentProposal) {
        if (developmentProposal.getApplicantOrganization() != null) {
            if (this.rolodex != null) {
                profileKeyPerson.setOrganizationName(StringUtils.substring((String)this.rolodex.getOrganization(), (int)0, (int)60));
            } else {
                profileKeyPerson.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
            }
        }
    }

    private void setProjectRoleCategoryToProfile(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        if (keyPerson.getRolodexId() != null && StringUtils.equalsIgnoreCase((CharSequence)keyPerson.getProjectRole(), (CharSequence)ProjectRoleDataType.PD_PI.toString())) {
            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
        } else {
            profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
            PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
            String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
            otherProjectRole.setStringValue(otherRole);
            profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
        }
    }

    @Override
    public RRKeyPersonExpanded30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPersonExpanded();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRKeyPersonExpanded30Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            List<PersonProfileDataType> keyPersons;
            RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.AdditionalProfilesAttached additionalProfilesAttached = form.getRRKeyPersonExpanded30().getAdditionalProfilesAttached();
            if (additionalProfilesAttached != null && additionalProfilesAttached.getAdditionalProfileAttached() != null && a.getContentId().equals(additionalProfilesAttached.getAdditionalProfileAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.optionalFile1", a);
            }
            RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.BioSketchsAttached bioSketchsAttached = form.getRRKeyPersonExpanded30().getBioSketchsAttached();
            if (bioSketchsAttached != null && bioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(bioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.optionalFile2", a);
            }
            RRKeyPersonExpanded30Document.RRKeyPersonExpanded30.SupportsAttached supportsAttached = form.getRRKeyPersonExpanded30().getSupportsAttached();
            if (supportsAttached != null && supportsAttached.getSupportAttached() != null && a.getContentId().equals(supportsAttached.getSupportAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.optionalFile3", a);
            }
            PersonProfileDataType pdpi = form.getRRKeyPersonExpanded30().getPDPI();
            if (pdpi != null && pdpi.getProfile() != null) {
                PersonProfileDataType.Profile.BioSketchsAttached pdpiBioSketchsAttached = pdpi.getProfile().getBioSketchsAttached();
                if (pdpiBioSketchsAttached != null && pdpiBioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(pdpiBioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                    return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.PDPI.mandatoryFile0", a);
                }
                PersonProfileDataType.Profile.SupportsAttached pdpiSupportsAttached = pdpi.getProfile().getSupportsAttached();
                if (pdpiSupportsAttached != null && pdpiSupportsAttached.getSupportAttached() != null && a.getContentId().equals(pdpiSupportsAttached.getSupportAttached().getFileLocation().getHref())) {
                    return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.PDPI.optionalFile0", a);
                }
            }
            if ((keyPersons = form.getRRKeyPersonExpanded30().getKeyPersonList()) != null) {
                for (int i = 0; i < keyPersons.size(); ++i) {
                    PersonProfileDataType keyPerson = keyPersons.get(i);
                    if (keyPerson == null || keyPerson.getProfile() == null) continue;
                    PersonProfileDataType.Profile.BioSketchsAttached keyPersonBioSketchsAttached = keyPerson.getProfile().getBioSketchsAttached();
                    if (keyPersonBioSketchsAttached != null && keyPersonBioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(keyPersonBioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                        return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.KeyPerson.optionalFile0_" + i, a);
                    }
                    PersonProfileDataType.Profile.SupportsAttached keyPersonSupportsAttached = keyPerson.getProfile().getSupportsAttached();
                    if (keyPersonSupportsAttached == null || keyPersonSupportsAttached.getSupportAttached() == null || !a.getContentId().equals(keyPersonSupportsAttached.getSupportAttached().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_KeyPersonExpanded_3_0_P1.KeyPerson.optionalFile1_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRKeyPersonExpanded30Document> factory() {
        return RRKeyPersonExpanded30Document.Factory;
    }
}

