/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrPerformanceSiteV11.RRPerformanceSiteDocument;
import gov.grants.apply.forms.rrPerformanceSiteV11.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRPerformanceSiteBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRPerformanceSiteV1_1Generator")
public class RRPerformanceSiteV1_1Generator
extends RRPerformanceSiteBaseGenerator<RRPerformanceSiteDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_PerformanceSite-V1.1")
    private String namespace;
    @Value(value="RR_PerformanceSite-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_PerformanceSite-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_PerformanceSite-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="130")
    private int sortIndex;

    private RRPerformanceSiteDocument getRRPerformanceSite() {
        RRPerformanceSiteDocument rrPerformanceSiteDocument = (RRPerformanceSiteDocument)RRPerformanceSiteDocument.Factory.newInstance();
        RRPerformanceSiteDocument.RRPerformanceSite rrPerformanceSite = (RRPerformanceSiteDocument.RRPerformanceSite)RRPerformanceSiteDocument.RRPerformanceSite.Factory.newInstance();
        rrPerformanceSite.setFormVersion(FormVersion.v1_1.getVersion());
        List propsoalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        SiteLocationDataType siteLocation = null;
        for (ProposalSiteContract proposalSite : propsoalSites) {
            switch (proposalSite.getLocationTypeCode()) {
                case 2: {
                    siteLocation = rrPerformanceSite.addNewPrimarySite();
                    break;
                }
                case 3: 
                case 4: {
                    siteLocation = rrPerformanceSite.addNewOtherSite();
                }
            }
            if (siteLocation == null) continue;
            siteLocation.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
            siteLocation.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 40 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            rrPerformanceSite.setAttachedFile(attachedFileDataType);
            break;
        }
        rrPerformanceSiteDocument.setRRPerformanceSite(rrPerformanceSite);
        return rrPerformanceSiteDocument;
    }

    @Override
    public RRPerformanceSiteDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRPerformanceSite();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRPerformanceSiteDocument form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType attachedFile = form.getRRPerformanceSite().getAttachedFile();
            if (attachedFile != null && a.getContentId().equals(attachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_PerformanceSite_P1.optionalFile0", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRPerformanceSiteDocument> factory() {
        return RRPerformanceSiteDocument.Factory;
    }
}

