/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrPersonalData12V12.DirectorType;
import gov.grants.apply.forms.rrPersonalData12V12.DisablilityStatusType;
import gov.grants.apply.forms.rrPersonalData12V12.EthnicityType;
import gov.grants.apply.forms.rrPersonalData12V12.GenderType;
import gov.grants.apply.forms.rrPersonalData12V12.RRPersonalData12Document;
import gov.grants.apply.forms.rrPersonalData12V12.RaceType;
import gov.grants.apply.forms.rrPersonalData12V12.impl.CitizenshipTypeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRPersonalDataBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRPersonalDataV1_2Generator")
public class RRPersonalDataV1_2Generator
extends RRPersonalDataBaseGenerator<RRPersonalData12Document> {
    @Value(value="http://apply.grants.gov/forms/RR_PersonalData_1_2-V1.2")
    private String namespace;
    @Value(value="RR_PersonalData_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_PersonalData-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_PersonalData_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="157")
    private int sortIndex;

    private RRPersonalData12Document getRRPersonalData() {
        RRPersonalData12Document rrPersonalDataDocument = (RRPersonalData12Document)RRPersonalData12Document.Factory.newInstance();
        RRPersonalData12Document.RRPersonalData12 rrPersonalData = (RRPersonalData12Document.RRPersonalData12)RRPersonalData12Document.RRPersonalData12.Factory.newInstance();
        rrPersonalData.setFormVersion(FormVersion.v1_2.getVersion());
        rrPersonalData.setProjectDirector(this.getProjectDirectorType());
        rrPersonalData.setCoProjectDirectorArray(this.getCoProjectDirectoryType());
        rrPersonalDataDocument.setRRPersonalData12(rrPersonalData);
        return rrPersonalDataDocument;
    }

    private DirectorType getProjectDirectorType() {
        DirectorType directorType = (DirectorType)DirectorType.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            directorType.setName(this.globLibV20Generator.getHumanNameDataType(PI));
        }
        this.setDirectorOptionals(directorType);
        return directorType;
    }

    private void setDirectorOptionals(DirectorType directorType) {
        directorType.setCitizenship(CitizenshipTypeImpl.DO_NOT_WISH_TO_PROVIDE);
        directorType.setGender(GenderType.DO_NOT_WISH_TO_PROVIDE);
        directorType.setRaceArray(new RaceType.Enum[]{RaceType.DO_NOT_WISH_TO_PROVIDE});
        directorType.setEthnicity(EthnicityType.DO_NOT_WISH_TO_PROVIDE);
        directorType.setDisabilityStatusArray(new DisablilityStatusType.Enum[]{DisablilityStatusType.DO_NOT_WISH_TO_PROVIDE});
    }

    private DirectorType[] getCoProjectDirectoryType() {
        ArrayList<DirectorType> directorTypeList = new ArrayList<DirectorType>();
        if (this.pdDoc.getDevelopmentProposal().getProposalPersons() != null) {
            ProposalPersonContract CoPI2 = null;
            for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
                DirectorType coDirectorType = (DirectorType)DirectorType.Factory.newInstance();
                if (proposalPerson.getProposalPersonRoleId() == null || !"COI".equals(proposalPerson.getProposalPersonRoleId())) continue;
                CoPI2 = proposalPerson;
                coDirectorType.setName(this.globLibV20Generator.getHumanNameDataType(CoPI2));
                this.setDirectorOptionals(coDirectorType);
                directorTypeList.add(coDirectorType);
            }
        }
        return directorTypeList.toArray(new DirectorType[0]);
    }

    @Override
    public RRPersonalData12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRPersonalData();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRPersonalData12Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRPersonalData12Document> factory() {
        return RRPersonalData12Document.Factory;
    }
}

