/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.location;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.country.CountryContract;
import org.kuali.coeus.common.api.country.KcCountryService;
import org.kuali.coeus.common.api.state.KcStateService;
import org.kuali.coeus.common.api.state.StateContract;
import org.kuali.coeus.s2sgen.impl.location.S2SLocationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SLocationService")
public class S2SLocationServiceImpl
implements S2SLocationService {
    @Autowired
    @Qualifier(value="kcCountryService")
    private KcCountryService kcCountryService;
    @Autowired
    @Qualifier(value="kcStateService")
    private KcStateService kcStateService;

    @Override
    public CountryContract getCountryFromCode(String countryCode) {
        if (StringUtils.isBlank((CharSequence)countryCode)) {
            return null;
        }
        CountryContract country = this.getKcCountryService().getCountryByAlternateCode(countryCode);
        if (country == null) {
            country = this.getKcCountryService().getCountry(countryCode);
        }
        return country;
    }

    @Override
    public StateContract getStateFromCode(String countryAlternateCode, String stateCode) {
        CountryContract country = this.getCountryFromCode(countryAlternateCode);
        return this.getKcStateService().getState(country.getCode(), stateCode);
    }

    public KcStateService getKcStateService() {
        return this.kcStateService;
    }

    public void setKcStateService(KcStateService kcStateService) {
        this.kcStateService = kcStateService;
    }

    public KcCountryService getKcCountryService() {
        return this.kcCountryService;
    }

    public void setKcCountryService(KcCountryService kcCountryService) {
        this.kcCountryService = kcCountryService;
    }
}

