/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.person;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.UnitRepositoryService;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2sDivisionService")
public class S2sDivisionServiceImpl
implements S2sDivisionService {
    private static final int DIVISION_NAME_MAX_LENGTH = 30;
    @Autowired
    @Qualifier(value="unitRepositoryService")
    private UnitRepositoryService unitRepositoryService;

    @Override
    public String getDivision(ProposalPersonContract person) {
        if (person != null) {
            if (StringUtils.isNotBlank((CharSequence)person.getDivision())) {
                return StringUtils.substring((String)person.getDivision(), (int)0, (int)30);
            }
            return this.getDivisionFromUnit(person.getHomeUnit());
        }
        return null;
    }

    @Override
    public String getDivision(DepartmentalPersonDto person) {
        if (person != null) {
            return this.getDivisionFromUnit(person.getHomeUnit());
        }
        return null;
    }

    @Override
    public String getDivisionFromUnit(String unitNumber) {
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            UnitContract unit = this.getUnitRepositoryService().findUnitByUnitNumber(unitNumber);
            return StringUtils.substring((String)(unit != null && unit.getParentUnit() != null ? unit.getParentUnit().getUnitName() : (unit != null && unit.getParentUnit() == null ? unit.getUnitName() : null)), (int)0, (int)30);
        }
        return null;
    }

    public UnitRepositoryService getUnitRepositoryService() {
        return this.unitRepositoryService;
    }

    public void setUnitRepositoryService(UnitRepositoryService unitRepositoryService) {
        this.unitRepositoryService = unitRepositoryService;
    }
}

