/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.group.GroupAttributeBo;
import org.kuali.rice.kim.impl.group.GroupBase;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Cacheable(value=false)
@Entity
@Table(name="KRIM_GRP_T")
public class GroupBo
extends GroupBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_GRP_ID_S")
    @GeneratedValue(generator="KRIM_GRP_ID_S")
    @Id
    @Column(name="GRP_ID")
    private String id;
    @OneToMany(targetEntity=GroupMemberBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="GRP_ID", referencedColumnName="GRP_ID", insertable=false, updatable=false)
    private List<GroupMemberBo> members;
    @OneToMany(targetEntity=GroupAttributeBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="GRP_ID", referencedColumnName="GRP_ID")
    private List<GroupAttributeBo> attributeDetails;
    @Transient
    private List<Person> memberPersons;
    @Transient
    private List<Group> memberGroups;

    @Override
    public Map<String, String> getAttributes() {
        return this._persistence_get_attributeDetails() != null ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public List<GroupMemberBo> getMembers() {
        return this._persistence_get_members();
    }

    public void setMembers(List<GroupMemberBo> members) {
        this._persistence_set_members(members);
    }

    public List<GroupAttributeBo> getAttributeDetails() {
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<GroupAttributeBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public static Group to(GroupBo bo) {
        if (bo == null) {
            return null;
        }
        return Group.Builder.create((GroupContract)bo).build();
    }

    public static GroupBo from(Group im) {
        if (im == null) {
            return null;
        }
        GroupBo bo = new GroupBo();
        bo.setId(im.getId());
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setActive(im.isActive());
        bo.setKimTypeId(im.getKimTypeId());
        bo.setAttributes(im.getAttributes());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public String getGroupAttributeValueById(String attributeId) {
        for (GroupAttributeBo gad : this.getAttributeDetails()) {
            if (!gad.getKimAttributeId().equals(attributeId.trim())) continue;
            return gad.getAttributeValue();
        }
        return null;
    }

    private void splitMembersToTypes() {
        this.memberPersons = new ArrayList<Person>();
        this.memberGroups = new ArrayList<Group>();
        if (this.getMembers() != null) {
            for (GroupMemberBo groupMember : this.getMembers()) {
                Group tempGroup;
                if (!groupMember.isActive(new DateTime())) continue;
                if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)groupMember.getType())) {
                    Person tempPerson = KimApiServiceLocator.getPersonService().getPerson(groupMember.getMemberId());
                    if (tempPerson == null || !tempPerson.isActive()) continue;
                    this.memberPersons.add(tempPerson);
                    continue;
                }
                if (!KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.equals((Object)groupMember.getType()) || (tempGroup = KimApiServiceLocator.getGroupService().getGroup(groupMember.getMemberId())) == null || !tempGroup.isActive()) continue;
                this.memberGroups.add(tempGroup);
            }
        }
    }

    public List<Person> getMemberPersons() {
        if (this.memberPersons == null) {
            this.splitMembersToTypes();
        }
        return this.memberPersons;
    }

    public void setMemberPersons(List<Person> memberPersons) {
        this.memberPersons = memberPersons;
    }

    public List<String> getMemberPrincipalIds() {
        ArrayList<String> principalIds = new ArrayList<String>();
        if (this.getMembers() != null) {
            for (GroupMemberBo groupMember : this.getMembers()) {
                if (!groupMember.isActive(new DateTime()) || !KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)groupMember.getType())) continue;
                principalIds.add(groupMember.getMemberId());
            }
        }
        return principalIds;
    }

    public List<String> getMemberGroupIds() {
        ArrayList<String> principalIds = new ArrayList<String>();
        if (this.getMembers() != null) {
            for (GroupMemberBo groupMember : this.getMembers()) {
                if (!groupMember.isActive(new DateTime()) || !KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.equals((Object)groupMember.getType())) continue;
                principalIds.add(groupMember.getMemberId());
            }
        }
        return principalIds;
    }

    public List<Group> getMemberGroups() {
        if (this.memberGroups == null) {
            this.splitMembersToTypes();
        }
        return this.memberGroups;
    }

    public void setMemberGroups(List<Group> memberGroups) {
        this.memberGroups = memberGroups;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new GroupBo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "members") {
            return this.members;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "members") {
            this.members = (List)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_members() {
        this._persistence_checkFetched("members");
        return this.members;
    }

    public void _persistence_set_members(List list) {
        this._persistence_checkFetchedForSet("members");
        this._persistence_propertyChange("members", this.members, list);
        this.members = list;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }
}

