/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class Image {
    static Logger log = LoggerFactory.getLogger(Image.class);
    private long timestamp = System.currentTimeMillis();

    private Image() {
    }

    boolean illegalImageComparison(Image image) {
        return this.timestamp < image.timestamp;
    }

    public abstract void cleanup(boolean var1);

    public abstract boolean modified(Image var1);

    abstract void referenceProcessing(Image var1);

    public void performReferenceDetection(Image image) {
        if (this.illegalImageComparison(image)) {
            throw new ImageException("The specified Image object is newer than current one, wrong Image order!");
        }
        this.referenceProcessing(image);
    }

    public static class ImageException
    extends OJBRuntimeException {
        public ImageException() {
        }

        public ImageException(String string) {
            super(string);
        }

        public ImageException(Throwable throwable) {
            super(throwable);
        }

        public ImageException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static interface ImageListener {
        public void addedOneToOne(ObjectReferenceDescriptor var1, Object var2, Identity var3);

        public void deletedOneToOne(ObjectReferenceDescriptor var1, Object var2, Identity var3, boolean var4);

        public void addedXToN(CollectionDescriptor var1, Object var2, Identity var3);

        public void deletedXToN(CollectionDescriptor var1, Object var2, Identity var3);

        public PersistenceBrokerInternal getBroker();
    }

    public static class Field
    extends Image {
        private final FieldType type;
        private final Object value;

        public Field(FieldType fieldType, Object object) {
            this.type = fieldType;
            this.value = object;
        }

        @Override
        public void cleanup(boolean bl) {
        }

        @Override
        void referenceProcessing(Image image) {
        }

        @Override
        public boolean modified(Image image) {
            boolean bl = false;
            if (this == image) {
                bl = true;
            } else if (image instanceof Field) {
                bl = !this.type.equals(this.value, ((Field)image).value);
            }
            return bl;
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[type=" + this.type + ", value=" + this.value + "]";
        }
    }

    public static class SingleRef
    extends Image {
        private Object referenceObjOrProxy;
        private Identity oid = null;
        private final ImageListener listener;
        private final ObjectReferenceDescriptor ord;

        public SingleRef(ImageListener imageListener, ObjectReferenceDescriptor objectReferenceDescriptor, Object object) {
            this.listener = imageListener;
            this.ord = objectReferenceDescriptor;
            this.referenceObjOrProxy = object;
        }

        @Override
        public void cleanup(boolean bl) {
            if (!bl) {
                this.referenceObjOrProxy = null;
            }
        }

        @Override
        void referenceProcessing(Image image) {
            boolean bl;
            SingleRef singleRef = (SingleRef)image;
            boolean bl2 = bl = this.getReferenceObjectOrProxy() == singleRef.getReferenceObjectOrProxy();
            if (!bl) {
                Identity identity = this.getIdentity();
                Identity identity2 = singleRef.getIdentity();
                if (identity == null) {
                    if (identity2 != null) {
                        this.listener.deletedOneToOne(this.ord, singleRef.getReferenceObjectOrProxy(), identity2, true);
                    }
                } else if (identity2 == null) {
                    this.listener.addedOneToOne(this.ord, this.getReferenceObjectOrProxy(), identity);
                } else if (!identity.equals(identity2)) {
                    this.listener.deletedOneToOne(this.ord, singleRef.getReferenceObjectOrProxy(), identity2, false);
                    this.listener.addedOneToOne(this.ord, this.getReferenceObjectOrProxy(), identity);
                }
            }
        }

        public Object getReferenceObjectOrProxy() {
            return this.referenceObjOrProxy;
        }

        private Identity getIdentity() {
            if ((this.oid == null || this.oid.isTransient()) && this.referenceObjOrProxy != null) {
                this.oid = this.listener.getBroker().serviceIdentity().buildIdentity(this.referenceObjOrProxy);
            }
            return this.oid;
        }

        @Override
        public boolean modified(Image image) {
            boolean bl = false;
            if (this != image && image instanceof SingleRef) {
                SingleRef singleRef = (SingleRef)image;
                Identity identity = this.getIdentity();
                Identity identity2 = singleRef.getIdentity();
                bl = identity != null ? !identity.equals(identity2) : identity2 != null;
            }
            return bl;
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[reference=" + this.getIdentity() + "]";
        }
    }

    public static class MultipleRef
    extends Image
    implements CollectionProxyListener {
        static final int IS_NORMAL_OBJECT = 11;
        static final int IS_MATERIALIZED_PROXY = 13;
        static final int IS_UNMATERIALIZED_PROXY = 17;
        private ImageListener listener;
        private final CollectionDescriptor cod;
        private final Object collectionOrArray;
        private Map references;
        private int status;
        private boolean hasTransientIdentity;
        private boolean isRefreshed;

        public MultipleRef(ImageListener imageListener, CollectionDescriptor collectionDescriptor, Object object) {
            this.listener = imageListener;
            this.cod = collectionDescriptor;
            this.collectionOrArray = object;
            this.isRefreshed = true;
            this.hasTransientIdentity = false;
            this.references = Collections.EMPTY_MAP;
            this.init();
        }

        private void init() {
            CollectionProxy collectionProxy = ProxyHelper.getCollectionProxy(this.collectionOrArray);
            if (collectionProxy != null) {
                if (collectionProxy.isLoaded()) {
                    this.status = 13;
                    this.handleReferencedObjects(((Collection)((Object)collectionProxy)).iterator());
                } else {
                    this.status = 17;
                    if (log.isDebugEnabled()) {
                        log.debug("Unmaterialized proxy collection, use proxy listener");
                    }
                    collectionProxy.addListener(this);
                }
            } else {
                this.status = 11;
                if (this.collectionOrArray != null) {
                    Iterator iterator = BrokerHelper.getCollectionIterator(this.collectionOrArray);
                    this.handleReferencedObjects(iterator);
                }
            }
        }

        void handleReferencedObjects(Iterator iterator) {
            if (iterator == null) {
                return;
            }
            this.references = new HashMap();
            if (log.isDebugEnabled()) {
                log.debug("Handle collection references");
            }
            IdentityFactory identityFactory = this.listener.getBroker().serviceIdentity();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Identity identity = identityFactory.buildIdentity(e);
                if (!this.hasTransientIdentity && identity.isTransient()) {
                    this.hasTransientIdentity = true;
                }
                this.references.put(identity, e);
            }
        }

        @Override
        public void cleanup(boolean bl) {
            CollectionProxy collectionProxy;
            if (log.isDebugEnabled()) {
                log.debug("Cleanup collection image, reuse=" + bl);
            }
            if (bl) {
                this.isRefreshed = false;
            } else if (this.status == 17 && (collectionProxy = ProxyHelper.getCollectionProxy(this.collectionOrArray)) != null) {
                collectionProxy.removeListener(this);
            }
        }

        @Override
        void referenceProcessing(Image image) {
            Identity identity;
            MultipleRef multipleRef = (MultipleRef)image;
            if (this.incommensurableProxies(multipleRef)) {
                if (this.isUnmaterializedProxy()) {
                    this.handleReferencedObjects(BrokerHelper.getCollectionIterator(this.collectionOrArray));
                }
                if (multipleRef.isUnmaterializedProxy()) {
                    multipleRef.handleReferencedObjects(BrokerHelper.getCollectionIterator(multipleRef.collectionOrArray));
                }
            }
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            if (!multipleRef.isRefreshed) {
                multipleRef.refreshIdentities();
            }
            if (multipleRef.references.size() > 0) {
                for (Map.Entry entry : multipleRef.references.entrySet()) {
                    identity = (Identity)entry.getKey();
                    if (this.isUnmaterializedProxy() || this.containsReference(identity)) continue;
                    this.listener.deletedXToN(this.cod, entry.getValue(), identity);
                }
            }
            if (this.references.size() > 0) {
                for (Map.Entry entry : this.references.entrySet()) {
                    identity = (Identity)entry.getKey();
                    if (multipleRef.containsReference(identity)) continue;
                    this.listener.addedXToN(this.cod, entry.getValue(), identity);
                }
            }
        }

        private boolean incommensurableProxies(MultipleRef multipleRef) {
            boolean bl = false;
            if (multipleRef.isUnmaterializedProxy() || this.isUnmaterializedProxy()) {
                bl = !this.collectionOrArray.equals(multipleRef.collectionOrArray);
            }
            return bl;
        }

        private void refreshIdentities() {
            if (this.hasTransientIdentity && this.references.size() > 0) {
                this.hasTransientIdentity = false;
                ArrayList arrayList = new ArrayList(this.references.keySet());
                IdentityFactory identityFactory = this.listener.getBroker().serviceIdentity();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Identity identity = (Identity)arrayList.get(i);
                    if (!identity.isTransient()) continue;
                    Object v = this.references.remove(identity);
                    Identity identity2 = identityFactory.buildIdentity(v);
                    this.references.put(identity2, v);
                    if (this.hasTransientIdentity || !identity.isTransient()) continue;
                    this.hasTransientIdentity = true;
                }
                this.isRefreshed = true;
            }
        }

        @Override
        public boolean modified(Image image) {
            return false;
        }

        boolean containsReference(Identity identity) {
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            return this.references.containsKey(identity);
        }

        Map getIdentityReferenceObjectMap() {
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            return this.references;
        }

        boolean isMaterializedProxy() {
            return this.status == 13;
        }

        boolean isUnmaterializedProxy() {
            return this.status == 17;
        }

        @Override
        public void beforeLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
        }

        @Override
        public void afterLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
            if (this.status == 17) {
                this.status = 13;
                this.handleReferencedObjects(collectionProxyDefaultImpl.iterator());
                collectionProxyDefaultImpl.removeListener(this);
            }
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[references-size=" + (this.references != null ? "" + this.references.size() : "undefined") + "]";
        }
    }
}

