/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.FlashAttributeResultMatchers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001f\u0010\u0012\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0013\"\u00020\n\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/springframework/test/web/servlet/result/FlashAttributeResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/FlashAttributeResultMatchers;", "attribute", "", "name", "", "value", "T", "matcher", "Lorg/hamcrest/Matcher;", "attributeCount", "count", "", "attributeExists", "", "([Ljava/lang/String;)V", "spring-test"})
public final class FlashAttributeResultMatchersDsl {
    private final FlashAttributeResultMatchers matchers;
    private final ResultActions actions;

    public final <T> void attribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attribute(name, matcher));
    }

    public final void attribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attribute(name, value));
    }

    public final void attributeExists(String ... name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeExists(Arrays.copyOf(name, name.length)));
    }

    public final void attributeCount(int count) {
        this.actions.andExpect(this.matchers.attributeCount(count));
    }

    public FlashAttributeResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkParameterIsNotNull((Object)actions, (String)"actions");
        this.actions = actions;
        FlashAttributeResultMatchers flashAttributeResultMatchers = MockMvcResultMatchers.flash();
        Intrinsics.checkExpressionValueIsNotNull((Object)flashAttributeResultMatchers, (String)"MockMvcResultMatchers.flash()");
        this.matchers = flashAttributeResultMatchers;
    }
}

