/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class BaseInvocationHandler
implements InvocationHandler {
    private static final Method HASHCODE_METHOD;
    private static final Method EQUALS_METHOD;
    private static final Method TO_STRING_METHOD;

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            if (method.equals(HASHCODE_METHOD)) {
                return this.proxyHashCode(proxy);
            }
            if (method.equals(EQUALS_METHOD)) {
                return this.proxyEquals(proxy, arguments[0]);
            }
            if (method.equals(TO_STRING_METHOD)) {
                return this.proxyToString(proxy);
            }
        }
        try {
            return this.invokeInternal(proxy, method, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected abstract Object invokeInternal(Object var1, Method var2, Object[] var3) throws Throwable;

    protected int proxyHashCode(Object proxy) {
        return System.identityHashCode(proxy);
    }

    protected boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return this.toString();
    }

    static {
        try {
            HASHCODE_METHOD = Object.class.getMethod("hashCode", null);
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            TO_STRING_METHOD = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

