/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetContainer;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetForm
extends BudgetForm
implements BudgetContainer {
    private static final long serialVersionUID = 9001767909548738932L;
    private String awardInMultipleNodeHierarchy;
    private String budgetParentId;
    private AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = new AwardBudgetPeriodSummaryCalculatedAmount();
    private transient ParameterService parameterService;
    private transient AwardBudgetService awardBudgetService;
    private Boolean isBudgetVersionSummaryCumulative;

    @Override
    protected String getDefaultDocumentTypeName() {
        return "AwardBudgetDocument";
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getBudgetDocument().initialize();
    }

    public String getAwardInMultipleNodeHierarchy() {
        return this.awardInMultipleNodeHierarchy;
    }

    public void setAwardInMultipleNodeHierarchy(String awardInMultipleNodeHierarchy) {
        this.awardInMultipleNodeHierarchy = awardInMultipleNodeHierarchy;
    }

    public boolean isBudgetVersionSummaryCumulative() {
        if (this.isBudgetVersionSummaryCumulative == null) {
            this.isBudgetVersionSummaryCumulative = this.getParameterService().getParameterValueAsBoolean("KC-AB", "All", "Award_budget_version_summary_cumulative");
        }
        return this.isBudgetVersionSummaryCumulative;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    @Override
    public String getActionPrefix() {
        return "awardBudget";
    }

    public AwardBudgetDocument getAwardBudgetDocument() {
        return super.getBudgetDocument();
    }

    @Override
    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        AwardBudgetDocument doc = this.getAwardBudgetDocument();
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        TaskAuthorizationService tas = KcServiceLocator.getService(TaskAuthorizationService.class);
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new AwardBudgetTask("toggleAwardBudgetStatus", doc))) {
            String toggleAwardStatusButtonImage = this.buildExtraButtonSourceURI("buttonsmall_toggleBudgetStatus.gif");
            this.addExtraButton("methodToCall.toggleAwardBudgetStatus", toggleAwardStatusButtonImage, "Toggle Budget Status", "Toggle Status");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new AwardBudgetTask("postAwardBudget", doc))) {
            String postAwardBudgetImage = this.buildExtraButtonSourceURI("buttonsmall_postawardbudget.gif");
            this.addExtraButton("methodToCall.postAwardBudget", postAwardBudgetImage, "Post Budget", "Post");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), new AwardBudgetTask("rejectBudget", doc))) {
            this.addExtraButton("methodToCall.reject", this.buildExtraButtonSourceURI("buttonsmall_reject.gif"), "Return");
        }
        return this.extraButtons;
    }

    public void setBudgetParentId(String budgetParentId) {
        this.budgetParentId = budgetParentId;
    }

    public String getBudgetParentId() {
        return this.budgetParentId;
    }

    public String getFnARateFlagEditable() {
        return Boolean.toString(!this.getAwardBudgetDocument().getAwardBudget().getOhRatesNonEditable());
    }

    @Override
    protected HeaderField getHeaderDocNumber() {
        return new HeaderField("DataDictionary.DocumentHeader.attributes.documentNumber", this.getBudgetDocument() == null ? null : this.getBudgetDocument().getDocumentNumber());
    }

    @Override
    protected HeaderField getHeaderDocStatus(WorkflowDocument parentWorkflowDocument) {
        AwardBudgetExt abe = this.getAwardBudgetDocument().getAwardBudget();
        return new HeaderField("DataDictionary.AttributeReference.attributes.workflowDocumentStatus", "<div id = \"awardBudgetStatus\">" + abe.getAwardBudgetStatus().getDescription() + "</div>");
    }

    @Override
    protected HeaderField getHeaderDocInitiator(WorkflowDocument parentWorkflowDocument) {
        WorkflowDocument doc = this.getBudgetDocument().getDocumentHeader().getWorkflowDocument();
        return new HeaderField("DataDictionary.AttributeReference.attributes.initiatorNetworkId", doc.getInitiatorPrincipalId());
    }

    @Override
    protected HeaderField getHeaderDocCreateDate(WorkflowDocument parentWorkflowDocument) {
        Date ts = this.getBudgetDocument().getDocumentHeader().getWorkflowDocument().getDateCreated().toDate();
        String updateDateStr = CoreApiServiceLocator.getDateTimeService().toString(ts, "hh:mm a MM/dd/yyyy");
        return new HeaderField("DataDictionary.AttributeReference.attributes.createDate", updateDateStr);
    }

    public AwardBudgetPeriodSummaryCalculatedAmount getAwardBudgetPeriodSummaryCalculatedAmount() {
        return this.awardBudgetPeriodSummaryCalculatedAmount;
    }

    public void setAwardBudgetPeriodSummaryCalculatedAmount(AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount) {
        this.awardBudgetPeriodSummaryCalculatedAmount = awardBudgetPeriodSummaryCalculatedAmount;
    }

    @Override
    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((CharSequence)nav.getHeaderTabNavigateTo(), (CharSequence)"modularBudget")) continue;
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    @Override
    public boolean getCanModifyBudgetRates() {
        return this.getEditingMode().containsKey("modifyBudgets");
    }

    public Award getAward() {
        return this.getAwardBudgetDocument().getBudget().getBudgetParent();
    }

    public ScaleTwoDecimal getObligatedTotal() {
        return (ScaleTwoDecimal)this.getPreviousObligatedTotal().add((AbstractDecimal)this.getObligatedChange());
    }

    public ScaleTwoDecimal getPreviousObligatedTotal() {
        AwardBudgetExt awardBudgetExt = this.getAwardBudgetDocument().getAwardBudget();
        Award award = this.getAwardBudgetDocument().getBudget().getBudgetParent();
        return this.getSumOfAllPreviousBudgetChanges(awardBudgetExt, award.getBudgets());
    }

    protected ScaleTwoDecimal getSumOfAllPreviousBudgetChanges(AwardBudgetExt curentAwardBudgetExt, List<? extends Budget> allBudgets) {
        if (curentAwardBudgetExt != null && curentAwardBudgetExt.getPrevBudget() != null) {
            ScaleTwoDecimal previousTotalCost = curentAwardBudgetExt.getPrevBudget().getTotalCostLimit();
            AwardBudgetExt previousAwardBudget = this.findAwardBudgetExt(curentAwardBudgetExt.getPrevBudget().getBudgetId(), allBudgets);
            return (ScaleTwoDecimal)previousTotalCost.add((AbstractDecimal)this.getSumOfAllPreviousBudgetChanges(previousAwardBudget, allBudgets));
        }
        return ScaleTwoDecimal.ZERO;
    }

    protected AwardBudgetExt findAwardBudgetExt(Long budgetId, List<? extends Budget> allBudgets) {
        for (Budget budget : allBudgets) {
            if (!budget.getBudgetId().equals(budgetId)) continue;
            return (AwardBudgetExt)budget;
        }
        return null;
    }

    public ScaleTwoDecimal getObligatedChange() {
        AwardBudgetExt budget = this.getAwardBudgetDocument().getAwardBudget();
        if (budget != null && budget.getTotalCostLimit() != null) {
            return budget.getTotalCostLimit();
        }
        return ScaleTwoDecimal.ZERO;
    }

    public boolean isBudgetPostRestIntegrationOn() {
        return this.getAwardBudgetService().isBudgetPostRestIntegrationOn();
    }
}

