/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ehcache.config.ResourceType;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.store.StoreSupport;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;

@OptionalServiceDependencies(value={"org.ehcache.core.spi.service.StatisticsService"})
public abstract class AbstractWrapperStoreProvider
implements Store.Provider {
    private volatile ServiceProvider<Service> serviceProvider;
    private final Set<Class<? extends ServiceConfiguration<?, ?>>> requiredConfigurationTypes;
    private final Map<Store<?, ?>, StoreReference<?, ?>> createdStores = new ConcurrentWeakIdentityHashMap();

    @SafeVarargs
    protected AbstractWrapperStoreProvider(Class<? extends ServiceConfiguration<?, ?>> ... requiredConfigurationTypes) {
        this.requiredConfigurationTypes = new HashSet(Arrays.asList(requiredConfigurationTypes));
    }

    @Override
    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        StatisticsService statisticsService;
        List<ServiceConfiguration<?, ?>> configs;
        Set resources = storeConfig.getResourcePools().getResourceTypeSet();
        Store.Provider underlyingStoreProvider = this.getUnderlyingStoreProvider(resources, configs = Arrays.asList(serviceConfigs));
        Store<K, V> store = underlyingStoreProvider.createStore(storeConfig, serviceConfigs);
        Store<K, V> wrappedStore = this.wrap(store, storeConfig, serviceConfigs);
        if (wrappedStore != store && (statisticsService = (StatisticsService)this.serviceProvider.getService(StatisticsService.class)) != null) {
            statisticsService.registerWithParent(store, wrappedStore);
        }
        this.createdStores.put(wrappedStore, new StoreReference<K, V>(store, underlyingStoreProvider));
        return wrappedStore;
    }

    protected Store.Provider getUnderlyingStoreProvider(Set<ResourceType<?>> resources, List<ServiceConfiguration<?, ?>> configs) {
        return StoreSupport.select(Store.Provider.class, this.serviceProvider, store -> {
            if (store instanceof AbstractWrapperStoreProvider && ((AbstractWrapperStoreProvider)store).wrapperRank() >= this.wrapperRank()) {
                return 0;
            }
            return store.rank(resources, configs);
        });
    }

    @Override
    public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        if (this.requiredConfigurationTypes.stream().allMatch(rct -> serviceConfigs.stream().anyMatch(rct::isInstance))) {
            return StoreSupport.trySelect(Store.Provider.class, this.serviceProvider, store -> {
                if (store instanceof AbstractWrapperStoreProvider && ((AbstractWrapperStoreProvider)store).wrapperRank() >= this.wrapperRank()) {
                    return 0;
                }
                return store.rank(resourceTypes, serviceConfigs);
            }).map(sp -> sp.rank(resourceTypes, serviceConfigs) + this.wrapperPriority()).orElse(0);
        }
        return 0;
    }

    protected abstract int wrapperRank();

    protected int wrapperPriority() {
        return 1;
    }

    protected abstract <K, V> Store<K, V> wrap(Store<K, V> var1, Store.Configuration<K, V> var2, ServiceConfiguration<?, ?> ... var3);

    @Override
    public void releaseStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.remove(resource);
        if (storeRef != null) {
            storeRef.release();
        }
    }

    @Override
    public void initStore(Store<?, ?> resource) {
        StoreReference<?, ?> storeRef = this.createdStores.get(resource);
        if (storeRef != null) {
            storeRef.init();
        }
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
        this.createdStores.clear();
        this.serviceProvider = null;
    }

    private static class StoreReference<K, V> {
        private final Store<K, V> store;
        private final Store.Provider provider;

        public StoreReference(Store<K, V> store, Store.Provider provider) {
            this.store = store;
            this.provider = provider;
        }

        public void release() {
            this.provider.releaseStore(this.store);
        }

        public void init() {
            this.provider.initStore(this.store);
        }
    }
}

