/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.Collections;
import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.PropositionResult;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.result.BasicResult;

public class ComparableTermBasedProposition<T>
implements Proposition {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private final ComparisonOperator operator;
    private final Term term;
    private final T expectedValue;

    public ComparableTermBasedProposition(ComparisonOperator operator, Term term, T expectedValue) {
        this.operator = operator;
        this.term = term;
        this.expectedValue = expectedValue;
    }

    @Override
    public PropositionResult evaluate(ExecutionEnvironment environment) {
        Comparable termValue = (Comparable)environment.resolveTerm(this.term, (Object)this);
        boolean result = this.compare(termValue);
        if (LOG.isEnabled(environment)) {
            LOG.logResult(new BasicResult("Proposition Evaluated", this, environment, result));
        }
        return new PropositionResult(result);
    }

    protected boolean compare(Comparable<T> termValue) {
        boolean result = this.operator.compare(termValue, this.getExpectedValue());
        return result;
    }

    @Override
    public List<Proposition> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    protected T getExpectedValue() {
        return this.expectedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.term.toString());
        sb.append(" " + this.operator.toString());
        sb.append(" " + this.expectedValue.toString());
        return sb.toString();
    }
}

