/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WritingSegmentJumpList
implements Iterable<Long> {
    private final int chunkSize;
    private ArrayList<IntRun> buffers = new ArrayList();
    private long lastValue = Long.MIN_VALUE;
    private IntRun currentRun = null;
    private long firstValue = Long.MIN_VALUE;
    private int count = 0;
    private long byteFootprint = 0L;

    public WritingSegmentJumpList() {
        this(8192);
    }

    public WritingSegmentJumpList(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void clear() {
        this.lastValue = Long.MIN_VALUE;
        this.firstValue = Long.MIN_VALUE;
        this.currentRun = null;
        this.count = 0;
        this.byteFootprint = 0L;
        this.buffers.clear();
    }

    public void add(long l) {
        if (this.buffers.isEmpty()) {
            this.lastValue = l;
            this.firstValue = l;
            this.currentRun = this.addNextBuffer();
            this.currentRun.addInt((int)(l - this.lastValue));
            ++this.count;
        } else if (this.currentRun.isFull()) {
            this.currentRun = this.addNextBuffer();
            this.currentRun.addInt((int)(l - this.lastValue));
            this.lastValue = l;
            ++this.count;
        } else {
            this.currentRun.addInt((int)(l - this.lastValue));
            this.lastValue = l;
            ++this.count;
        }
    }

    private IntRun addNextBuffer() {
        IntRun run = new IntRun(new int[this.chunkSize]);
        this.buffers.add(run);
        this.byteFootprint += (long)(this.chunkSize * 4);
        return run;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            int currIndex = 0;
            int runIndex = 0;
            long base = WritingSegmentJumpList.access$000(WritingSegmentJumpList.this);

            @Override
            public boolean hasNext() {
                return this.currIndex < WritingSegmentJumpList.this.buffers.size() && this.runIndex < ((IntRun)WritingSegmentJumpList.this.buffers.get(this.currIndex)).getCount();
            }

            @Override
            public Long next() {
                if (this.hasNext()) {
                    long ret;
                    IntRun run = (IntRun)WritingSegmentJumpList.this.buffers.get(this.currIndex);
                    this.base = ret = (long)run.get(this.runIndex++) + this.base;
                    if (this.runIndex >= run.getCount()) {
                        ++this.currIndex;
                        this.runIndex = 0;
                    }
                    return ret;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.count;
    }

    static /* synthetic */ long access$000(WritingSegmentJumpList x0) {
        return x0.firstValue;
    }

    static class IntRun {
        private int[] iarr;
        private int count;

        public IntRun(int[] iarr) {
            this.iarr = iarr;
            this.count = 0;
        }

        public int getCapacity() {
            return this.iarr.length;
        }

        public boolean isFull() {
            return this.count >= this.iarr.length;
        }

        public int get(int index) {
            return this.iarr[index];
        }

        public int getCount() {
            return this.count;
        }

        public void addInt(int val) {
            this.iarr[this.count++] = val;
        }
    }
}

