/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.recovery;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.InvalidatingAction;
import com.terracottatech.frs.recovery.AbstractFilter;
import com.terracottatech.frs.recovery.Filter;
import com.terracottatech.frs.util.CompressedLongSet;
import java.util.HashSet;
import java.util.Set;

public class SkipsFilter
extends AbstractFilter<Action> {
    private final long lowestLsn;
    private final Set<Long> skips;

    public SkipsFilter(Filter<Action> nextFilter, long lowestLsn, boolean compressed) {
        super(nextFilter);
        this.lowestLsn = lowestLsn;
        this.skips = compressed ? new CompressedLongSet() : new HashSet<Long>();
    }

    @Override
    public boolean filter(Action element, long lsn, boolean filtered) {
        if (this.skips.remove(lsn)) {
            this.updateSkips(element);
            return this.delegate(element, lsn, true);
        }
        if (this.delegate(element, lsn, filtered)) {
            this.updateSkips(element);
            return true;
        }
        return false;
    }

    private void updateSkips(Action action) {
        if (action instanceof InvalidatingAction) {
            for (long invalid : ((InvalidatingAction)action).getInvalidatedLsns()) {
                if (invalid < this.lowestLsn) continue;
                this.skips.add(invalid);
            }
        }
    }
}

