/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.InvalidPropertyException;
import com.codiform.moo.annotation.AccessMode;
import com.codiform.moo.annotation.CollectionProperty;
import com.codiform.moo.annotation.Ignore;
import com.codiform.moo.annotation.InvalidAnnotationException;
import com.codiform.moo.annotation.MapProperty;
import com.codiform.moo.property.CollectionFieldProperty;
import com.codiform.moo.property.CollectionMethodProperty;
import com.codiform.moo.property.FieldProperty;
import com.codiform.moo.property.MapFieldProperty;
import com.codiform.moo.property.MapMethodProperty;
import com.codiform.moo.property.MethodProperty;
import com.codiform.moo.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;

public class PropertyFactory {
    public static Property createProperty(Field field, AccessMode mode) {
        if (PropertyFactory.isCollection(field.getType())) {
            return PropertyFactory.createCollectionFieldProperty(field, mode);
        }
        if (PropertyFactory.isMap(field.getType())) {
            return PropertyFactory.createMapFieldProperty(field, mode);
        }
        return PropertyFactory.createFieldProperty(field, mode);
    }

    private static Property createCollectionFieldProperty(Field field, AccessMode mode) {
        Ignore ignoreAnnotation = field.getAnnotation(Ignore.class);
        CollectionProperty propertyAnnotation = field.getAnnotation(CollectionProperty.class);
        String name = field.getName();
        Class<?> declaringClass = field.getDeclaringClass();
        PropertyFactory.validateNoPropertyAnnotation(field.getAnnotation(com.codiform.moo.annotation.Property.class), name, declaringClass);
        PropertyFactory.validateNoMapPropertyAnnotation(field.getAnnotation(MapProperty.class), name, declaringClass);
        boolean explicit = PropertyFactory.isExplicit(ignoreAnnotation, propertyAnnotation);
        boolean ignore = ignoreAnnotation != null;
        String expression = PropertyFactory.getExpression(name, propertyAnnotation);
        if (explicit || mode == AccessMode.FIELD) {
            String errorMessage = PropertyFactory.validateField(field);
            if (errorMessage == null) {
                return new CollectionFieldProperty(field, propertyAnnotation, name, expression, explicit, ignore);
            }
            if (explicit) {
                throw new InvalidPropertyException(name, declaringClass, errorMessage);
            }
        }
        return null;
    }

    private static Property createMapFieldProperty(Field field, AccessMode mode) {
        Ignore ignoreAnnotation = field.getAnnotation(Ignore.class);
        MapProperty propertyAnnotation = field.getAnnotation(MapProperty.class);
        String name = field.getName();
        Class<?> declaringClass = field.getDeclaringClass();
        PropertyFactory.validateNoPropertyAnnotation(field.getAnnotation(com.codiform.moo.annotation.Property.class), name, declaringClass);
        PropertyFactory.validateNoCollectionPropertyAnnotation(field.getAnnotation(CollectionProperty.class), name, declaringClass);
        boolean explicit = PropertyFactory.isExplicit(ignoreAnnotation, propertyAnnotation);
        boolean ignore = ignoreAnnotation != null;
        String expression = PropertyFactory.getExpression(name, propertyAnnotation);
        if (explicit || mode == AccessMode.FIELD) {
            String errorMessage = PropertyFactory.validateField(field);
            if (errorMessage == null) {
                return new MapFieldProperty(field, propertyAnnotation, name, expression, explicit, ignore);
            }
            if (explicit) {
                throw new InvalidPropertyException(name, declaringClass, errorMessage);
            }
        }
        return null;
    }

    private static void validateNoPropertyAnnotation(com.codiform.moo.annotation.Property annotation, String propertyName, Class<?> declaringClass) {
        if (annotation != null) {
            throw new InvalidAnnotationException("The property %s on class %s is a map or collection and should not be annotated with @Property; use @CollectionProperty or @MapProperty instead.", propertyName, declaringClass);
        }
    }

    private static void validateNoCollectionPropertyAnnotation(CollectionProperty annotation, String propertyName, Class<?> declaringClass) {
        if (annotation != null) {
            throw new InvalidAnnotationException("The property %s on class %s is not a collection and should not be annotated with @CollectionProperty.", propertyName, declaringClass);
        }
    }

    private static void validateNoMapPropertyAnnotation(MapProperty annotation, String propertyName, Class<?> declaringClass) {
        if (annotation != null) {
            throw new InvalidAnnotationException("The property %s on class %s is not a map and should not be annotated with @MapProperty.", propertyName, declaringClass);
        }
    }

    private static boolean isExplicit(Ignore ignoreAnnotation, Annotation ... propertyAnnotations) {
        if (ignoreAnnotation != null) {
            return true;
        }
        for (Annotation item : propertyAnnotations) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    private static Property createFieldProperty(Field field, AccessMode mode) {
        Ignore ignoreAnnotation = field.getAnnotation(Ignore.class);
        com.codiform.moo.annotation.Property propertyAnnotation = field.getAnnotation(com.codiform.moo.annotation.Property.class);
        String name = field.getName();
        Class<?> declaringClass = field.getDeclaringClass();
        boolean explicit = PropertyFactory.isExplicit(ignoreAnnotation, propertyAnnotation);
        boolean ignore = ignoreAnnotation != null;
        PropertyFactory.validateNoCollectionPropertyAnnotation(field.getAnnotation(CollectionProperty.class), name, declaringClass);
        PropertyFactory.validateNoMapPropertyAnnotation(field.getAnnotation(MapProperty.class), name, declaringClass);
        String expression = PropertyFactory.getExpression(name, propertyAnnotation);
        if (explicit || mode == AccessMode.FIELD) {
            String errorMessage = PropertyFactory.validateField(field);
            if (errorMessage == null) {
                return new FieldProperty(field, propertyAnnotation, name, expression, explicit, ignore);
            }
            if (explicit) {
                throw new InvalidPropertyException(name, declaringClass, errorMessage);
            }
        }
        return null;
    }

    private static String validateField(Field field) {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return "%s (%s) is annotated with @Property, but is static.  Moo does not support static fields as properties.";
        }
        if (Modifier.isFinal(modifiers)) {
            return "%s (%s) is annotated with @Property, but is final.  Moo cannot write to final fields as properties.";
        }
        return null;
    }

    private static String getExpression(String name, com.codiform.moo.annotation.Property annotation) {
        if (annotation == null || annotation.source() == null || annotation.source().isEmpty()) {
            return name;
        }
        return annotation.source().trim();
    }

    private static String getExpression(String name, MapProperty annotation) {
        if (annotation == null || annotation.source() == null || annotation.source().isEmpty()) {
            return name;
        }
        return annotation.source().trim();
    }

    private static String getExpression(String name, CollectionProperty annotation) {
        if (annotation == null || annotation.source() == null || annotation.source().isEmpty()) {
            return name;
        }
        return annotation.source().trim();
    }

    private static boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static Property createProperty(Method method, AccessMode mode) {
        boolean ignore;
        com.codiform.moo.annotation.Property propertyAnnotation = method.getAnnotation(com.codiform.moo.annotation.Property.class);
        CollectionProperty collectionAnnotation = method.getAnnotation(CollectionProperty.class);
        MapProperty mapAnnotation = method.getAnnotation(MapProperty.class);
        Ignore ignoreAnnotation = method.getAnnotation(Ignore.class);
        String methodName = method.getName();
        String propertyName = PropertyFactory.getPropertyName(methodName);
        Class<?>[] parameters = method.getParameterTypes();
        boolean explicit = PropertyFactory.isExplicit(ignoreAnnotation, propertyAnnotation, collectionAnnotation);
        boolean bl = ignore = ignoreAnnotation != null;
        if (explicit || mode == AccessMode.METHOD) {
            String errorMessage = PropertyFactory.validateMethod(methodName, propertyName, parameters, method.getModifiers());
            Class<?> declaringClass = method.getDeclaringClass();
            if (errorMessage == null) {
                if (PropertyFactory.isCollection(parameters[0])) {
                    PropertyFactory.validateNoPropertyAnnotation(propertyAnnotation, propertyName, declaringClass);
                    PropertyFactory.validateNoMapPropertyAnnotation(mapAnnotation, propertyName, declaringClass);
                    return PropertyFactory.createCollectionMethodProperty(method, collectionAnnotation, propertyName, explicit, ignore);
                }
                if (PropertyFactory.isMap(parameters[0])) {
                    PropertyFactory.validateNoPropertyAnnotation(propertyAnnotation, propertyName, declaringClass);
                    PropertyFactory.validateNoCollectionPropertyAnnotation(collectionAnnotation, propertyName, declaringClass);
                    return PropertyFactory.createMapMethodProperty(method, mapAnnotation, propertyName, explicit, ignore);
                }
                PropertyFactory.validateNoCollectionPropertyAnnotation(collectionAnnotation, propertyName, declaringClass);
                PropertyFactory.validateNoMapPropertyAnnotation(mapAnnotation, propertyName, declaringClass);
                return PropertyFactory.createMethodProperty(method, propertyAnnotation, propertyName, explicit, ignore);
            }
            if (explicit) {
                throw new InvalidPropertyException(propertyName == null ? methodName : propertyName, method.getDeclaringClass(), errorMessage);
            }
        }
        return null;
    }

    private static Property createCollectionMethodProperty(Method method, CollectionProperty annotation, String propertyName, boolean explicit, boolean ignore) {
        String expression = PropertyFactory.getExpression(propertyName, annotation);
        return new CollectionMethodProperty(method, annotation, propertyName, expression, explicit, ignore);
    }

    private static Property createMapMethodProperty(Method method, MapProperty annotation, String propertyName, boolean explicit, boolean ignore) {
        String expression = PropertyFactory.getExpression(propertyName, annotation);
        return new MapMethodProperty(method, annotation, propertyName, expression, explicit, ignore);
    }

    private static Property createMethodProperty(Method method, com.codiform.moo.annotation.Property annotation, String propertyName, boolean explicit, boolean ignore) {
        String expression = PropertyFactory.getExpression(propertyName, annotation);
        return new MethodProperty(method, annotation, propertyName, expression, explicit, ignore);
    }

    private static String validateMethod(String methodName, String propertyName, Class<?>[] parameters, int modifiers) {
        if (propertyName == null) {
            return "Method %s (in %s) is annotated as a property but does not follow the 'set<Name>' pattern required of a method property.";
        }
        if (parameters.length != 1) {
            return "Method %s (in %s) is marked with @Property but is not a single-parameter method.";
        }
        if (Modifier.isStatic(modifiers)) {
            return "Method %s (in %s) is marked with @Property but is static; Moo doesn't support static methods as properties.";
        }
        return null;
    }

    private static String getPropertyName(String methodName) {
        if (methodName.length() > 3 && methodName.startsWith("set")) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        return null;
    }
}

