/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core._TemplateModelException;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.utility.NumberUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class NumericalBuiltins {
    private static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal("1");
    private static final BigDecimal BIG_DECIMAL_LONG_MIN = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BIG_DECIMAL_LONG_MAX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigInteger BIG_INTEGER_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger BIG_INTEGER_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    private NumericalBuiltins() {
    }

    private static final long safeToLong(Number num) throws TemplateModelException {
        if (num instanceof Double) {
            double d = Math.round((Double)num);
            if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                throw new _TemplateModelException(new Object[]{"Number doesn't fit into a 64 bit signed integer (long): ", new Double(d)});
            }
            return (long)d;
        }
        if (num instanceof Float) {
            float f = Math.round(((Float)num).floatValue());
            if (f > 9.223372E18f || f < -9.223372E18f) {
                throw new _TemplateModelException(new Object[]{"Number doesn't fit into a 64 bit signed integer (long): ", new Float(f)});
            }
            return (long)f;
        }
        if (num instanceof BigDecimal) {
            BigDecimal bd = ((BigDecimal)num).setScale(0, 4);
            if (bd.compareTo(BIG_DECIMAL_LONG_MAX) > 0 || bd.compareTo(BIG_DECIMAL_LONG_MIN) < 0) {
                throw new _TemplateModelException(new Object[]{"Number doesn't fit into a 64 bit signed integer (long): ", bd});
            }
            return bd.longValue();
        }
        if (num instanceof BigInteger) {
            BigInteger bi = (BigInteger)num;
            if (bi.compareTo(BIG_INTEGER_LONG_MAX) > 0 || bi.compareTo(BIG_INTEGER_LONG_MIN) < 0) {
                throw new _TemplateModelException(new Object[]{"Number doesn't fit into a 64 bit signed integer (long): ", bi});
            }
            return bi.longValue();
        }
        if (num instanceof Long || num instanceof Integer || num instanceof Byte || num instanceof Short) {
            return num.longValue();
        }
        throw new _TemplateModelException(new Object[]{"Unsupported number type: ", num.getClass()});
    }

    static class number_to_dateBI
    extends NumberBuiltIn {
        private final int dateType;

        number_to_dateBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return new SimpleDate(new Date(NumericalBuiltins.safeToLong(num)), this.dateType);
        }
    }

    static class is_infiniteBI
    extends NumberBuiltIn {
        is_infiniteBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return NumberUtil.isInfinite(num) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_nanBI
    extends NumberBuiltIn {
        is_nanBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return NumberUtil.isNaN(num) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class absBI
    extends NumberBuiltIn {
        absBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            if (num instanceof Integer) {
                int n = (Integer)num;
                if (n < 0) {
                    return new SimpleNumber(-n);
                }
                return model;
            }
            if (num instanceof BigDecimal) {
                BigDecimal n = (BigDecimal)num;
                if (n.signum() < 0) {
                    return new SimpleNumber(n.negate());
                }
                return model;
            }
            if (num instanceof Double) {
                double n = (Double)num;
                if (n < 0.0) {
                    return new SimpleNumber(-n);
                }
                return model;
            }
            if (num instanceof Float) {
                float n = ((Float)num).floatValue();
                if (n < 0.0f) {
                    return new SimpleNumber(-n);
                }
                return model;
            }
            if (num instanceof Long) {
                long n = (Long)num;
                if (n < 0L) {
                    return new SimpleNumber(-n);
                }
                return model;
            }
            if (num instanceof Short) {
                short n = (Short)num;
                if (n < 0) {
                    return new SimpleNumber((int)(-n));
                }
                return model;
            }
            if (num instanceof Byte) {
                byte n = (Byte)num;
                if (n < 0) {
                    return new SimpleNumber((int)(-n));
                }
                return model;
            }
            if (num instanceof BigInteger) {
                BigInteger n = (BigInteger)num;
                if (n.signum() < 0) {
                    return new SimpleNumber(n.negate());
                }
                return model;
            }
            throw new _TemplateModelException(new Object[]{"Unsupported number class: ", num.getClass()});
        }
    }

    static class roundBI
    extends NumberBuiltIn {
        private static final BigDecimal half = new BigDecimal("0.5");

        roundBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).add(half).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class ceilingBI
    extends NumberBuiltIn {
        ceilingBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 2));
        }
    }

    static class floorBI
    extends NumberBuiltIn {
        floorBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class doubleBI
    extends NumberBuiltIn {
        doubleBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Double) {
                return model;
            }
            return new SimpleNumber(num.doubleValue());
        }
    }

    static class floatBI
    extends NumberBuiltIn {
        floatBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Float) {
                return model;
            }
            return new SimpleNumber(num.floatValue());
        }
    }

    static class longBI
    extends BuiltIn {
        longBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (!(model instanceof TemplateNumberModel) && model instanceof TemplateDateModel) {
                Date date = EvalUtil.modelToDate((TemplateDateModel)model, this.target);
                return new SimpleNumber(date.getTime());
            }
            Number num = this.target.modelToNumber(model, env);
            if (num instanceof Long) {
                return model;
            }
            return new SimpleNumber(num.longValue());
        }
    }

    static class intBI
    extends NumberBuiltIn {
        intBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Integer) {
                return model;
            }
            return new SimpleNumber(num.intValue());
        }
    }

    static class shortBI
    extends NumberBuiltIn {
        shortBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Short) {
                return model;
            }
            return new SimpleNumber(new Short(num.shortValue()));
        }
    }

    static class byteBI
    extends NumberBuiltIn {
        byteBI() {
        }

        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Byte) {
                return model;
            }
            return new SimpleNumber(new Byte(num.byteValue()));
        }
    }

    private static abstract class NumberBuiltIn
    extends BuiltIn {
        private NumberBuiltIn() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            return this.calculateResult(this.target.modelToNumber(model, env), model);
        }

        abstract TemplateModel calculateResult(Number var1, TemplateModel var2) throws TemplateModelException;
    }
}

