/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.CachingBufferSource;
import java.nio.ByteBuffer;

public class LimitedCachingBufferSource
extends CachingBufferSource {
    private final long limit;

    public LimitedCachingBufferSource(long limit) {
        this.limit = limit;
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        long size = super.getSize();
        while (size - (long)buffer.capacity() > this.limit && super.count() > 0) {
            size -= (long)super.removeSmallest();
        }
        super.returnBuffer(buffer);
    }

    @Override
    public ByteBuffer getBuffer(int size) {
        if ((long)size > this.limit) {
            return null;
        }
        return super.getBuffer(size);
    }

    public long getLimit() {
        return this.limit;
    }
}

