/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.document.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalDocumentAuthorizer
extends TransactionalDocumentAuthorizerBase
implements TransactionalDocumentAuthorizer {
    public static final String ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY = "DISAPPROVED_PD_WITH_LINKED_IP";
    public static final String MAINTAIN_PERSONNEL_UNITS = "maintainPersonnelUnits";

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        Set actions = super.getDocumentActions(document, user, documentActions);
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        if (this.canMaintainInstitutionalProposal(user, institutionalProposalDocument)) {
            actions.add("CAN_MAINTAIN_IP_ATTACHMENTS");
        }
        if (actions.contains("CAN_MAINTAIN_IP_ATTACHMENTS") || this.canViewInstitutionalProposalAttachments(user, institutionalProposalDocument)) {
            actions.add("CAN_VIEW_IP_ATTACHMENTS");
        }
        if (this.canViewInstitutionalProposalSummaryViewOnly(user, institutionalProposalDocument)) {
            actions.add("CAN_VIEW_IP_SUMMARY_VIEW_ONLY");
        }
        return actions;
    }

    protected void addRoleQualification(Object primaryBusinessObjectOrDocument, Map<String, String> attributes) {
        super.addRoleQualification(primaryBusinessObjectOrDocument, attributes);
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)primaryBusinessObjectOrDocument;
        if (institutionalProposalDocument.getInstitutionalProposal() != null && institutionalProposalDocument.getInstitutionalProposal().getLeadUnit() != null) {
            attributes.put("unitNumber", institutionalProposalDocument.getInstitutionalProposal().getLeadUnit().getUnitNumber());
        } else {
            attributes.put("unitNumber", "*");
        }
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get(ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY) != null) {
            GlobalVariables.getUserSession().removeObject(ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY);
            return true;
        }
        return super.canInitiate(documentTypeName, user);
    }

    public boolean canOpen(Document document, Person user) {
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)document;
        Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers(proposalDocument);
        proposalDocument.populateAdditionalQualifiedRoleAttributes(qualifiedRoleAttributes);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Open Document", user.getPrincipalId(), Collections.emptyMap(), qualifiedRoleAttributes);
    }

    private Map<String, String> createStandardQualifiers(Permissionable permissionable) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        this.addDocumentQualifiers(permissionable, qualifiedRoleAttributes);
        return qualifiedRoleAttributes;
    }

    private void addDocumentQualifiers(Permissionable permissionable, Map<String, String> qualifiers) {
        if (permissionable instanceof DocumentLevelPermissionable && qualifiers != null) {
            qualifiers.put("documentNumber", ((DocumentLevelPermissionable)permissionable).getDocumentNumber());
        }
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canBlanketApprove(document, user);
    }

    public boolean canRoute(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canRoute(document, user);
    }

    public boolean canCancel(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canCancel(document, user);
    }

    public boolean canViewInstitutionalProposalSummaryViewOnly(Person user, InstitutionalProposalDocument document) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "View Institutional Proposal Summary View Only");
    }

    private boolean canViewInstitutionalProposalAttachments(Person user, InstitutionalProposalDocument document) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "View Institutional Proposal Attachments");
    }

    private boolean canMaintainInstitutionalProposal(Person user, InstitutionalProposalDocument document) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Create Institutional Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Edit Institutional Proposal");
    }

    public boolean canMaintainPersonnelUnits(Permissionable document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Maintain Institutional Proposal Personnel Units");
    }

    private KcAuthorizationService getKcAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

