/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="image", parent="Uif-Image")
public class Image
extends ContentElementBase {
    private static final long serialVersionUID = -3911849875276940507L;
    private String source;
    private String altText = "";
    private String height;
    private String width;
    private boolean captionHeaderPlacementAboveImage;
    private String captionHeaderText;
    private Header captionHeader;
    private String cutlineText;
    private Message cutlineMessage;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if ((StringUtils.isNotBlank((String)this.captionHeaderText) || this.getPropertyExpression("captionHeaderText") != null) && this.captionHeader == null) {
            this.captionHeader = ComponentFactory.getImageCaptionHeader();
        }
        if ((StringUtils.isNotBlank((String)this.cutlineText) || this.getPropertyExpression("cutlineText") != null) && this.cutlineMessage == null) {
            this.cutlineMessage = ComponentFactory.getImageCutlineMessage();
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (StringUtils.isNotBlank((String)this.captionHeaderText)) {
            this.captionHeader.setHeaderText(this.captionHeaderText);
        }
        if (StringUtils.isNotBlank((String)this.cutlineText)) {
            this.cutlineMessage.setMessageText(this.cutlineText);
        }
    }

    @BeanTagAttribute
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @BeanTagAttribute
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    @BeanTagAttribute
    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Override
    @BeanTagAttribute
    public String getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(String width) {
        this.width = width;
    }

    @BeanTagAttribute
    public String getCaptionHeaderText() {
        return this.captionHeaderText;
    }

    public void setCaptionHeaderText(String captionHeaderText) {
        this.captionHeaderText = captionHeaderText;
    }

    @BeanTagAttribute
    public Header getCaptionHeader() {
        return this.captionHeader;
    }

    public void setCaptionHeader(Header captionHeader) {
        this.captionHeader = captionHeader;
    }

    @BeanTagAttribute
    public String getCutlineText() {
        return this.cutlineText;
    }

    public void setCutlineText(String cutlineText) {
        this.cutlineText = cutlineText;
    }

    @BeanTagAttribute
    public Message getCutlineMessage() {
        return this.cutlineMessage;
    }

    public void setCutlineMessage(Message cutlineMessage) {
        this.cutlineMessage = cutlineMessage;
    }

    @BeanTagAttribute
    public boolean isCaptionHeaderPlacementAboveImage() {
        return this.captionHeaderPlacementAboveImage;
    }

    public void setCaptionHeaderPlacementAboveImage(boolean captionHeaderPlacementAboveImage) {
        this.captionHeaderPlacementAboveImage = captionHeaderPlacementAboveImage;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getSource() == null && !Validator.checkExpressions(this, "source")) {
            currentValues = new String[]{"source =" + this.getSource()};
            tracer.createError("Source must be set", currentValues);
        }
        if (this.getAltText().compareTo("") == 0 && Validator.checkExpressions(this, "altText")) {
            currentValues = new String[]{"altText =" + this.getAltText()};
            tracer.createWarning("Alt text should be set, violates accessibility standards if not set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

