/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.util.ReflectionUtils;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.springframework.util.ClassUtils;

class LegacyDetector {
    private static final Logger LOG = LogManager.getLogger(LegacyDetector.class);
    private static final String OJB_METADATA_MANAGER_CLASS = "org.apache.ojb.broker.metadata.MetadataManager";
    private final MetadataRepository metadataRepository;
    private final DataDictionaryService dataDictionaryService;
    private final Map<Class<?>, Boolean> legacyLoadedCache = new ConcurrentHashMap();
    private static final ThreadLocal<Integer> LEGACY_CONTEXT = new ThreadLocal();

    LegacyDetector(MetadataRepository metadataRepository, DataDictionaryService dataDictionaryService) {
        Validate.notNull((Object)metadataRepository, (String)"The metadataRepository must not be null");
        Validate.notNull((Object)dataDictionaryService, (String)"The dataDictionaryService must not be null");
        this.metadataRepository = metadataRepository;
        this.dataDictionaryService = dataDictionaryService;
    }

    public boolean isInLegacyContext() {
        return LEGACY_CONTEXT.get() != null;
    }

    public void beginLegacyContext() {
        Integer count = LEGACY_CONTEXT.get();
        if (count == null) {
            if (!this.isLegacyDataFrameworkEnabled()) {
                throw new IllegalStateException("Attempting to enter legacy data context without the legacy data framework enabled. To enable, please load the KNS module or set rice.krad.enableLegacyDataFramework config property to 'true'.");
            }
            LEGACY_CONTEXT.set(0);
        } else {
            LEGACY_CONTEXT.set(count + 1);
        }
    }

    public void endLegacyContext() {
        Integer count = LEGACY_CONTEXT.get();
        if (count == null) {
            throw new IllegalStateException("Attempting to end a non-existent legacy context!");
        }
        if (count == 0) {
            LEGACY_CONTEXT.set(null);
        } else {
            LEGACY_CONTEXT.set(count - 1);
        }
    }

    public boolean isLegacyManaged(Class<?> type) {
        BusinessObjectEntry businessObjectEntry = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(type.getName());
        return businessObjectEntry != null || this.isOjbLoadedClass(type);
    }

    public boolean isKradDataManaged(Class<?> type) {
        return this.metadataRepository.contains(type);
    }

    public boolean isKnsEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.kns.enabled", false);
    }

    public boolean isLegacyDataFrameworkEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.enableLegacyDataFramework", this.isKnsEnabled());
    }

    public boolean isOjbLoadedClass(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            return false;
        }
        String dataObjectClassName = dataObjectClass.getName().replaceAll("\\.ByteBuddyOJBProxy", "");
        try {
            dataObjectClass = Class.forName(dataObjectClassName);
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("Unable to resolve converted class name: " + dataObjectClassName + " from original: " + String.valueOf(dataObjectClass) + " -- Using as is", (Throwable)ex);
        }
        Boolean isLegacyLoaded = this.legacyLoadedCache.get(dataObjectClass);
        if (isLegacyLoaded == null) {
            if (dataObjectClass.getPackage() != null && StringUtils.startsWith((String)dataObjectClass.getPackage().getName(), (String)"org.apache.ojb.")) {
                isLegacyLoaded = Boolean.TRUE;
            } else {
                try {
                    Class<?> metadataManager = Class.forName(OJB_METADATA_MANAGER_CLASS, false, ClassUtils.getDefaultClassLoader());
                    Object metadataManagerInstance = ReflectionUtils.invokeViaReflection(metadataManager, null, (String)"getInstance", null, (Object[])new Object[0]);
                    Validate.notNull((Object)metadataManagerInstance, (String)"unable to obtain org.apache.ojb.broker.metadata.MetadataManager instance");
                    Object descriptorRepository = ReflectionUtils.invokeViaReflection((Object)metadataManagerInstance, (String)"getGlobalRepository", null, (Object[])new Object[0]);
                    Validate.notNull((Object)descriptorRepository, (String)"unable to invoke legacy metadata provider (org.apache.ojb.broker.metadata.MetadataManager)");
                    isLegacyLoaded = (Boolean)ReflectionUtils.invokeViaReflection((Object)descriptorRepository, (String)"hasDescriptorFor", (Class[])new Class[]{Class.class}, (Object[])new Object[]{dataObjectClass});
                }
                catch (ClassNotFoundException e) {
                    isLegacyLoaded = Boolean.FALSE;
                }
            }
            this.legacyLoadedCache.put(dataObjectClass, isLegacyLoaded);
        }
        return isLegacyLoaded;
    }

    public boolean useLegacy(Class<?> dataObjectClass) {
        boolean ojbLoadedClass = this.isOjbLoadedClass(dataObjectClass);
        if (this.isInLegacyContext() && ojbLoadedClass) {
            return true;
        }
        return this.isLegacyDataFrameworkEnabled() && (ojbLoadedClass || this.isTransientBO(dataObjectClass)) && !this.isKradDataManaged(dataObjectClass);
    }

    private boolean isTransientBO(Class<?> dataObjectClass) {
        boolean isTransientBo = false;
        ArrayList transientClassNames = Lists.newArrayList((Object[])new String[]{"org.kuali.rice.krad.bo.TransientBusinessObjectBase"});
        try {
            Object dataObject = dataObjectClass.newInstance();
            for (String transientClassName : transientClassNames) {
                Class<?> transientClass = Class.forName(transientClassName);
                if (!transientClass.isInstance(dataObject)) continue;
                isTransientBo = true;
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
        return isTransientBo;
    }

    public boolean useLegacyForObject(Object dataObject) {
        Validate.notNull((Object)dataObject, (String)"Data Object must not be null");
        if (dataObject instanceof Class) {
            throw new IllegalArgumentException("Passed a Class object to useLegacyForObject, call useLegacy instead!");
        }
        return this.useLegacy(dataObject.getClass());
    }
}

