/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate;

import gov.grants.apply.system.globalV10.HashValueDocument;
import gov.grants.apply.system.header20V20.Header20Document;
import gov.grants.apply.system.headerV10.GrantSubmissionHeaderDocument;
import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.FormApplicationService;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="formApplicationService")
public class FormApplicationServiceImpl
implements FormApplicationService {
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    private S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;
    @Autowired
    @Qualifier(value="s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService;

    @Override
    public String getGrantApplicationDocument(ProposalDevelopmentDocumentContract pdDoc, GrantApplicationDocument.GrantApplication.Forms forms) throws S2SException {
        GrantApplicationDocument grantApplicationDocument = (GrantApplicationDocument)GrantApplicationDocument.Factory.newInstance();
        GrantApplicationDocument.GrantApplication grantApplication = (GrantApplicationDocument.GrantApplication)GrantApplicationDocument.GrantApplication.Factory.newInstance();
        grantApplication.setForms(forms);
        S2sOpportunityContract s2sOpportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (StringUtils.isNotBlank((CharSequence)s2sOpportunity.getPackageId())) {
            grantApplication.setHeader20(this.createHeaderVersion2(pdDoc));
        } else {
            grantApplication.setGrantSubmissionHeader(this.createHeaderVersion1(pdDoc, this.getGrantApplicationHashService().computeGrantFormsHash(this.getXmlFromDocument(grantApplication))));
        }
        grantApplicationDocument.setGrantApplication(grantApplication);
        try (XmlCursor cursor = grantApplicationDocument.newCursor();){
            cursor.toStartDoc();
            if (cursor.toFirstChild()) {
                String defaultNameSpace = cursor.getName().getNamespaceURI();
                String schemaLocation = defaultNameSpace + " " + s2sOpportunity.getSchemaUrl();
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), schemaLocation);
            }
        }
        return this.getXmlFromDocument(grantApplicationDocument);
    }

    @Deprecated
    private GrantSubmissionHeaderDocument.GrantSubmissionHeader createHeaderVersion1(ProposalDevelopmentDocumentContract pdDoc, String hashVal) {
        Calendar openingDate;
        GrantSubmissionHeaderDocument.GrantSubmissionHeader grantSubmissionHeader = (GrantSubmissionHeaderDocument.GrantSubmissionHeader)GrantSubmissionHeaderDocument.GrantSubmissionHeader.Factory.newInstance();
        grantSubmissionHeader.setOpportunityTitle(pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle());
        grantSubmissionHeader.setAgencyName(pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
        pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sOpportunityCfdas().stream().findFirst().ifPresent(cfda -> {
            grantSubmissionHeader.setCFDANumber(cfda.getCfdaNumber());
            String activityTitle = cfda.getCfdaDescription();
            if (StringUtils.isNotEmpty((CharSequence)activityTitle)) {
                grantSubmissionHeader.setActivityTitle(activityTitle);
            }
        });
        S2sOpportunityContract s2sOpportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity.getCompetitionId() != null) {
            grantSubmissionHeader.setCompetitionID(s2sOpportunity.getCompetitionId());
        }
        grantSubmissionHeader.setOpportunityID(s2sOpportunity.getOpportunityId());
        grantSubmissionHeader.setSchemaVersion(FormVersion.v1_0.getVersion());
        grantSubmissionHeader.setSubmissionTitle(s2sOpportunity.getProposalNumber());
        Calendar closingDate = s2sOpportunity.getClosingDate();
        if (closingDate != null) {
            grantSubmissionHeader.setClosingDate(closingDate);
        }
        if ((openingDate = s2sOpportunity.getOpeningDate()) != null) {
            grantSubmissionHeader.setOpeningDate(openingDate);
        }
        HashValueDocument.HashValue hashValue = (HashValueDocument.HashValue)HashValueDocument.HashValue.Factory.newInstance();
        hashValue.setHashAlgorithm("SHA-1");
        hashValue.setStringValue(hashVal);
        grantSubmissionHeader.setHashValue(hashValue);
        return grantSubmissionHeader;
    }

    private Header20Document.Header20 createHeaderVersion2(ProposalDevelopmentDocumentContract pdDoc) {
        Header20Document.Header20 header20 = (Header20Document.Header20)Header20Document.Header20.Factory.newInstance();
        header20.setApplicationFilingName(pdDoc.getDevelopmentProposal().getTitle());
        header20.setPackageID(pdDoc.getDevelopmentProposal().getS2sOpportunity().getPackageId());
        header20.setSchemaVersion(FormVersion.v2_0.getVersion());
        return header20;
    }

    private String getXmlFromDocument(XmlObject grantApplicationDocument) {
        String applicationXmlText = grantApplicationDocument.xmlText(this.getS2SFormGeneratorRetrievalService().getXmlOptionsPrefixes());
        return this.getS2SDateTimeService().removeTimezoneFactor(applicationXmlText);
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorRetrievalService() {
        return this.s2SFormGeneratorRetrievalService;
    }

    public void setS2SFormGeneratorRetrievalService(S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService) {
        this.s2SFormGeneratorRetrievalService = s2SFormGeneratorRetrievalService;
    }
}

