/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget1013V13.RRBudget1013Document;
import gov.grants.apply.forms.rrSubawardBudget101013V13.RRSubawardBudget101013Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRSubAwardBudget10_10V1_3Generator")
public class RRSubAwardBudget10_10V1_3Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget101013Document>
implements S2SFormGeneratorPdfFillable<RRSubawardBudget101013Document> {
    protected static final String RR_BUDGET_10_1_3_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget10_1_3-V1.3";
    protected static final String RR_BUDGET_10_1_3_LOCAL_NAME = "RR_Budget10_1_3";
    @Value(value="http://apply.grants.gov/forms/RR_SubawardBudget10_10_1_3-V1.3")
    private String namespace;
    @Value(value="RR_SubawardBudget10_10_1_3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget10_10-V1.3.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SubawardBudget10_10_1_3-V1.3.pdf")
    private Resource pdfForm;
    @Value(value="178")
    private int sortIndex;

    private RRSubawardBudget101013Document getRRSubawardBudgetDocument() {
        RRSubawardBudget101013Document rrSubawardBudgetDocument = (RRSubawardBudget101013Document)RRSubawardBudget101013Document.Factory.newInstance();
        RRSubawardBudget101013Document.RRSubawardBudget101013 rrSubawardBudget = (RRSubawardBudget101013Document.RRSubawardBudget101013)RRSubawardBudget101013Document.RRSubawardBudget101013.Factory.newInstance();
        RRSubawardBudget101013Document.RRSubawardBudget101013.BudgetAttachments budgetAttachments = (RRSubawardBudget101013Document.RRSubawardBudget101013.BudgetAttachments)RRSubawardBudget101013Document.RRSubawardBudget101013.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, RR_BUDGET_10_1_3_NAMESPACE_URI, false);
        RRBudget1013Document.RRBudget1013[] budgetList = new RRBudget1013Document.RRBudget1013[budgetSubAwardsList.size()];
        rrSubawardBudget.setFormVersion(FormVersion.v1_3.getVersion());
        int attIndex = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRBudget1013Document.RRBudget1013 rrBudget = this.getRRBudget(budgetSubAwards).getRRBudget1013();
            switch (attIndex) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList[0] = rrBudget;
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList[1] = rrBudget;
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList[2] = rrBudget;
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList[3] = rrBudget;
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList[4] = rrBudget;
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList[5] = rrBudget;
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList[6] = rrBudget;
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList[7] = rrBudget;
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList[8] = rrBudget;
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList[9] = rrBudget;
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attIndex;
        }
        budgetAttachments.setRRBudget1013Array(budgetList);
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget101013(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget1013Document getRRBudget(BudgetSubAwardsContract budgetSubAwards) {
        Document subAwdFormsDoc;
        RRBudget1013Document rrBudget = (RRBudget1013Document)RRBudget1013Document.Factory.newInstance();
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        try {
            subAwdFormsDoc = this.stringToDom(subAwdXML);
        }
        catch (S2SException e1) {
            return rrBudget;
        }
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET_10_1_3_NAMESPACE_URI, RR_BUDGET_10_1_3_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        try {
            byte[] subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            ByteArrayInputStream bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            rrBudget = (RRBudget1013Document)RRBudget1013Document.Factory.parse((InputStream)bgtIS);
        }
        catch (IOException | XmlException | S2SException e) {
            return rrBudget;
        }
        return rrBudget;
    }

    @Override
    public RRSubawardBudget101013Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRSubawardBudget101013Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRSubawardBudget101013Document> factory() {
        return RRSubawardBudget101013Document.Factory;
    }
}

