/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf424Mandatory12V12.SF424Mandatory12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.OrganizationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.CommonSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424Mandatory1_2_V1_2Generator")
public class SF424Mandatory1_2_V1_2Generator
extends CommonSF424BaseGenerator<SF424Mandatory12Document>
implements S2SFormGeneratorPdfFillable<SF424Mandatory12Document> {
    private static final String CONTACT_TYPE_I = "I";
    private static final int PRIMARY_TITLE_MAX_LENGTH = 45;
    private static final String YNQ_STATE_NOT_SELECTED = "Not Selected";
    private static final String YNQ_STATE_NOT_COVERED = "Not Covered";
    private static final String PROPOSAL_YNQ_FEDERAL_DEBTS = "I7";
    private static final String ORGANIZATION_YNQ_ANSWER_YES = "Y";
    private static final String DEBT_EXPLANATION_ATTACHMENT = "136";
    @Value(value="http://apply.grants.gov/forms/SF424_Mandatory_1_2-V1.2")
    private String namespace;
    @Value(value="SF424Mandatory1_2_V1_2")
    private String formName;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SF424_Mandatory_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    protected S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;

    private SF424Mandatory12Document getSF424Mandatory12Document() {
        SF424Mandatory12Document sF424Mandatory12Document = (SF424Mandatory12Document)SF424Mandatory12Document.Factory.newInstance();
        sF424Mandatory12Document.setSF424Mandatory12(this.getSF424Mandatory12());
        return sF424Mandatory12Document;
    }

    private SF424Mandatory12Document.SF424Mandatory12 getSF424Mandatory12() {
        SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12 = (SF424Mandatory12Document.SF424Mandatory12)SF424Mandatory12Document.SF424Mandatory12.Factory.newInstance();
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        this.setTypeOfSubmission(sF424Mandatory12, answerHeaders);
        this.setFrequency(sF424Mandatory12, answerHeaders);
        this.setConsolidatedRequest(sF424Mandatory12, answerHeaders);
        this.setVersion(sF424Mandatory12);
        this.setRecievedDate(sF424Mandatory12);
        this.setApplicantId(sF424Mandatory12);
        this.setFederalAwardId(sF424Mandatory12);
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        OrganizationContract applicantOrganization = proposalSite.getOrganization();
        this.setApplicationInformation(sF424Mandatory12, proposalSite);
        this.setTypeOfApplicant(sF424Mandatory12, applicantOrganization);
        this.setNameOfFedAgency(sF424Mandatory12);
        this.setCfda(sF424Mandatory12);
        this.setTitle(sF424Mandatory12);
        this.setAreaAffected(sF424Mandatory12, answerHeaders);
        this.setCongressionalDistricts(sF424Mandatory12, applicantOrganization);
        this.setFundingPeriods(sF424Mandatory12);
        this.setEstimatedFunding(sF424Mandatory12);
        this.setSubmissionReview(sF424Mandatory12, answerHeaders);
        this.setDelinquencyInfo(sF424Mandatory12, applicantOrganization);
        this.setSigningInfo(sF424Mandatory12);
        sF424Mandatory12.setFormVersion(FormVersion.v1_2.getVersion());
        return sF424Mandatory12;
    }

    private void setSigningInfo(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        sF424Mandatory12.setApplicationCertification(YesNoDataType.Y_YES);
        DepartmentalPersonDto aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        sF424Mandatory12.setAuthorizedRepresentativeName(this.globLibV20Generator.getHumanNameDataType(aorInfo));
        if (StringUtils.isNotBlank((CharSequence)aorInfo.getPrimaryTitle())) {
            sF424Mandatory12.setAuthorizedRepresentativeTitle(StringUtils.substring((String)aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        if (StringUtils.isNotBlank((CharSequence)aorInfo.getOfficePhone())) {
            sF424Mandatory12.setAuthorizedRepresentativePhoneNumber(aorInfo.getOfficePhone());
        }
        if (StringUtils.isNotBlank((CharSequence)aorInfo.getFaxNumber())) {
            sF424Mandatory12.setAuthorizedRepresentativeFax(aorInfo.getFaxNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)aorInfo.getEmailAddress())) {
            sF424Mandatory12.setAuthorizedRepresentativeEmail(aorInfo.getEmailAddress());
        }
        sF424Mandatory12.setAuthorizedRepresentativeSignature(aorInfo.getFullName());
        sF424Mandatory12.setAuthorizedRepresentativeSignatureDate(aorInfo.getSubmittedDate());
    }

    private void setDelinquencyInfo(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, OrganizationContract applicantOrganization) {
        Object[] attachedFileDataTypes;
        if (applicantOrganization != null) {
            Optional<YesNoDataType.Enum> yesNo = applicantOrganization.getOrganizationYnqs().stream().filter(orgYnq -> PROPOSAL_YNQ_FEDERAL_DEBTS.equals(orgYnq.getQuestionId())).map(OrganizationYnqContract::getAnswer).filter(StringUtils::isNotBlank).map(answer -> ORGANIZATION_YNQ_ANSWER_YES.equals(answer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO).findFirst();
            sF424Mandatory12.setDelinquentOnFederalDebt(yesNo.orElse(YesNoDataType.N_NO));
        }
        if (ArrayUtils.isNotEmpty((Object[])(attachedFileDataTypes = this.getAttachedFileDataTypes(DEBT_EXPLANATION_ATTACHMENT)))) {
            sF424Mandatory12.setDelinquentFederalDebtExplanation("See attachment for explanation");
            AttachmentGroupMin0Max100DataType attachments = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
            attachments.setAttachedFileArray((AttachedFileDataType[])attachedFileDataTypes);
            sF424Mandatory12.setAttachments(attachments);
        }
    }

    private void setSubmissionReview(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, List<? extends AnswerHeaderContract> answerHeaders) {
        String dateAvail = this.getAnswer(129, answerHeaders);
        if (ORGANIZATION_YNQ_ANSWER_YES.equals(dateAvail)) {
            sF424Mandatory12.setSubmissionUnderReview(SF424Mandatory12Document.SF424Mandatory12.SubmissionUnderReview.STATE_REVIEW_AVAILABLE);
            String reviewDate = this.getAnswer(130, answerHeaders);
            if (StringUtils.isNotBlank((CharSequence)reviewDate)) {
                sF424Mandatory12.setStateReviewAvailableDate(this.s2SDateTimeService.convertDateStringToCalendar(reviewDate));
            }
        } else if ("N".equals(dateAvail)) {
            String reviewData = this.getAnswer(131, answerHeaders);
            if (YNQ_STATE_NOT_SELECTED.equals(reviewData)) {
                sF424Mandatory12.setSubmissionUnderReview(SF424Mandatory12Document.SF424Mandatory12.SubmissionUnderReview.STATE_REVIEW_NOT_SELECTED);
            } else if (YNQ_STATE_NOT_COVERED.equals(reviewData)) {
                sF424Mandatory12.setSubmissionUnderReview(SF424Mandatory12Document.SF424Mandatory12.SubmissionUnderReview.STATE_REVIEW_NOT_NEEDED);
            }
        }
    }

    private void setEstimatedFunding(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            S2SBudgetDto budgetSummary = this.getS2sBudgetInfoService().getBudgetInfo(this.pdDoc);
            sF424Mandatory12.setEstimatedFundingFederal(budgetSummary.getCumTotalCosts().bigDecimalValue());
            sF424Mandatory12.setEstimatedFundingMatch(budgetSummary.getCumTotalCostSharing().bigDecimalValue());
        } else {
            sF424Mandatory12.setEstimatedFundingFederal(BigDecimal.ZERO);
            sF424Mandatory12.setEstimatedFundingMatch(BigDecimal.ZERO);
        }
    }

    private void setFundingPeriods(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        sF424Mandatory12.setFundingPeriodStartDate(DateUtils.toCalendar((Date)this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        sF424Mandatory12.setFundingPeriodEndDate(DateUtils.toCalendar((Date)this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
    }

    private void setCongressionalDistricts(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, OrganizationContract applicantOrganization) {
        ProposalSiteContract perfOrganization;
        if (applicantOrganization != null) {
            String congressionalDistrict = StringUtils.isBlank((CharSequence)applicantOrganization.getCongressionalDistrict()) ? "Unknown" : StringUtils.substring((String)applicantOrganization.getCongressionalDistrict(), (int)0, (int)6);
            sF424Mandatory12.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        if ((perfOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization()) != null) {
            String congDistrictProject = StringUtils.isBlank((CharSequence)perfOrganization.getFirstCongressionalDistrictName()) ? "Unknown" : StringUtils.substring((String)perfOrganization.getFirstCongressionalDistrictName(), (int)0, (int)6);
            sF424Mandatory12.setCongressionalDistrictProject(congDistrictProject);
        }
    }

    private void setAreaAffected(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, List<? extends AnswerHeaderContract> answerHeaders) {
        String affectedAreasOfFundingDesc;
        String affectedAreasOfFunding = this.getAnswer(-10140, answerHeaders);
        if (StringUtils.isNotBlank((CharSequence)affectedAreasOfFunding) && ORGANIZATION_YNQ_ANSWER_YES.equals(affectedAreasOfFunding) && StringUtils.isNotBlank((CharSequence)(affectedAreasOfFundingDesc = this.getAnswer(-10141, answerHeaders)))) {
            sF424Mandatory12.setAreasAffectedByFunding(affectedAreasOfFundingDesc);
        }
    }

    private void setTitle(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        if (StringUtils.isNotBlank((CharSequence)this.pdDoc.getDevelopmentProposal().getTitle())) {
            sF424Mandatory12.setDescriptiveProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        }
    }

    private void setCfda(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        String cfdaNumber = this.getFirstCfdaNumber();
        if (cfdaNumber != null) {
            sF424Mandatory12.setCFDANumber(cfdaNumber);
        }
    }

    private void setNameOfFedAgency(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        sF424Mandatory12.setAgencyName(this.getFederalAgencyName());
    }

    private void setTypeOfApplicant(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, OrganizationContract applicantOrganization) {
        if (applicantOrganization != null) {
            List organizationTypes = applicantOrganization.getOrganizationTypes();
            List organizationTypeCodes = organizationTypes.stream().map(organizationType -> organizationType.getOrganizationTypeList().getCode()).collect(Collectors.toList());
            Iterator iterator = organizationTypeCodes.iterator();
            while (iterator.hasNext()) {
                int organizationTypeCode = (Integer)iterator.next();
                if (1 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT);
                    break;
                }
                if (2 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.A_STATE_GOVERNMENT);
                    break;
                }
                if (3 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.X_OTHER_SPECIFY);
                    sF424Mandatory12.setOtherTypeApplicant("Federal Government");
                    break;
                }
                if (4 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION);
                    break;
                }
                if (5 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION);
                    break;
                }
                if (6 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS);
                    break;
                }
                if (7 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.X_OTHER_SPECIFY);
                    break;
                }
                if (8 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED);
                    break;
                }
                if (9 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.P_INDIVIDUAL);
                    break;
                }
                if (10 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION);
                    break;
                }
                if (11 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.R_SMALL_BUSINESS);
                    break;
                }
                if (14 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.X_OTHER_SPECIFY);
                    sF424Mandatory12.setOtherTypeApplicant("Socially and Economically Disadvantaged");
                    break;
                }
                if (15 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.X_OTHER_SPECIFY);
                    sF424Mandatory12.setOtherTypeApplicant("Women owned");
                    break;
                }
                if (21 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION);
                    break;
                }
                if (22 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT);
                    break;
                }
                if (23 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT);
                    break;
                }
                if (24 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT);
                    break;
                }
                if (25 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY);
                    break;
                }
                if (26 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED);
                    break;
                }
                if (100 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION);
                    break;
                }
                if (101 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION);
                    break;
                }
                if (102 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION);
                    break;
                }
                if (103 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION);
                    break;
                }
                if (104 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US);
                    break;
                }
                if (105 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US);
                    break;
                }
                if (106 == organizationTypeCode) {
                    sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS);
                    break;
                }
                if (107 != organizationTypeCode) continue;
                sF424Mandatory12.setApplicantType(ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY);
                break;
            }
        }
    }

    private void setApplicationInformation(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, ProposalSiteContract proposalSite) {
        RolodexContract applicantOrganizationRolodex;
        OrganizationContract applicantOrganization = proposalSite.getOrganization();
        OrganizationDataType organization = (OrganizationDataType)OrganizationDataType.Factory.newInstance();
        if (applicantOrganization != null) {
            if (StringUtils.isNotBlank((CharSequence)proposalSite.getLocationName())) {
                organization.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            }
            if (StringUtils.isNotBlank((CharSequence)applicantOrganization.getFederalEmployerId())) {
                organization.setEIN(applicantOrganization.getFederalEmployerId());
            }
            if (StringUtils.isNotBlank((CharSequence)applicantOrganization.getDunsNumber())) {
                organization.setDUNSID(applicantOrganization.getDunsNumber());
            }
        }
        if ((applicantOrganizationRolodex = proposalSite.getRolodex()) != null) {
            organization.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
        }
        sF424Mandatory12.setOrganization(organization);
        if (CONTACT_TYPE_I.equals(this.s2SConfigurationService.getValueAsString("PROPOSAL_CONTACT_TYPE"))) {
            if (applicantOrganizationRolodex != null) {
                sF424Mandatory12.setContactName(this.globLibV20Generator.getHumanNameDataType(applicantOrganizationRolodex));
                if (StringUtils.isNotBlank((CharSequence)applicantOrganizationRolodex.getPhoneNumber())) {
                    sF424Mandatory12.setContactPhoneNumber(applicantOrganizationRolodex.getPhoneNumber());
                }
                if (StringUtils.isNotBlank((CharSequence)applicantOrganizationRolodex.getFaxNumber())) {
                    sF424Mandatory12.setContactFax(applicantOrganizationRolodex.getFaxNumber());
                }
                if (StringUtils.isNotBlank((CharSequence)applicantOrganizationRolodex.getEmailAddress())) {
                    sF424Mandatory12.setContactEmail(applicantOrganizationRolodex.getEmailAddress());
                }
            }
        } else {
            DepartmentalPersonDto depPerson = this.departmentalPersonService.getContactPerson(this.pdDoc);
            if (depPerson != null) {
                sF424Mandatory12.setContactName(this.globLibV20Generator.getHumanNameDataType(depPerson));
                if (StringUtils.isNotEmpty((CharSequence)depPerson.getPrimaryTitle())) {
                    sF424Mandatory12.setContactTitle(StringUtils.substring((String)depPerson.getPrimaryTitle(), (int)0, (int)45));
                }
                if (StringUtils.isNotBlank((CharSequence)depPerson.getOfficePhone())) {
                    sF424Mandatory12.setContactPhoneNumber(depPerson.getOfficePhone());
                }
                if (StringUtils.isNotEmpty((CharSequence)depPerson.getFaxNumber())) {
                    sF424Mandatory12.setContactFax(depPerson.getFaxNumber());
                }
                if (StringUtils.isNotEmpty((CharSequence)depPerson.getEmailAddress())) {
                    sF424Mandatory12.setContactEmail(depPerson.getEmailAddress());
                }
            }
        }
    }

    private void setFederalAwardId(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        if (StringUtils.isNotBlank((CharSequence)this.pdDoc.getDevelopmentProposal().getSponsorProposalNumber())) {
            sF424Mandatory12.setFederalAwardID(StringUtils.left((String)this.pdDoc.getDevelopmentProposal().getSponsorProposalNumber().trim(), (int)25));
        }
    }

    private void setApplicantId(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        sF424Mandatory12.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
    }

    private void setRecievedDate(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        sF424Mandatory12.setReceivedDate(DateUtils.toCalendar((Date)this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
    }

    private void setVersion(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12) {
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
            sF424Mandatory12.setVersion(SF424Mandatory12Document.SF424Mandatory12.Version.INITIAL);
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
            sF424Mandatory12.setVersion(SF424Mandatory12Document.SF424Mandatory12.Version.RESUBMISSION);
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            sF424Mandatory12.setVersion(SF424Mandatory12Document.SF424Mandatory12.Version.REVISION);
        }
    }

    private void setConsolidatedRequest(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, List<? extends AnswerHeaderContract> answerHeaders) {
        String consolidated = this.getAnswer(-10138, answerHeaders);
        if (StringUtils.isNotBlank((CharSequence)consolidated)) {
            String consolidatedExplanation;
            YesNoDataType.Enum consolidatedEnum = ORGANIZATION_YNQ_ANSWER_YES.equals(consolidated) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            sF424Mandatory12.setConsolidatedRequest(consolidatedEnum);
            if (((Object)((Object)consolidatedEnum)).equals((Object)YesNoDataType.Y_YES) && StringUtils.isNotBlank((CharSequence)(consolidatedExplanation = this.getAnswer(-10139, answerHeaders)))) {
                sF424Mandatory12.setConsolidatedRequestExplanation(consolidatedExplanation);
            }
        }
    }

    private void setFrequency(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, List<? extends AnswerHeaderContract> answerHeaders) {
        String frequency = this.getAnswer(-10136, answerHeaders);
        if (StringUtils.isNotBlank((CharSequence)frequency)) {
            String frequencyOtherDesc;
            SF424Mandatory12Document.SF424Mandatory12.Frequency.Enum frequencyEnum = SF424Mandatory12Document.SF424Mandatory12.Frequency.Enum.forString(frequency);
            sF424Mandatory12.setFrequency(frequencyEnum);
            if (((Object)((Object)frequencyEnum)).equals((Object)SF424Mandatory12Document.SF424Mandatory12.Frequency.OTHER) && StringUtils.isNotBlank((CharSequence)(frequencyOtherDesc = this.getAnswer(-10137, answerHeaders)))) {
                sF424Mandatory12.setFrequencyOtherDescription(frequencyOtherDesc);
            }
        }
    }

    private void setTypeOfSubmission(SF424Mandatory12Document.SF424Mandatory12 sF424Mandatory12, List<? extends AnswerHeaderContract> answerHeaders) {
        String typeOfSubmission = this.getAnswer(-10134, answerHeaders);
        if (StringUtils.isNotBlank((CharSequence)typeOfSubmission)) {
            String typeOfSubmissionOtherDesc;
            SF424Mandatory12Document.SF424Mandatory12.TypeOfSubmission.Enum typeOfSubmissionEnum = SF424Mandatory12Document.SF424Mandatory12.TypeOfSubmission.Enum.forString(typeOfSubmission);
            sF424Mandatory12.setTypeOfSubmission(typeOfSubmissionEnum);
            if (((Object)((Object)typeOfSubmissionEnum)).equals((Object)SF424Mandatory12Document.SF424Mandatory12.TypeOfSubmission.OTHER) && StringUtils.isNotBlank((CharSequence)(typeOfSubmissionOtherDesc = this.getAnswer(-10135, answerHeaders)))) {
                sF424Mandatory12.setTypeOfSubmissionOtherDescription(typeOfSubmissionOtherDesc);
            }
        }
    }

    @Override
    public SF424Mandatory12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getSF424Mandatory12Document();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return this.s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(SF424Mandatory12Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType congressionalDistricts = form.getSF424Mandatory12().getAdditionalCongressionalDistricts();
            if (congressionalDistricts != null && a.getContentId().equals(congressionalDistricts.getFileLocation().getHref())) {
                return CollectionUtils.entry("SF424_Mandatory_1_2_P2.optionalFile0", a);
            }
            AttachmentGroupMin0Max100DataType supportingDocuments = form.getSF424Mandatory12().getAttachments();
            if (supportingDocuments != null && supportingDocuments.getAttachedFileList() != null) {
                List<AttachedFileDataType> atts = supportingDocuments.getAttachedFileList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("SF424_Mandatory_1_2_P3.optionalFile" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<SF424Mandatory12Document> factory() {
        return SF424Mandatory12Document.Factory;
    }

    @Override
    public boolean supportsXslTransform() {
        return false;
    }
}

