/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.ehcache.CachePersistenceException;
import org.ehcache.core.spi.store.TransientStateHolder;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.persistence.FileUtils;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;
import org.terracotta.utilities.classloading.FilteredObjectInputStream;

class FileBasedStateRepository
implements StateRepository,
Closeable {
    private static final String HOLDER_FILE_PREFIX = "holder-";
    private static final String HOLDER_FILE_SUFFIX = ".bin";
    private final File dataDirectory;
    private final ConcurrentMap<String, Tuple> knownHolders;
    private final AtomicInteger nextIndex = new AtomicInteger();

    FileBasedStateRepository(File directory) throws CachePersistenceException {
        if (directory == null) {
            throw new NullPointerException("directory must be non null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        this.dataDirectory = directory;
        this.knownHolders = new ConcurrentHashMap<String, Tuple>();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void loadMaps(Predicate<Class<?>> isClassPermitted, ClassLoader classLoader) throws CachePersistenceException {
        for (File file : this.dataDirectory.listFiles((dir, name) -> name.endsWith(HOLDER_FILE_SUFFIX))) {
            try (FileInputStream fis = new FileInputStream(file);
                 FilteredObjectInputStream oin = new FilteredObjectInputStream((InputStream)fis, isClassPermitted, classLoader);){
                String name2 = (String)oin.readObject();
                Tuple tuple = (Tuple)oin.readObject();
                if (this.nextIndex.get() <= tuple.index) {
                    this.nextIndex.set(tuple.index + 1);
                }
                this.knownHolders.put(name2, tuple);
            }
            catch (Exception e) {
                this.knownHolders.clear();
                throw new CachePersistenceException("Failed to load existing StateRepository data", (Throwable)e);
            }
        }
    }

    private void saveMaps() throws IOException {
        for (Map.Entry<String, Tuple> entry : this.knownHolders.entrySet()) {
            File outFile = new File(this.dataDirectory, this.createFileName(entry));
            FileOutputStream fos = new FileOutputStream(outFile);
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                Throwable throwable2 = null;
                try {
                    oos.writeObject(entry.getKey());
                    oos.writeObject(entry.getValue());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (oos == null) continue;
                    if (throwable2 != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    oos.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (fos == null) continue;
                if (throwable != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    private String createFileName(Map.Entry<String, Tuple> entry) {
        return HOLDER_FILE_PREFIX + entry.getValue().index + "-" + FileUtils.safeIdentifier(entry.getKey(), false) + HOLDER_FILE_SUFFIX;
    }

    public <K extends Serializable, V extends Serializable> StateHolder<K, V> getPersistentStateHolder(String name, Class<K> keyClass, Class<V> valueClass, Predicate<Class<?>> isClassPermitted, ClassLoader classLoader) {
        TransientStateHolder holder;
        try {
            this.loadMaps(isClassPermitted, classLoader);
        }
        catch (CachePersistenceException e) {
            throw new RuntimeException("Failed to load existing StateRepository data", e);
        }
        Tuple result = (Tuple)this.knownHolders.get(name);
        if (result == null) {
            holder = new TransientStateHolder();
            result = this.knownHolders.putIfAbsent(name, new Tuple(this.nextIndex.getAndIncrement(), (StateHolder<?, ?>)holder));
            if (result == null) {
                return holder;
            }
        }
        holder = result.holder;
        return holder;
    }

    @Override
    public void close() throws IOException {
        this.saveMaps();
    }

    static class Tuple
    implements Serializable {
        private static final long serialVersionUID = 664492058736170101L;
        final int index;
        final StateHolder<?, ?> holder;

        Tuple(int index, StateHolder<?, ?> holder) {
            this.index = index;
            this.holder = holder;
        }
    }
}

