/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.impex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.CompositeXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.ZipXmlDocCollection;
import org.kuali.rice.core.web.impex.IngesterForm;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public class IngesterAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(IngesterAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<Object> messages;
        block34: {
            this.checkAuthorization(form, "");
            if (this.isModuleLocked(form, "", request)) {
                return mapping.findForward("moduleLocked");
            }
            LOG.debug(request.getMethod());
            if (!"post".equals(request.getMethod().toLowerCase())) {
                LOG.debug("returning to view");
                return mapping.findForward("view");
            }
            IngesterForm iform = (IngesterForm)form;
            messages = new ArrayList<Object>();
            ArrayList<File> tempFiles = new ArrayList<File>();
            try {
                Collection<FormFile> files = iform.getFiles();
                ArrayList<Object> collections = new ArrayList<Object>(files.size());
                LOG.debug(files);
                LOG.debug("" + files.size());
                for (FormFile file1 : files) {
                    if (file1.getFileName() == null || file1.getFileName().length() == 0) continue;
                    if (file1.getFileData() == null) {
                        messages.add("File '" + file1.getFileName() + "' contained no data");
                        continue;
                    }
                    LOG.debug("Processing file: " + file1.getFileName());
                    FileOutputStream fos = null;
                    File temp = null;
                    try {
                        temp = File.createTempFile("ingester", null);
                        tempFiles.add(temp);
                        fos = new FileOutputStream(temp);
                        fos.write(file1.getFileData());
                    }
                    catch (IOException ioe) {
                        messages.add("Error copying file data for '" + file1.getFileName() + "': " + String.valueOf(ioe));
                        continue;
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            LOG.error("Error closing temp file output stream: " + String.valueOf(temp), (Throwable)ioe);
                        }
                        continue;
                    }
                    if (file1.getFileName().toLowerCase().endsWith(".zip")) {
                        try {
                            collections.add(new ZipXmlDocCollection(temp));
                        }
                        catch (IOException ioe) {
                            String message = "Unable to load file: " + String.valueOf(file1);
                            LOG.error(message, (Throwable)ioe);
                            messages.add(message);
                        }
                        continue;
                    }
                    if (file1.getFileName().endsWith(".xml")) {
                        collections.add(new FileXmlDocCollection(temp, file1.getFileName()));
                        continue;
                    }
                    messages.add("Ignoring extraneous file: " + file1.getFileName());
                }
                if (collections.size() == 0) {
                    String message = "No valid files to ingest";
                    LOG.debug(message);
                    messages.add(message);
                    break block34;
                }
                CompositeXmlDocCollection compositeCollection = new CompositeXmlDocCollection(collections);
                int totalProcessed = 0;
                ArrayList<CompositeXmlDocCollection> c = new ArrayList<CompositeXmlDocCollection>(1);
                c.add(compositeCollection);
                try {
                    boolean txFailed;
                    Collection failed = CoreApiServiceLocator.getXmlIngesterService().ingest(c, GlobalVariables.getUserSession().getPrincipalId());
                    boolean bl = txFailed = failed.size() > 0;
                    if (txFailed) {
                        messages.add("Ingestion failed");
                    }
                    for (XmlDocCollection xmlDocCollection : collections) {
                        List docs = xmlDocCollection.getXmlDocs();
                        for (XmlDoc doc1 : docs) {
                            if (doc1.isProcessed()) {
                                if (!txFailed) {
                                    ++totalProcessed;
                                    messages.add("Ingested xml doc: " + doc1.getName() + (String)(doc1.getProcessingMessage() == null ? "" : "\n" + doc1.getProcessingMessage()));
                                    continue;
                                }
                                messages.add("Rolled back doc: " + doc1.getName() + (String)(doc1.getProcessingMessage() == null ? "" : "\n" + doc1.getProcessingMessage()));
                                continue;
                            }
                            messages.add("Failed to ingest xml doc: " + doc1.getName() + (String)(doc1.getProcessingMessage() == null ? "" : "\n" + doc1.getProcessingMessage()));
                        }
                    }
                }
                catch (Exception e) {
                    String message = "Error during ingest";
                    LOG.error(message, (Throwable)e);
                    messages.add(message + ": " + String.valueOf(e) + ":\n" + ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                if (totalProcessed == 0) {
                    String message = "No xml docs ingested";
                    LOG.debug(message);
                    messages.add(message);
                }
            }
            finally {
                if (tempFiles.size() > 0) {
                    for (File tempFile : tempFiles) {
                        if (tempFile.delete()) continue;
                        LOG.warn("Error deleting temp file: " + String.valueOf(tempFile));
                    }
                }
            }
        }
        request.setAttribute("messages", messages);
        return mapping.findForward("view");
    }

    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        HashMap roleQualifier = new HashMap();
        Map permissionDetails = KRADUtils.getNamespaceAndActionClass(((Object)((Object)this)).getClass());
        if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NS", "Use Screen", permissionDetails, roleQualifier)) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }
}

