/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;

@Deprecated
public class BigDecimalFormatter
extends Formatter {
    private static final long serialVersionUID = 4628393689860734306L;
    private static Logger LOG = LogManager.getLogger(BigDecimalFormatter.class);
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("\\-?[0-9,]*\\.?[0-9]*");

    @Override
    protected Object convertToObject(String target) {
        BigDecimal value = null;
        LOG.debug("convertToObject '" + target + "'");
        if (target != null) {
            if (!DECIMAL_PATTERN.matcher(target).matches()) {
                throw new FormatException("parsing", "error.numeric", target);
            }
            DecimalFormat formatter = new DecimalFormat();
            formatter.setParseBigDecimal(true);
            try {
                Number parsedNumber = formatter.parse(target);
                value = new BigDecimal(parsedNumber.toString());
            }
            catch (NumberFormatException e) {
                throw new FormatException("parsing", "error.bigDecimal", target, e);
            }
            catch (ParseException e) {
                throw new FormatException("parsing", "error.bigDecimal", target, e);
            }
        }
        return value;
    }

    @Override
    public Object format(Object obj) {
        LOG.debug("format '" + String.valueOf(obj) + "'");
        if (obj == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat();
        String string = null;
        try {
            BigDecimal number = (BigDecimal)obj;
            if (number != null && number.scale() > 0) {
                formatter.setMinimumFractionDigits(number.scale());
            } else {
                formatter.setMaximumFractionDigits(340);
            }
            string = formatter.format(number);
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("formatting", "error.bigDecimal", obj.toString(), e);
        }
        catch (ClassCastException e) {
            throw new FormatException("formatting", "error.bigDecimal", obj.toString(), e);
        }
        return string;
    }
}

