/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.util.LifecycleAwareList;
import org.kuali.rice.krad.uif.util.LifecycleAwareMap;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

public abstract class LayoutManagerBase
extends UifDictionaryBeanBase
implements LayoutManager {
    private static final long serialVersionUID = -2657663560459456814L;
    private String id;
    private String containerIdSuffix;
    private String viewPath;
    private Map<String, String> phasePathMapping = new HashMap<String, String>();
    private String template;
    private String templateName;
    private String style;
    private List<String> libraryCssClasses;
    private List<String> cssClasses;
    private List<String> additionalCssClasses;
    @ReferenceCopy(newCollectionInstance=true)
    private Map<String, Object> context = Collections.emptyMap();
    private List<PropertyReplacer> propertyReplacers;
    private boolean render = true;
    private String viewStatus = "C";

    public LayoutManagerBase() {
        this.cssClasses = Collections.emptyList();
        this.libraryCssClasses = Collections.emptyList();
        this.additionalCssClasses = Collections.emptyList();
    }

    @Override
    public void checkMutable(boolean legalDuringInitialization) {
        if ("X".equals(this.viewStatus)) {
            ViewLifecycle.reportIllegalState("Cached layout manager " + String.valueOf(this.getClass()) + " " + this.getId() + " is immutable, use copy() to get a mutable instance");
            return;
        }
        if (ViewLifecycle.isActive()) {
            return;
        }
        if ("C".equals(this.viewStatus)) {
            if (!legalDuringInitialization) {
                ViewLifecycle.reportIllegalState("View has not been fully initialized, attempting to change layout manager " + String.valueOf(this.getClass()) + " " + this.getId());
                return;
            }
        } else {
            ViewLifecycle.reportIllegalState("Layout manager " + String.valueOf(this.getClass()) + " " + this.getId() + " has been initialized, but the lifecycle is not active.");
            return;
        }
    }

    @Override
    public boolean isMutable(boolean legalDuringInitialization) {
        return "C".equals(this.viewStatus) && legalDuringInitialization || ViewLifecycle.isActive();
    }

    @Override
    public String getViewStatus() {
        return this.viewStatus;
    }

    @Override
    public void setViewStatus(String status) {
        this.viewStatus = status;
    }

    @Override
    public void notifyCompleted(ViewLifecyclePhase phase) {
    }

    @Override
    public void performInitialization(Object model) {
        this.checkMutable(false);
        if (StringUtils.isBlank((String)this.id)) {
            Container container = (Container)ViewLifecycle.getPhase().getElement();
            this.id = container.getId() + "_layout";
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement component) {
        this.checkMutable(false);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement component) {
        this.checkMutable(false);
        ArrayList<String> finalCssClasses = new ArrayList<String>();
        View view = ViewLifecycle.getView();
        if (this.libraryCssClasses != null && view.isUseLibraryCssClasses()) {
            finalCssClasses.addAll(this.libraryCssClasses);
        }
        if (this.cssClasses != null) {
            finalCssClasses.addAll(this.cssClasses);
        }
        if (this.additionalCssClasses != null) {
            finalCssClasses.addAll(this.additionalCssClasses);
        }
        this.cssClasses = finalCssClasses;
    }

    @Override
    public boolean skipLifecycle() {
        return false;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return Container.class;
    }

    @Override
    @BeanTagAttribute
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.checkMutable(true);
        this.id = id;
    }

    @Override
    public String getContainerIdSuffix() {
        return this.containerIdSuffix;
    }

    @Override
    public void setContainerIdSuffix(String containerIdSuffix) {
        this.containerIdSuffix = containerIdSuffix;
    }

    @Override
    public String getViewPath() {
        return this.viewPath;
    }

    @Override
    public void setViewPath(String viewPath) {
        this.checkMutable(true);
        this.viewPath = viewPath;
    }

    @Override
    public Map<String, String> getPhasePathMapping() {
        return this.phasePathMapping;
    }

    @Override
    public void setPhasePathMapping(Map<String, String> phasePathMapping) {
        this.phasePathMapping = phasePathMapping;
    }

    @Override
    @BeanTagAttribute
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.checkMutable(true);
        this.template = template;
    }

    @Override
    @BeanTagAttribute
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.checkMutable(true);
        this.templateName = templateName;
    }

    @Override
    @BeanTagAttribute
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.checkMutable(true);
        this.style = style;
    }

    @Override
    public List<String> getLibraryCssClasses() {
        if (this.libraryCssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.libraryCssClasses = new LifecycleAwareList<String>(this);
        }
        return this.libraryCssClasses;
    }

    @Override
    public void setLibraryCssClasses(List<String> libraryCssClasses) {
        this.checkMutable(true);
        this.libraryCssClasses = libraryCssClasses == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, libraryCssClasses);
    }

    @Override
    @BeanTagAttribute
    public List<String> getCssClasses() {
        if (this.cssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.cssClasses = new LifecycleAwareList<String>(this);
        }
        return this.cssClasses;
    }

    @Override
    public void setCssClasses(List<String> cssClasses) {
        this.checkMutable(true);
        this.cssClasses = cssClasses == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, cssClasses);
    }

    @Override
    @BeanTagAttribute
    public List<String> getAdditionalCssClasses() {
        if (this.additionalCssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.additionalCssClasses = new LifecycleAwareList<String>(this);
        }
        return this.additionalCssClasses;
    }

    @Override
    public void setAdditionalCssClasses(List<String> additionalCssClasses) {
        this.checkMutable(true);
        this.additionalCssClasses = additionalCssClasses == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, additionalCssClasses);
    }

    public String getStyleClassesAsString() {
        if (this.cssClasses != null) {
            return StringUtils.join(this.cssClasses, (String)" ");
        }
        return "";
    }

    public void setStyleClasses(String styleClasses) {
        this.checkMutable(true);
        String[] classes = StringUtils.split((String)styleClasses);
        this.cssClasses = Arrays.asList(classes);
    }

    @Override
    public void addStyleClass(String styleClass) {
        this.checkMutable(false);
        if (this.cssClasses == null || this.cssClasses.isEmpty()) {
            this.cssClasses = new ArrayList<String>();
        }
        if (!this.cssClasses.contains(styleClass)) {
            this.cssClasses.add(styleClass);
        }
    }

    @Override
    public void appendToStyle(String styleRules) {
        this.checkMutable(false);
        if (this.style == null) {
            this.style = "";
        }
        this.style = this.style + styleRules;
    }

    @Override
    @BeanTagAttribute
    public Map<String, Object> getContext() {
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new LifecycleAwareMap<String, Object>(this);
        }
        return this.context;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.checkMutable(true);
        this.context = context == null ? Collections.emptyMap() : new LifecycleAwareMap<String, Object>(this, context);
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        this.checkMutable(false);
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new LifecycleAwareMap<String, Object>(this);
        }
        this.context.put(objectName, object);
    }

    @Override
    public void pushAllToContext(Map<String, Object> sourceContext) {
        this.checkMutable(false);
        if (sourceContext == null || sourceContext.isEmpty()) {
            return;
        }
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new LifecycleAwareMap<String, Object>(this);
        }
        this.context.putAll(sourceContext);
    }

    @Override
    @BeanTagAttribute
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.checkMutable(true);
        this.propertyReplacers = propertyReplacers;
    }

    @Override
    public LayoutManagerBase clone() throws CloneNotSupportedException {
        LayoutManagerBase copy = (LayoutManagerBase)super.clone();
        copy.viewStatus = "I".equals(this.viewStatus) ? "I" : "C";
        return copy;
    }

    @Override
    public boolean isInitialized() {
        return StringUtils.equals((String)this.viewStatus, (String)"I") || this.isModelApplied();
    }

    @Override
    public boolean isModelApplied() {
        return StringUtils.equals((String)this.viewStatus, (String)"M") || this.isFinal();
    }

    @Override
    public boolean isFinal() {
        return StringUtils.equals((String)this.viewStatus, (String)"F");
    }

    @Override
    public boolean isRender() {
        return this.render;
    }

    @Override
    public void setRender(boolean render) {
        this.render = render;
    }
}

