/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.BreadcrumbItem;
import org.kuali.rice.krad.uif.element.BreadcrumbOptions;
import org.kuali.rice.krad.uif.element.HeadLink;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.MetaTag;
import org.kuali.rice.krad.uif.element.ViewHeader;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.ClientValidationUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleAwareList;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ParentLocation;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewIndex;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.view.ViewSessionPolicy;
import org.kuali.rice.krad.uif.view.ViewTheme;
import org.kuali.rice.krad.uif.widget.BlockUI;
import org.kuali.rice.krad.uif.widget.Breadcrumbs;
import org.kuali.rice.krad.uif.widget.Growls;
import org.kuali.rice.krad.uif.widget.Help;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class View
extends ContainerBase {
    private static final long serialVersionUID = -1220009725554576953L;
    private static final Logger LOG = LogManager.getLogger(ContainerBase.class);
    private String namespaceCode;
    private String viewName;
    private ViewTheme theme;
    private String stateObjectBindingPath;
    private StateMapping stateMapping;
    private boolean unifiedHeader;
    private Group topGroup;
    private Header applicationHeader;
    private Group applicationFooter;
    private Group buildFooter;
    private String applicationTitleText;
    private boolean stickyTopGroup;
    private boolean stickyBreadcrumbs;
    private boolean stickyHeader;
    private boolean stickyApplicationHeader;
    private boolean stickyFooter;
    private boolean stickyApplicationFooter;
    private List<String> contentContainerCssClasses;
    private Breadcrumbs breadcrumbs;
    private BreadcrumbOptions breadcrumbOptions;
    private BreadcrumbItem breadcrumbItem;
    private ParentLocation parentLocation;
    private List<BreadcrumbItem> pathBasedBreadcrumbs;
    private Growls growls;
    private boolean growlMessagingEnabled;
    private BlockUI refreshBlockUI;
    private BlockUI navigationBlockUI;
    private String entryPageId;
    @RequestParameter
    private String currentPageId;
    private Group navigation;
    private Class<?> formClass = UifFormBase.class;
    private String defaultBindingObjectPath;
    private Map<String, Class<?>> objectPathToConcreteClassMapping;
    private List<String> additionalScriptFiles;
    private List<String> additionalCssFiles;
    private List<HeadLink> additionalHeadLinks;
    private List<MetaTag> additionalMetaTags;
    private boolean useLibraryCssClasses;
    private UifConstants.ViewType viewTypeName = UifConstants.ViewType.DEFAULT;
    protected ViewIndex viewIndex;
    private Map<String, String> viewRequestParameters;
    private boolean persistFormToSession = true;
    private ViewSessionPolicy sessionPolicy = new ViewSessionPolicy();
    private int preloadPoolSize;
    private ViewPresentationController presentationController;
    private ViewAuthorizer authorizer;
    private Class<? extends RequestAuthorizationCache> requestAuthorizationCacheClass = RequestAuthorizationCache.class;
    private Map<String, Boolean> actionFlags;
    private Map<String, Boolean> editModes;
    private Map<String, String> expressionVariables;
    private boolean singlePageView = false;
    private boolean mergeWithPageItems = true;
    private PageGroup page;
    @ReferenceCopy(referenceTransient=true)
    private PageGroup currentPage;
    private List<Group> dialogs;
    protected boolean applyDirtyCheck;
    private boolean translateCodesOnReadOnlyDisplay = false;
    private boolean supportsRequestOverrideOfReadOnlyFields = true;
    private boolean disableNativeAutocomplete;
    private boolean disableBrowserCache = true;
    private String preLoadScript;
    @DelayedCopy
    private List<? extends Component> items;
    private List<String> viewTemplates;
    private Class<? extends ViewHelperService> viewHelperServiceClass;
    @ReferenceCopy
    private ViewHelperService viewHelperService;
    private Map<String, Object> preModelContext;

    public View() {
        this.viewIndex = new ViewIndex();
        this.additionalScriptFiles = Collections.emptyList();
        this.additionalCssFiles = Collections.emptyList();
        this.additionalHeadLinks = Collections.emptyList();
        this.additionalMetaTags = Collections.emptyList();
        this.objectPathToConcreteClassMapping = Collections.emptyMap();
        this.viewRequestParameters = Collections.emptyMap();
        this.expressionVariables = Collections.emptyMap();
        this.dialogs = Collections.emptyList();
        this.items = Collections.emptyList();
        this.viewTemplates = new LifecycleAwareList<String>(this);
    }

    @Override
    public void performInitialization(Object model) {
        Component itemComponent;
        if (model instanceof UifFormBase) {
            String dialogId;
            UifFormBase form = (UifFormBase)model;
            if (StringUtils.isNotBlank((String)form.getPageId())) {
                this.setCurrentPageId(form.getPageId());
            }
            if (StringUtils.isNotBlank((String)(dialogId = form.getActionParamaterValue("dialogId")))) {
                form.setShowDialogId(dialogId);
                this.initializeDialogLoadScript((UifFormBase)model);
            }
        }
        this.initializeDialogReclocationScript();
        super.performInitialization(model);
        assert (this == ViewLifecycle.getView());
        if (this.singlePageView) {
            if (this.page != null) {
                if (!this.mergeWithPageItems) {
                    this.page.setItems(new ArrayList());
                }
                List<? extends Component> newItems = this.page.getItems();
                newItems.addAll(this.items);
                this.page.setItems(newItems);
                this.page.sortItems();
                this.items = new ArrayList<Component>();
                this.items.add(this.page);
            }
        } else if (this.items != null && this.items.size() == 1 && (itemComponent = this.items.get(0)) instanceof PageGroup) {
            this.singlePageView = true;
        }
        if (this.sessionPolicy.isEnableTimeoutWarning()) {
            DialogGroup warningDialog = ComponentFactory.getSessionTimeoutWarningDialog();
            warningDialog.setId("Uif-SessionTimeoutWarning-DialogGroup");
            this.getDialogs().add(warningDialog);
            DialogGroup timeoutDialog = ComponentFactory.getSessionTimeoutDialog();
            timeoutDialog.setId("Uif-SessionTimeout-DialogGroup");
            this.getDialogs().add(timeoutDialog);
        }
        this.breadcrumbOptions.setupBreadcrumbs(model);
    }

    protected void initializeDialogLoadScript(UifFormBase form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLineIndex = form.getActionParamaterValue("selectedLineIndex");
        String dialogId = form.getShowDialogId();
        if (StringUtils.isNotBlank((String)dialogId) && StringUtils.isNotBlank((String)selectedCollectionPath) && StringUtils.isNotBlank((String)selectedLineIndex)) {
            String originalLineIndex = StringUtils.substring((String)dialogId, (int)(dialogId.length() - 1));
            if (!selectedLineIndex.equals(originalLineIndex)) {
                selectedLineIndex = originalLineIndex;
            }
            if (selectedCollectionPath.contains("dialogDataObject")) {
                String collectionId = StringUtils.substring((String)dialogId, (int)(dialogId.indexOf("_") + 1), (int)dialogId.lastIndexOf("_"));
                BindingInfo bindingInfo = (BindingInfo)form.getViewPostMetadata().getComponentPostMetadata(collectionId).getData("bindingInfo");
                selectedCollectionPath = bindingInfo.getBindingPath();
            }
            Object actionScript = "setupImages();";
            if (StringUtils.startsWith((String)dialogId, (String)"Uif-EditLineDialog")) {
                actionScript = (String)actionScript + "showEditLineDialog('" + dialogId + "', '" + selectedCollectionPath + "', " + selectedLineIndex + ");";
            } else {
                String additionalData = "{ 'actionParameters[selectedCollectionPath]' : '" + selectedCollectionPath + "', 'actionParameters[selectedLineIndex]' : '0' }";
                actionScript = (String)actionScript + "showDialog('" + dialogId + "', " + additionalData + ");";
            }
            this.setOnLoadScript(ScriptUtils.appendScript(this.getOnLoadScript(), (String)actionScript));
        } else if (StringUtils.isNotBlank((String)dialogId) && !(this instanceof LookupView)) {
            String actionScript = "jQuery.unblockUI();setupImages();showLoading('Loading...', window.document);showDialog('" + dialogId + "');";
            this.setOnLoadScript(ScriptUtils.appendScript(this.getOnLoadScript(), actionScript));
        }
    }

    protected void initializeDialogReclocationScript() {
        String dialogRelocationScript = "jQuery('.modal').appendTo('#Uif-Dialogs');";
        this.setOnLoadScript(ScriptUtils.appendScript(this.getOnLoadScript(), dialogRelocationScript));
    }

    @Override
    public void afterEvaluateExpression() {
        super.afterEvaluateExpression();
        if (this.getReadOnly() == null) {
            this.setReadOnly(false);
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        View view = ViewLifecycle.getView();
        if (this.theme != null) {
            ViewLifecycle.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, this.theme, this.getContext());
            this.theme.configureThemeDefaults();
        }
        if (this.sessionPolicy != null) {
            ViewLifecycle.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, this.sessionPolicy, this.getContext());
        }
        this.parentLocation.constructParentLocationBreadcrumbItems(view, model, view.getContext());
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        BlockUI refBlockUI;
        BlockUI navBlockUI;
        Growls gw;
        super.performFinalize(model, parent);
        assert (this == ViewLifecycle.getView());
        Object preLoadScript = "";
        if (this.getPreLoadScript() != null) {
            preLoadScript = this.getPreLoadScript();
        }
        if (!(gw = this.getGrowls()).getTemplateOptions().isEmpty()) {
            preLoadScript = (String)preLoadScript + "setGrowlDefaults(" + gw.getTemplateOptionsJSString() + ");";
        }
        if (!(navBlockUI = this.getNavigationBlockUI()).getTemplateOptions().isEmpty()) {
            preLoadScript = (String)preLoadScript + "setBlockUIDefaults(" + navBlockUI.getTemplateOptionsJSString() + ", 'navigation');";
        }
        if (!(refBlockUI = this.getRefreshBlockUI()).getTemplateOptions().isEmpty()) {
            preLoadScript = (String)preLoadScript + "setBlockUIDefaults(" + refBlockUI.getTemplateOptionsJSString() + ", 'refresh');";
        }
        this.setPreLoadScript((String)preLoadScript);
        String onReadyScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            onReadyScript = this.getOnDocumentReadyScript();
        }
        if (this.sessionPolicy.isEnableTimeoutWarning()) {
            int sessionTimeoutInterval = ((UifFormBase)model).getSessionTimeoutInterval();
            int sessionWarningSeconds = this.sessionPolicy.getTimeoutWarningSeconds();
            if (sessionTimeoutInterval <= 0) {
                sessionTimeoutInterval = 3600;
            }
            if (sessionWarningSeconds >= sessionTimeoutInterval || sessionWarningSeconds <= 0) {
                sessionWarningSeconds = sessionTimeoutInterval / 10;
            }
            int sessionWarningInterval = sessionTimeoutInterval - sessionWarningSeconds;
            onReadyScript = ScriptUtils.appendScript(onReadyScript, ScriptUtils.buildFunctionCall("initializeSessionTimers", sessionWarningInterval, sessionTimeoutInterval));
        }
        onReadyScript = ScriptUtils.appendScript(onReadyScript, "jQuery.extend(jQuery.validator.messages, " + ClientValidationUtils.generateValidatorMessagesOption() + ");");
        this.setOnDocumentReadyScript(onReadyScript);
        this.breadcrumbOptions.finalizeBreadcrumbs(model, this, this.breadcrumbItem);
        Object groupValidationDataDefaults = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-GroupValidationMessages-DataDefaults");
        Object fieldValidationDataDefaults = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-FieldValidationMessages-DataDefaults");
        Object actionDataDefaults = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-Action-DataDefaults");
        Object requiredIndicator = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-RequiredIndicator");
        this.addScriptDataAttribute("group_validation_defaults", ScriptUtils.convertToJsValue((Map)groupValidationDataDefaults));
        this.addScriptDataAttribute("field_validation_defaults", ScriptUtils.convertToJsValue((Map)fieldValidationDataDefaults));
        this.addScriptDataAttribute("action_defaults", ScriptUtils.convertToJsValue((Map)actionDataDefaults));
        this.addScriptDataAttribute("req_indicator", (String)requiredIndicator);
        this.addDataAttribute("role", "View");
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "stateObjectBindingPath", (Object)this.stateObjectBindingPath);
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "stateMapping", (Object)this.stateMapping);
        this.setNestedComponentId(this.getInstructionalMessage(), this.getId() + "_instructional");
        Header header = this.getHeader();
        Help help = this.getHelp();
        if (header != null) {
            this.setNestedComponentId(header, this.getId() + "_headerWrapper");
            this.setNestedComponentId(header.getUpperGroup(), this.getId() + "_headerUpperGroup");
            this.setNestedComponentId(header.getRightGroup(), this.getId() + "_headerRightGroup");
            this.setNestedComponentId(header.getLowerGroup(), this.getId() + "_headerLowerGroup");
            this.setNestedComponentId(help, this.getId() + "_helpWrapper");
            if (help != null && help.getHelpAction() != null) {
                this.setNestedComponentId(help.getHelpAction(), this.getId() + "_helpWrapper");
            }
        }
    }

    protected void setNestedComponentId(Component component, String newId) {
        if (component != null) {
            component.setId(newId);
        }
    }

    @Override
    public void notifyCompleted(ViewLifecyclePhase phase) {
        super.notifyCompleted(phase);
        if (phase.getViewPhase().equals("FINALIZE")) {
            ViewLifecycle.getHelper().performCustomViewFinalize(ViewLifecycle.getModel());
        }
    }

    public List<BreadcrumbItem> getBreadcrumbItems() {
        if (this.parentLocation == null) {
            return Collections.emptyList();
        }
        ArrayList<BreadcrumbItem> breadcrumbItems = new ArrayList<BreadcrumbItem>();
        breadcrumbItems.add(this.parentLocation.getPageBreadcrumbItem());
        breadcrumbItems.add(this.parentLocation.getViewBreadcrumbItem());
        for (BreadcrumbItem item : this.parentLocation.getResolvedBreadcrumbItems()) {
            if (breadcrumbItems.contains(item)) continue;
            breadcrumbItems.add(item);
        }
        return breadcrumbItems;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Group.class);
        return supportedComponents;
    }

    @Override
    public String getComponentTypeName() {
        return "view";
    }

    @ViewLifecycleRestriction(exclude={"PRE_PROCESS"})
    public PageGroup getCurrentPage() {
        if (this.currentPage != null) {
            return this.currentPage;
        }
        for (Component component : this.getItems()) {
            if (!(component instanceof PageGroup) || !this.singlePageView && !StringUtils.equals((String)component.getId(), (String)this.getCurrentPageId())) continue;
            this.currentPage = (PageGroup)CopyUtils.unwrap(component);
        }
        return this.currentPage;
    }

    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    public List<Component> getPagesForPreprocessing() {
        ArrayList<Component> processProcessItems = new ArrayList<Component>();
        if (this.getItems() != null) {
            processProcessItems.addAll(this.getItems());
        }
        if (this.getPage() != null) {
            processProcessItems.add(this.getPage());
        }
        return processProcessItems;
    }

    @Override
    public void sortItems() {
        if (!this.singlePageView) {
            super.sortItems();
        }
    }

    @Override
    @BeanTagAttribute
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public void setNamespaceCode(String namespaceCode) {
        this.checkMutable(true);
        this.namespaceCode = namespaceCode;
    }

    @BeanTagAttribute
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.checkMutable(true);
        this.viewName = viewName;
    }

    @BeanTagAttribute
    public boolean isUnifiedHeader() {
        return this.unifiedHeader;
    }

    public void setUnifiedHeader(boolean unifiedHeader) {
        this.checkMutable(true);
        this.unifiedHeader = unifiedHeader;
    }

    @BeanTagAttribute
    public Group getTopGroup() {
        return this.topGroup;
    }

    public void setTopGroup(Group topGroup) {
        this.checkMutable(true);
        this.topGroup = topGroup;
    }

    @BeanTagAttribute
    public Header getApplicationHeader() {
        return this.applicationHeader;
    }

    public void setApplicationHeader(Header applicationHeader) {
        this.checkMutable(true);
        this.applicationHeader = applicationHeader;
    }

    @BeanTagAttribute
    public Group getApplicationFooter() {
        return this.applicationFooter;
    }

    public void setApplicationFooter(Group applicationFooter) {
        this.checkMutable(true);
        this.applicationFooter = applicationFooter;
    }

    @BeanTagAttribute
    public Group getBuildFooter() {
        return this.buildFooter;
    }

    public void setBuildFooter(Group buildFooter) {
        this.buildFooter = buildFooter;
    }

    @BeanTagAttribute(name="applicationTitleText")
    public String getApplicationTitleText() {
        return this.applicationTitleText;
    }

    public void setApplicationTitleText(String applicationTitleText) {
        this.applicationTitleText = applicationTitleText;
    }

    @BeanTagAttribute
    public boolean isStickyTopGroup() {
        return this.stickyTopGroup;
    }

    public void setStickyTopGroup(boolean stickyTopGroup) {
        this.checkMutable(true);
        this.stickyTopGroup = stickyTopGroup;
    }

    @BeanTagAttribute
    public boolean isStickyBreadcrumbs() {
        return this.stickyBreadcrumbs;
    }

    public void setStickyBreadcrumbs(boolean stickyBreadcrumbs) {
        this.checkMutable(true);
        this.stickyBreadcrumbs = stickyBreadcrumbs;
    }

    @BeanTagAttribute
    public boolean isStickyHeader() {
        if (this.getHeader() != null && this.getHeader() instanceof ViewHeader) {
            return ((ViewHeader)this.getHeader()).isSticky();
        }
        return false;
    }

    public void setStickyHeader(boolean stickyHeader) {
        this.checkMutable(true);
        this.stickyHeader = stickyHeader;
        if (this.getHeader() != null && this.getHeader() instanceof ViewHeader) {
            ((ViewHeader)this.getHeader()).setSticky(stickyHeader);
        }
    }

    @BeanTagAttribute
    public boolean isStickyApplicationHeader() {
        return this.stickyApplicationHeader;
    }

    public void setStickyApplicationHeader(boolean stickyApplicationHeader) {
        this.checkMutable(true);
        this.stickyApplicationHeader = stickyApplicationHeader;
    }

    @BeanTagAttribute
    public boolean isStickyFooter() {
        return this.stickyFooter;
    }

    public void setStickyFooter(boolean stickyFooter) {
        this.checkMutable(true);
        this.stickyFooter = stickyFooter;
        if (this.getFooter() != null) {
            this.getFooter().addDataAttribute("sticky_footer", Boolean.toString(stickyFooter));
        }
    }

    @BeanTagAttribute
    public boolean isStickyApplicationFooter() {
        return this.stickyApplicationFooter;
    }

    public void setStickyApplicationFooter(boolean stickyApplicationFooter) {
        this.checkMutable(true);
        this.stickyApplicationFooter = stickyApplicationFooter;
    }

    @BeanTagAttribute
    public List<String> getContentContainerCssClasses() {
        return this.contentContainerCssClasses;
    }

    public void setContentContainerCssClasses(List<String> contentContainerCssClasses) {
        this.contentContainerCssClasses = contentContainerCssClasses;
    }

    public String getContentContainerClassesAsString() {
        if (this.contentContainerCssClasses != null) {
            return StringUtils.join(this.contentContainerCssClasses, (String)" ");
        }
        return "";
    }

    @BeanTagAttribute
    public String getEntryPageId() {
        return this.entryPageId;
    }

    public void setEntryPageId(String entryPageId) {
        this.checkMutable(true);
        this.entryPageId = entryPageId;
    }

    public String getCurrentPageId() {
        if (StringUtils.isBlank((String)this.currentPageId)) {
            Component firstPageGroup;
            if (StringUtils.isNotBlank((String)this.entryPageId)) {
                this.currentPageId = this.entryPageId;
            } else if (this.getItems() != null && !this.getItems().isEmpty() && (firstPageGroup = this.getItems().get(0)) instanceof PageGroup) {
                this.currentPageId = firstPageGroup.getId();
            }
        }
        return this.currentPageId;
    }

    public void setCurrentPageId(String currentPageId) {
        this.checkMutable(true);
        this.currentPageId = currentPageId;
        this.currentPage = null;
    }

    @BeanTagAttribute
    public Group getNavigation() {
        return this.navigation;
    }

    public void setNavigation(Group navigation) {
        this.checkMutable(true);
        this.navigation = navigation;
    }

    @BeanTagAttribute
    public Class<?> getFormClass() {
        return this.formClass;
    }

    public void setFormClass(Class<?> formClass) {
        this.checkMutable(true);
        this.formClass = formClass;
    }

    @BeanTagAttribute
    public String getDefaultBindingObjectPath() {
        return this.defaultBindingObjectPath;
    }

    public void setDefaultBindingObjectPath(String defaultBindingObjectPath) {
        this.checkMutable(true);
        this.defaultBindingObjectPath = defaultBindingObjectPath;
    }

    @BeanTagAttribute
    public Map<String, Class<?>> getObjectPathToConcreteClassMapping() {
        if (this.objectPathToConcreteClassMapping == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.objectPathToConcreteClassMapping = new HashMap();
        }
        return this.objectPathToConcreteClassMapping;
    }

    public void setObjectPathToConcreteClassMapping(Map<String, Class<?>> objectPathToConcreteClassMapping) {
        this.checkMutable(true);
        this.objectPathToConcreteClassMapping = objectPathToConcreteClassMapping;
    }

    @BeanTagAttribute
    public List<String> getAdditionalScriptFiles() {
        if (this.additionalScriptFiles == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.additionalScriptFiles = new LifecycleAwareList<String>(this);
        }
        return this.additionalScriptFiles;
    }

    public void setAdditionalScriptFiles(List<String> additionalScriptFiles) {
        this.checkMutable(true);
        this.additionalScriptFiles = additionalScriptFiles == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, additionalScriptFiles);
    }

    @BeanTagAttribute
    public List<String> getAdditionalCssFiles() {
        if (this.additionalCssFiles == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.additionalCssFiles = new LifecycleAwareList<String>(this);
        }
        return this.additionalCssFiles;
    }

    public void setAdditionalCssFiles(List<String> additionalCssFiles) {
        this.checkMutable(true);
        this.additionalCssFiles = additionalCssFiles == null ? Collections.emptyList() : new LifecycleAwareList<String>(this, additionalCssFiles);
    }

    @BeanTagAttribute
    public List<HeadLink> getAdditionalHeadLinks() {
        return this.additionalHeadLinks;
    }

    public void setAdditionalHeadLinks(List<HeadLink> additionalHeadLinks) {
        this.additionalHeadLinks = additionalHeadLinks;
    }

    @BeanTagAttribute
    public List<MetaTag> getAdditionalMetaTags() {
        return this.additionalMetaTags;
    }

    public void setAdditionalMetaTags(List<MetaTag> additionalMetaTags) {
        this.additionalMetaTags = additionalMetaTags;
    }

    @BeanTagAttribute
    public boolean isUseLibraryCssClasses() {
        return this.useLibraryCssClasses;
    }

    public void setUseLibraryCssClasses(boolean useLibraryCssClasses) {
        this.checkMutable(true);
        this.useLibraryCssClasses = useLibraryCssClasses;
    }

    public List<String> getViewTemplates() {
        return this.viewTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewTemplate(String template) {
        if (StringUtils.isEmpty((String)template)) {
            return;
        }
        if (!this.viewTemplates.contains(template)) {
            List<String> list = this.viewTemplates;
            synchronized (list) {
                this.viewTemplates.add(template);
            }
        }
    }

    public void setViewTemplates(List<String> viewTemplates) {
        this.checkMutable(true);
        this.viewTemplates = viewTemplates == null ? new LifecycleAwareList<String>(this) : new LifecycleAwareList<String>(this, viewTemplates);
    }

    @BeanTagAttribute
    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.checkMutable(true);
        this.viewTypeName = viewTypeName;
    }

    @BeanTagAttribute
    public Class<? extends ViewHelperService> getViewHelperServiceClass() {
        return this.viewHelperServiceClass;
    }

    public void setViewHelperServiceClass(Class<? extends ViewHelperService> viewHelperServiceClass) {
        this.checkMutable(true);
        this.viewHelperServiceClass = viewHelperServiceClass;
        if (this.viewHelperService == null && this.viewHelperServiceClass != null) {
            this.viewHelperService = KRADUtils.createNewObjectFromClass(viewHelperServiceClass);
        }
    }

    @BeanTagAttribute
    public ViewHelperService getViewHelperService() {
        return this.viewHelperService;
    }

    public void setViewHelperService(ViewHelperService viewHelperService) {
        this.checkMutable(true);
        this.viewHelperService = viewHelperService;
    }

    public void clearIndex() {
        if (this.viewIndex == null) {
            this.viewIndex = new ViewIndex();
        }
        this.viewIndex.clearIndex(this);
    }

    public ViewIndex getViewIndex() {
        return this.viewIndex;
    }

    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.checkMutable(true);
        this.viewRequestParameters = Collections.unmodifiableMap(viewRequestParameters);
    }

    @BeanTagAttribute
    public boolean isPersistFormToSession() {
        return this.persistFormToSession;
    }

    public void setPersistFormToSession(boolean persistFormToSession) {
        this.checkMutable(true);
        this.persistFormToSession = persistFormToSession;
    }

    @BeanTagAttribute
    public ViewSessionPolicy getSessionPolicy() {
        return this.sessionPolicy;
    }

    public void setSessionPolicy(ViewSessionPolicy sessionPolicy) {
        this.checkMutable(true);
        this.sessionPolicy = sessionPolicy;
    }

    public int getPreloadPoolSize() {
        return this.preloadPoolSize;
    }

    public void setPreloadPoolSize(int preloadPoolSize) {
        this.preloadPoolSize = preloadPoolSize;
    }

    @BeanTagAttribute
    public ViewPresentationController getPresentationController() {
        return this.presentationController;
    }

    public void setPresentationController(ViewPresentationController presentationController) {
        this.checkMutable(true);
        this.presentationController = presentationController;
    }

    public void setPresentationControllerClass(Class<? extends ViewPresentationController> presentationControllerClass) {
        this.checkMutable(true);
        this.presentationController = KRADUtils.createNewObjectFromClass(presentationControllerClass);
    }

    @BeanTagAttribute
    public ViewAuthorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(ViewAuthorizer authorizer) {
        this.checkMutable(true);
        this.authorizer = authorizer;
    }

    public void setAuthorizerClass(Class<? extends ViewAuthorizer> authorizerClass) {
        this.checkMutable(true);
        this.authorizer = KRADUtils.createNewObjectFromClass(authorizerClass);
    }

    @BeanTagAttribute
    public Map<String, Boolean> getActionFlags() {
        return this.actionFlags;
    }

    public void setActionFlags(Map<String, Boolean> actionFlags) {
        this.actionFlags = actionFlags;
    }

    @BeanTagAttribute
    public Map<String, Boolean> getEditModes() {
        return this.editModes;
    }

    public void setEditModes(Map<String, Boolean> editModes) {
        this.editModes = editModes;
    }

    public Class<? extends RequestAuthorizationCache> getRequestAuthorizationCacheClass() {
        return this.requestAuthorizationCacheClass;
    }

    public void setRequestAuthorizationCacheClass(Class<? extends RequestAuthorizationCache> requestAuthorizationCacheClass) {
        this.requestAuthorizationCacheClass = requestAuthorizationCacheClass;
    }

    @BeanTagAttribute
    public Map<String, String> getExpressionVariables() {
        return this.expressionVariables;
    }

    public void setExpressionVariables(Map<String, String> expressionVariables) {
        this.checkMutable(true);
        this.expressionVariables = Collections.unmodifiableMap(expressionVariables);
    }

    @BeanTagAttribute
    public boolean isSinglePageView() {
        return this.singlePageView;
    }

    public void setSinglePageView(boolean singlePageView) {
        this.checkMutable(true);
        this.singlePageView = singlePageView;
    }

    @BeanTagAttribute
    public boolean isMergeWithPageItems() {
        return this.mergeWithPageItems;
    }

    public void setMergeWithPageItems(boolean mergeWithPageItems) {
        this.checkMutable(true);
        this.mergeWithPageItems = mergeWithPageItems;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECT)
    public PageGroup getPage() {
        return this.page;
    }

    public void setPage(PageGroup page) {
        this.checkMutable(true);
        this.page = page;
    }

    @Override
    @ViewLifecycleRestriction
    @BeanTagAttribute
    public List<? extends Component> getItems() {
        if (this.items == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.items = new LifecycleAwareList<Component>(this);
        }
        return this.items;
    }

    @Override
    public void setItems(List<? extends Component> items) {
        this.checkMutable(true);
        this.items = items == null ? Collections.emptyList() : new LifecycleAwareList<Component>(this, items);
    }

    @BeanTagAttribute
    @ViewLifecycleRestriction(value={"FINALIZE"}, condition="!ajaxRequest || (ajaxReturnType eq 'update-view') || (ajaxReturnType eq 'update-page')")
    public List<Group> getDialogs() {
        if (this.dialogs == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.dialogs = new LifecycleAwareList<Group>(this);
        }
        return this.dialogs;
    }

    public void setDialogs(List<Group> dialogs) {
        this.checkMutable(true);
        this.dialogs = dialogs == null ? Collections.emptyList() : new LifecycleAwareList<Group>(this, dialogs);
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Breadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.checkMutable(true);
        this.breadcrumbs = breadcrumbs;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public BreadcrumbOptions getBreadcrumbOptions() {
        return this.breadcrumbOptions;
    }

    public void setBreadcrumbOptions(BreadcrumbOptions breadcrumbOptions) {
        this.checkMutable(true);
        this.breadcrumbOptions = breadcrumbOptions;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public BreadcrumbItem getBreadcrumbItem() {
        return this.breadcrumbItem;
    }

    public void setBreadcrumbItem(BreadcrumbItem breadcrumbItem) {
        this.checkMutable(true);
        this.breadcrumbItem = breadcrumbItem;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public ParentLocation getParentLocation() {
        return this.parentLocation;
    }

    public void setParentLocation(ParentLocation parentLocation) {
        this.checkMutable(true);
        this.parentLocation = parentLocation;
    }

    public List<BreadcrumbItem> getPathBasedBreadcrumbs() {
        return this.pathBasedBreadcrumbs;
    }

    public void setPathBasedBreadcrumbs(List<BreadcrumbItem> pathBasedBreadcrumbs) {
        this.checkMutable(true);
        this.pathBasedBreadcrumbs = pathBasedBreadcrumbs == null ? null : new LifecycleAwareList<BreadcrumbItem>(this, pathBasedBreadcrumbs);
    }

    @BeanTagAttribute
    public Growls getGrowls() {
        return this.growls;
    }

    public void setGrowls(Growls growls) {
        this.checkMutable(true);
        this.growls = growls;
    }

    @BeanTagAttribute
    public BlockUI getRefreshBlockUI() {
        return this.refreshBlockUI;
    }

    public void setRefreshBlockUI(BlockUI refreshBlockUI) {
        this.checkMutable(true);
        this.refreshBlockUI = refreshBlockUI;
    }

    @BeanTagAttribute
    public BlockUI getNavigationBlockUI() {
        return this.navigationBlockUI;
    }

    public void setNavigationBlockUI(BlockUI navigationBlockUI) {
        this.checkMutable(true);
        this.navigationBlockUI = navigationBlockUI;
    }

    @BeanTagAttribute
    public boolean isGrowlMessagingEnabled() {
        return this.growlMessagingEnabled;
    }

    public void setGrowlMessagingEnabled(boolean growlMessagingEnabled) {
        this.checkMutable(true);
        this.growlMessagingEnabled = growlMessagingEnabled;
    }

    @BeanTagAttribute
    public boolean isApplyDirtyCheck() {
        return this.applyDirtyCheck;
    }

    public void setApplyDirtyCheck(boolean applyDirtyCheck) {
        this.checkMutable(true);
        this.applyDirtyCheck = applyDirtyCheck;
    }

    @BeanTagAttribute
    public boolean isTranslateCodesOnReadOnlyDisplay() {
        return this.translateCodesOnReadOnlyDisplay;
    }

    public void setTranslateCodesOnReadOnlyDisplay(boolean translateCodesOnReadOnlyDisplay) {
        this.checkMutable(true);
        this.translateCodesOnReadOnlyDisplay = translateCodesOnReadOnlyDisplay;
    }

    @BeanTagAttribute
    public boolean isSupportsRequestOverrideOfReadOnlyFields() {
        return this.supportsRequestOverrideOfReadOnlyFields;
    }

    public void setSupportsRequestOverrideOfReadOnlyFields(boolean supportsRequestOverrideOfReadOnlyFields) {
        this.checkMutable(true);
        this.supportsRequestOverrideOfReadOnlyFields = supportsRequestOverrideOfReadOnlyFields;
    }

    @BeanTagAttribute
    public boolean isDisableNativeAutocomplete() {
        return this.disableNativeAutocomplete;
    }

    public void setDisableNativeAutocomplete(boolean disableNativeAutocomplete) {
        this.checkMutable(true);
        this.disableNativeAutocomplete = disableNativeAutocomplete;
    }

    @BeanTagAttribute
    public boolean isDisableBrowserCache() {
        return this.disableBrowserCache;
    }

    public void setDisableBrowserCache(boolean disableBrowserCache) {
        this.checkMutable(true);
        this.disableBrowserCache = disableBrowserCache;
    }

    @BeanTagAttribute
    public String getPreLoadScript() {
        return this.preLoadScript;
    }

    public void setPreLoadScript(String preLoadScript) {
        this.checkMutable(true);
        this.preLoadScript = preLoadScript;
    }

    @BeanTagAttribute
    public ViewTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ViewTheme theme) {
        this.checkMutable(true);
        this.theme = theme;
    }

    @BeanTagAttribute
    public String getStateObjectBindingPath() {
        return this.stateObjectBindingPath;
    }

    public void setStateObjectBindingPath(String stateObjectBindingPath) {
        this.checkMutable(true);
        this.stateObjectBindingPath = stateObjectBindingPath;
    }

    @BeanTagAttribute
    public StateMapping getStateMapping() {
        return this.stateMapping;
    }

    public void setStateMapping(StateMapping stateMapping) {
        this.checkMutable(true);
        this.stateMapping = stateMapping;
    }

    public Map<String, Object> getPreModelContext() {
        if (this.preModelContext == null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("view", this);
            context.put("ViewHelper", this.viewHelperService);
            ViewTheme theme = this.getTheme();
            if (theme != null) {
                context.put("ThemeImages", theme.getImageDirectory());
            }
            Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
            context.put("ConfigProperties", properties);
            context.put("Constants", KRADConstants.class);
            context.put("UifConstants", UifConstants.class);
            context.put("userSession", GlobalVariables.getUserSession());
            this.preModelContext = Collections.unmodifiableMap(context);
        }
        return this.preModelContext;
    }

    @Override
    public View clone() throws CloneNotSupportedException {
        View viewCopy = (View)super.clone();
        viewCopy.viewIndex = new ViewIndex();
        return viewCopy;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        String[] currentValues2;
        tracer.addBean(this);
        boolean validPageId = false;
        if (this.getEntryPageId() != null) {
            for (int i = 0; i < this.getItems().size(); ++i) {
                if (this.getEntryPageId().compareTo(this.getItems().get(i).getId()) != 0) continue;
                validPageId = true;
            }
        } else {
            validPageId = true;
        }
        if (!validPageId) {
            String[] currentValues3 = new String[]{"entryPageId = " + this.getEntryPageId()};
            tracer.createError("Items must contain an item with a matching id to entryPageId", currentValues3);
        }
        if (tracer.getValidationStage() == 0 && this.getViewStatus().compareTo("C") != 0) {
            String[] currentValues4 = new String[]{"viewStatus = " + this.getViewStatus()};
            tracer.createError("ViewStatus should not be set", currentValues4);
        }
        boolean validDefaultBindingObjectPath = false;
        if (this.getDefaultBindingObjectPath() == null || this.getDefaultBindingObjectPath() == "") {
            validDefaultBindingObjectPath = true;
        } else if (DataDictionaryPropertyUtils.isPropertyOf(this.getFormClass(), this.getDefaultBindingObjectPath())) {
            validDefaultBindingObjectPath = true;
        }
        if (!validDefaultBindingObjectPath) {
            currentValues2 = new String[]{"formClass = " + String.valueOf(this.getFormClass()), "defaultBindingPath = " + this.getDefaultBindingObjectPath()};
            tracer.createError("DefaultBingdingObjectPath must be a valid property of the formClass", currentValues2);
        }
        if (this.isSinglePageView()) {
            if (this.getPage() == null) {
                currentValues2 = new String[]{"singlePageView = " + this.isSinglePageView(), "page = " + String.valueOf(this.getPage())};
                tracer.createError("Page must be set if singlePageView is true", currentValues2);
            }
            for (int i = 0; i < this.getItems().size(); ++i) {
                if (this.getItems().get(i).getClass() != PageGroup.class) continue;
                currentValues = new String[]{"singlePageView = " + this.isSinglePageView(), "items(" + i + ") = " + String.valueOf(this.getItems().get(i).getClass())};
                tracer.createError("Items cannot be pageGroups if singlePageView is true", currentValues);
            }
        }
        if (this.isGrowlMessagingEnabled() && this.getGrowls() == null && Validator.checkExpressions(this, "growls")) {
            currentValues2 = new String[]{"growlMessagingEnabled = " + this.isGrowlMessagingEnabled(), "growls = " + String.valueOf(this.getGrowls())};
            tracer.createError("Growls cannot be null if Growl Messaging is enabled", currentValues2);
        }
        if (!this.isSinglePageView()) {
            if (this.getItems().size() == 0) {
                currentValues2 = new String[]{"singlePageView = " + this.isSinglePageView(), "items.size = " + this.getItems().size()};
                tracer.createWarning("Items cannot be empty if singlePageView is false", currentValues2);
            } else {
                for (int i = 0; i < this.getItems().size(); ++i) {
                    if (this.getItems().get(i).getClass() == PageGroup.class) continue;
                    currentValues = new String[]{"singlePageView = " + this.isSinglePageView(), "items(" + i + ") = " + String.valueOf(this.getItems().get(i).getClass())};
                    tracer.createError("Items must be pageGroups if singlePageView is false", currentValues);
                }
            }
        }
        super.completeValidation(tracer.getCopy());
    }
}

