/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.IOStatistics;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import java.io.File;
import java.io.IOException;

class LiveNIOStatistics
implements IOStatistics {
    private final File home;
    private final NIOStreamImpl stream;
    private final long written;
    private final long read;

    LiveNIOStatistics(File home, NIOStreamImpl stream, long written, long read) {
        this.home = home;
        this.stream = stream;
        this.written = written;
        this.read = read;
    }

    @Override
    public long getTotalAvailable() {
        return this.home.getUsableSpace();
    }

    @Override
    public long getTotalUsed() {
        return this.stream.getTotalSize();
    }

    @Override
    public long getTotalWritten() {
        return this.written;
    }

    @Override
    public long getTotalRead() {
        return this.read;
    }

    @Override
    public long getLiveSize() {
        try {
            return this.stream.getTotalSize() - this.stream.scanForEnd();
        }
        catch (IOException ioe) {
            return 0L;
        }
    }

    @Override
    public long getExpiredSize() {
        try {
            return this.stream.getTotalSize() - this.stream.findLogTail();
        }
        catch (IOException ioe) {
            return 0L;
        }
    }

    public String toString() {
        return "LiveNIOStatistics{home=" + this.home + ", written=" + this.written + ", read=" + this.read + " used:" + this.getTotalUsed() + '}';
    }
}

