/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.DOMBuilder;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlHelper {
    private static final Logger LOG = LogManager.getLogger(XmlHelper.class);

    private XmlHelper() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Document buildJDocument(Reader xmlStream) {
        SAXBuilder builder = XmlHelper.safeNonValidatingSAXBuilder();
        try {
            return builder.build(xmlStream);
        }
        catch (IOException | JDOMException e) {
            throw new XmlException("Invalid xml string. ", e);
        }
    }

    public static Document buildJDocument(org.w3c.dom.Document document) {
        return new DOMBuilder().build(document);
    }

    public static Collection<org.jdom2.Element> findElements(org.jdom2.Element root, String elementName) {
        ArrayList<org.jdom2.Element> elementList = new ArrayList<org.jdom2.Element>();
        if (root == null) {
            return elementList;
        }
        XmlHelper.findElements(root, elementName, elementList);
        return elementList;
    }

    public static void appendXml(Node parentNode, String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = SafeXmlUtils.safeDocumentBuilderFactory();
        factory.setValidating(false);
        org.w3c.dom.Document xmlDocument = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        Element xmlDocumentElement = xmlDocument.getDocumentElement();
        Node importedNode = parentNode.getOwnerDocument().importNode(xmlDocumentElement, true);
        parentNode.appendChild(importedNode);
    }

    public static org.w3c.dom.Document readXml(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = SafeXmlUtils.safeDocumentBuilderFactory();
        factory.setValidating(false);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
    }

    public static void propagateNamespace(org.jdom2.Element element, Namespace namespace) {
        element.setNamespace(namespace);
        for (Object childElement : element.getChildren()) {
            XmlHelper.propagateNamespace((org.jdom2.Element)childElement, namespace);
        }
    }

    public static org.w3c.dom.Document trimXml(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = SafeXmlUtils.safeDocumentBuilderFactory();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document oldDocument = builder.parse(input);
        Element naviElement = oldDocument.getDocumentElement();
        XmlHelper.trimElement(naviElement);
        return oldDocument;
    }

    public static Document trimSAXXml(InputStream input) throws JDOMException, IOException {
        SAXBuilder builder = XmlHelper.safeNonValidatingSAXBuilder();
        Document oldDocument = builder.build(input);
        org.jdom2.Element naviElement = oldDocument.getRootElement();
        XmlHelper.trimSAXElement(naviElement);
        return oldDocument;
    }

    public static boolean pathExists(XPath xpath, String expression, Object object) throws XPathExpressionException {
        return (Boolean)xpath.evaluate(expression, object, XPathConstants.BOOLEAN);
    }

    public static Element propertiesToXml(org.w3c.dom.Document doc, Object o, String elementName) {
        Method[] methods;
        Class<?> c = o.getClass();
        Element wrapper = doc.createElement(elementName);
        for (Method method : methods = c.getMethods()) {
            String name = method.getName();
            if ("getClass".equals(name) || "getPostProcessor".equals(name) || !name.startsWith("get") || method.getParameterTypes().length > 0) continue;
            name = name.substring("get".length());
            name = StringUtils.uncapitalize((String)name);
            try {
                String value;
                Object result = method.invoke(o, new Object[0]);
                if (result == null) {
                    LOG.debug("value of " + name + " method on object " + String.valueOf(o.getClass()) + " is null");
                    value = "";
                } else {
                    value = result.toString();
                }
                Element fieldE = doc.createElement(name);
                fieldE.appendChild(doc.createTextNode(value));
                wrapper.appendChild(fieldE);
            }
            catch (Exception e) {
                throw new XmlException("Error accessing method '" + method.getName() + "' of instance of " + String.valueOf(c), e);
            }
        }
        return wrapper;
    }

    private static void findElements(org.jdom2.Element root, String elementName, Collection<org.jdom2.Element> list) {
        if (root != null) {
            if (root.getName().equals(elementName)) {
                list.add(root);
            }
            for (Object item : root.getChildren()) {
                if (item == null) continue;
                XmlHelper.findElements((org.jdom2.Element)item, elementName, list);
            }
        }
    }

    private static void trimElement(Node node) {
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null) continue;
                XmlHelper.trimElement(child);
            }
        } else if (node.getNodeType() == 3) {
            String text = node.getNodeValue();
            text = StringUtils.isEmpty((String)text) ? "" : text.trim();
            node.setNodeValue(text);
        }
    }

    private static void trimSAXElement(org.jdom2.Element element) {
        if (!element.getChildren().isEmpty()) {
            for (Object child : element.getChildren()) {
                if (child == null) continue;
                XmlHelper.trimSAXElement((org.jdom2.Element)child);
            }
        } else {
            String text = element.getTextTrim();
            if (StringUtils.isEmpty((String)text)) {
                text = "";
            }
            element.setText(text);
        }
    }

    private static SAXBuilder safeNonValidatingSAXBuilder() {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING, null, null);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }
}

