/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.impex.xml.XmlIngestionException;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.coreservice.impl.style.StyleXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleXmlParserImpl
implements StyleXmlParser {
    private static final Logger LOG = LogManager.getLogger(StyleXmlParserImpl.class);
    private StyleService styleService;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String message = "Error obtaining document builder";
            LOG.error(message, (Throwable)pce);
            throw new RuntimeException(message, pce);
        }
    }

    public void loadXml(InputStream inputStream, String principalId) {
        List<Style> styles = this.parseStyles(inputStream);
        for (Style style : styles) {
            this.styleService.saveStyle(style);
        }
    }

    @Override
    public List<Style> parseStyles(InputStream inputStream) {
        NodeList styles;
        Document doc;
        DocumentBuilder db = StyleXmlParserImpl.getDocumentBuilder();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            doc = db.parse(inputStream);
        }
        catch (Exception e) {
            throw StyleXmlParserImpl.generateException("Error parsing Style XML file", e);
        }
        try {
            styles = (NodeList)xpath.evaluate("//styles", doc.getFirstChild(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw StyleXmlParserImpl.generateException("Error evaluating XPath expression", e);
        }
        ArrayList<Style> parsedStyles = new ArrayList<Style>();
        for (int i = 0; i < styles.getLength(); ++i) {
            Node edl = styles.item(i);
            NodeList children = edl.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (!"style".equals(node.getNodeName())) continue;
                LOG.debug("Digesting style: " + e.getAttribute("name"));
                Style.Builder styleBuilder = StyleXmlParserImpl.parseStyle(e);
                parsedStyles.add(styleBuilder.build());
            }
        }
        return parsedStyles;
    }

    private static Style.Builder parseStyle(Element e) {
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw StyleXmlParserImpl.generateMissingAttribException("style", "name");
        }
        Style.Builder style = Style.Builder.create((String)name);
        Element stylesheet = null;
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"xsl:stylesheet".equals(child.getNodeName())) continue;
            stylesheet = (Element)child;
            break;
        }
        if (stylesheet == null) {
            throw StyleXmlParserImpl.generateMissingChildException("style", "xsl:stylesheet");
        }
        try {
            style.setXmlContent(XmlJotter.jotNode(stylesheet, (boolean)false));
        }
        catch (XmlException te) {
            throw StyleXmlParserImpl.generateSerializationException("style", te);
        }
        return style;
    }

    private static XmlIngestionException generateMissingAttribException(String element, String attrib) {
        return StyleXmlParserImpl.generateException("Style '" + element + "' element must contain a '" + attrib + "' attribute", null);
    }

    private static XmlIngestionException generateMissingChildException(String element, String child) {
        return StyleXmlParserImpl.generateException("Style '" + element + "' element must contain a '" + child + "' child element", null);
    }

    private static XmlIngestionException generateSerializationException(String element, XmlException cause) {
        return StyleXmlParserImpl.generateException("Error serializing Style '" + element + "' element", cause);
    }

    private static XmlIngestionException generateException(String error, Throwable cause) {
        return new XmlIngestionException(error, cause);
    }

    public void setStyleService(StyleService styleService) {
        this.styleService = styleService;
    }
}

