/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.creditsplit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplitable;
import org.kuali.coeus.propdev.impl.person.creditsplit.NamedCreditSplitable;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreditSplitValidator {
    private static final ScaleTwoDecimal CREDIT_UPBOUND = new ScaleTwoDecimal(100.0);
    private static final ScaleTwoDecimal CREDIT_LOWBOUND = ScaleTwoDecimal.ZERO;

    public boolean validate(ProposalDevelopmentDocument document) {
        if (document.getDevelopmentProposal().isMultiProjectChild()) {
            return true;
        }
        Collection<InvestigatorCreditType> creditTypes = this.getKeyPersonnelService().getInvestigatorCreditTypes();
        boolean retval = true;
        List<ProposalPerson> investigators = document.getDevelopmentProposal().getPersonsSelectedForCreditSplit();
        if (!investigators.isEmpty()) {
            for (InvestigatorCreditType creditType : creditTypes) {
                if (!creditType.addsToHundred().booleanValue()) continue;
                retval &= this.validate(investigators, creditType);
            }
        }
        return retval;
    }

    public boolean validate(Collection<ProposalPerson> investigators, InvestigatorCreditType creditType) {
        boolean retval = true;
        DecimalHolder investigatorCreditTotal = new DecimalHolder(ScaleTwoDecimal.ZERO);
        if (!this.validateCreditSplitable(investigators.iterator(), creditType, investigatorCreditTotal)) {
            this.addAuditError("error.totalCreditSplit.upbound", creditType.getDescription());
            retval = false;
        }
        for (ProposalPerson investigator : investigators) {
            DecimalHolder unitCreditTotal = new DecimalHolder(ScaleTwoDecimal.ZERO);
            if (this.validateCreditSplitable(investigator.getUnits().iterator(), creditType, unitCreditTotal)) continue;
            this.addAuditError("error.creditSplit.upbound", creditType.getDescription(), this.getCreditSplitableName(investigator));
            retval = false;
        }
        return retval;
    }

    public boolean validateCreditSplitable(Iterator<? extends CreditSplitable> splitable_it, InvestigatorCreditType creditType, DecimalHolder greaterCummulative) {
        if (!splitable_it.hasNext()) {
            return this.isCreditSplitTotalValid(greaterCummulative.getValue());
        }
        boolean retval = true;
        CreditSplitable splitable = splitable_it.next();
        DecimalHolder lesserCummulative = new DecimalHolder(ScaleTwoDecimal.ZERO);
        greaterCummulative.add(lesserCummulative);
        return (retval &= this.validateCreditSplit(splitable.getCreditSplits().iterator(), creditType, lesserCummulative)) & this.validateCreditSplitable(splitable_it, creditType, greaterCummulative);
    }

    private boolean isCreditSplitTotalValid(ScaleTwoDecimal total) {
        return CREDIT_UPBOUND.compareTo((AbstractDecimal)total) == 0 || CREDIT_LOWBOUND.compareTo((AbstractDecimal)total) > 0;
    }

    public boolean validateCreditSplit(Iterator<? extends CreditSplit> creditSplit_it, InvestigatorCreditType creditType, DecimalHolder lesserCummulative) {
        if (!creditSplit_it.hasNext()) {
            return false;
        }
        CreditSplit creditSplit = creditSplit_it.next();
        if (creditType.getCode().equals(creditSplit.getInvCreditTypeCode())) {
            lesserCummulative.add(creditSplit.getCredit());
            return this.isCreditSplitValid(creditSplit.getCredit());
        }
        return this.validateCreditSplit(creditSplit_it, creditType, lesserCummulative);
    }

    protected boolean isCreditSplitValid(ScaleTwoDecimal value) {
        boolean retval = true;
        if (CREDIT_UPBOUND.compareTo((AbstractDecimal)value) < 0) {
            retval = false;
        } else if (CREDIT_LOWBOUND.compareTo((AbstractDecimal)value) > 0) {
            retval = false;
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey("Credit Allocation")) {
            GlobalVariables.getAuditErrorMap().put("Credit Allocation", new AuditCluster("Credit Allocation", auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get("Credit Allocation")).getAuditErrorList();
        }
        return auditErrors;
    }

    private void addAuditError(String messageKey, String ... params) {
        CreditSplitAuditError error = new CreditSplitAuditError(messageKey, params);
        if (!this.getAuditErrors().contains((Object)error)) {
            this.getAuditErrors().add(error);
        }
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KcServiceLocator.getService(KeyPersonnelService.class);
    }

    protected String getCreditSplitableName(CreditSplitable splitable) {
        if (splitable instanceof NamedCreditSplitable) {
            return ((NamedCreditSplitable)splitable).getCreditSplitName();
        }
        return null;
    }

    static final class DecimalHolder
    implements Comparable<DecimalHolder> {
        private ScaleTwoDecimal value;

        public DecimalHolder(ScaleTwoDecimal val) {
            this.value = val;
        }

        public ScaleTwoDecimal getValue() {
            return this.value;
        }

        public void setValue(ScaleTwoDecimal value) {
            this.value = value;
        }

        public void add(ScaleTwoDecimal val) {
            this.value = (ScaleTwoDecimal)this.value.add((AbstractDecimal)val);
        }

        public void add(DecimalHolder val) {
            this.value = (ScaleTwoDecimal)this.value.add((AbstractDecimal)val.getValue());
        }

        @Override
        public int compareTo(DecimalHolder obj) {
            return this.value.compareTo((AbstractDecimal)obj.getValue());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static final class CreditSplitAuditError
    extends AuditError {
        public CreditSplitAuditError(String messageKey, String ... params) {
            super("PropDev-CreditAllocationPage", messageKey, "PropDev-CreditAllocationPage", params);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            AuditError error = (AuditError)obj;
            boolean retval = true;
            retval &= this.getErrorKey().equals(error.getErrorKey());
            retval &= this.getMessageKey().equals(error.getMessageKey());
            retval &= this.getLink().equals(error.getLink());
            return retval &= Arrays.equals(this.getParams(), error.getParams());
        }

        public int hashCode() {
            int result = this.getErrorKey() != null ? this.getErrorKey().hashCode() : 0;
            result = 31 * result + (this.getMessageKey() != null ? this.getMessageKey().hashCode() : 0);
            result = 31 * result + (this.getLink() != null ? this.getLink().hashCode() : 0);
            result = 31 * result + (this.getParams() != null ? Arrays.hashCode(this.getParams()) : 0);
            return result;
        }
    }
}

