/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup12V12.CitizenshipDataType;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup12V12.PHS398CareerDevelopmentAwardSup12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CareerDevelopmentAwardSupBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CareerDevelopmentAwardSupV1_2Generator")
public class PHS398CareerDevelopmentAwardSupV1_2Generator
extends PHS398CareerDevelopmentAwardSupBaseGenerator<PHS398CareerDevelopmentAwardSup12Document> {
    private static final String PROPOSAL_TYPE_TASK_ORDER = "6";
    @Value(value="http://apply.grants.gov/forms/PHS398_CareerDevelopmentAwardSup_1_2-V1.2")
    private String namespace;
    @Value(value="PHS398_CareerDevelopmentAwardSup_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CareerDevelopmentAwardSup-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="192")
    private int sortIndex;

    private PHS398CareerDevelopmentAwardSup12Document getPHS398CareerDevelopmentAwardSup() {
        PHS398CareerDevelopmentAwardSup12Document phs398CareerDevelopmentAwardSup12Document = (PHS398CareerDevelopmentAwardSup12Document)PHS398CareerDevelopmentAwardSup12Document.Factory.newInstance();
        PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12 phs398CareerDevelopmentAwardSup12 = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.Factory.newInstance();
        phs398CareerDevelopmentAwardSup12.setFormVersion(FormVersion.v1_2.getVersion());
        phs398CareerDevelopmentAwardSup12.setApplicationType(this.getApplicationType());
        phs398CareerDevelopmentAwardSup12.setCitizenship(this.getCitizenshipDataType());
        phs398CareerDevelopmentAwardSup12.setCareerDevelopmentAwardAttachments(this.getCareerDevelopmentAwardAttachments());
        phs398CareerDevelopmentAwardSup12Document.setPHS398CareerDevelopmentAwardSup12(phs398CareerDevelopmentAwardSup12);
        return phs398CareerDevelopmentAwardSup12Document;
    }

    private CitizenshipDataType.Enum getCitizenshipDataType() {
        return this.pdDoc.getDevelopmentProposal().getProposalPersons().stream().filter(ProposalPersonContract::isInvestigator).map(proposalPerson -> this.s2SProposalPersonService.getCitizenship((ProposalPersonContract)proposalPerson)).map(citizenShip -> {
            if (CitizenshipType.NON_US_CITIZEN_WITH_TEMPORARY_VISA.equals(citizenShip)) {
                return CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA;
            }
            if (CitizenshipType.PERMANENT_RESIDENT_OF_US.equals(citizenShip)) {
                return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S;
            }
            if (CitizenshipType.US_CITIZEN_OR_NONCITIZEN_NATIONAL.equals(citizenShip)) {
                return CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL;
            }
            if (CitizenshipType.PERMANENT_RESIDENT_OF_US_PENDING.equals(citizenShip)) {
                return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING;
            }
            return null;
        }).findFirst().orElse(null);
    }

    private PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType getApplicationType() {
        PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType applicationType = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProposalType().getCode() != null && !this.pdDoc.getDevelopmentProposal().getProposalType().getCode().equals(PROPOSAL_TYPE_TASK_ORDER)) {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType.TypeOfApplication.Enum.forInt(Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode())));
        } else {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.ApplicationType.TypeOfApplication.NEW);
        }
        return applicationType;
    }

    private PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments getCareerDevelopmentAwardAttachments() {
        PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.Factory.newInstance();
        AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        ArrayList<AttachedFileDataType> attachedFileList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeTypeCode = Integer.parseInt(narrative.getNarrativeType().getCode());
            switch (narrativeTypeCode) {
                case 70: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.IntroductionToApplication introductionToApplication = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.IntroductionToApplication)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.IntroductionToApplication.Factory.newInstance();
                    introductionToApplication.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setIntroductionToApplication(introductionToApplication);
                    break;
                }
                case 71: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SpecificAims specificAims = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SpecificAims)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SpecificAims.Factory.newInstance();
                    specificAims.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSpecificAims(specificAims);
                    break;
                }
                case 79: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport inclusionEnrollmentReport = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport.Factory.newInstance();
                    inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                    break;
                }
                case 80: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProgressReportPublicationList progressReportPublicationList = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProgressReportPublicationList)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProgressReportPublicationList.Factory.newInstance();
                    progressReportPublicationList.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProgressReportPublicationList(progressReportPublicationList);
                    break;
                }
                case 74: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects protectionOfHumanSubjects = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects.Factory.newInstance();
                    protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                    break;
                }
                case 75: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities.Factory.newInstance();
                    inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                    break;
                }
                case 76: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment targetedPlannedEnrollment = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment.Factory.newInstance();
                    targetedPlannedEnrollment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setTargetedPlannedEnrollment(targetedPlannedEnrollment);
                    break;
                }
                case 77: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfChildren inclusionOfChildren = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfChildren)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InclusionOfChildren.Factory.newInstance();
                    inclusionOfChildren.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfChildren(inclusionOfChildren);
                    break;
                }
                case 78: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.VertebrateAnimals vertebrateAnimals = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.VertebrateAnimals)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.VertebrateAnimals.Factory.newInstance();
                    vertebrateAnimals.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setVertebrateAnimals(vertebrateAnimals);
                    break;
                }
                case 81: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SelectAgentResearch selectAgentResearch = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SelectAgentResearch)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.SelectAgentResearch.Factory.newInstance();
                    selectAgentResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSelectAgentResearch(selectAgentResearch);
                    break;
                }
                case 83: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements.Factory.newInstance();
                    consortiumContractualArrangements.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setConsortiumContractualArrangements(consortiumContractualArrangements);
                    break;
                }
                case 84: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResourceSharingPlans resourceSharingPlans = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResourceSharingPlans)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResourceSharingPlans.Factory.newInstance();
                    resourceSharingPlans.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResourceSharingPlans(resourceSharingPlans);
                    break;
                }
                case 62: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CandidateBackground candidateBackground = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CandidateBackground)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CandidateBackground.Factory.newInstance();
                    candidateBackground.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCandidateBackground(candidateBackground);
                    break;
                }
                case 63: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives careerGoalsAndObjectives = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives.Factory.newInstance();
                    careerGoalsAndObjectives.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerGoalsAndObjectives(careerGoalsAndObjectives);
                    break;
                }
                case 64: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities careerDevelopmentAndTrainingActivities = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities.Factory.newInstance();
                    careerDevelopmentAndTrainingActivities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerDevelopmentAndTrainingActivities(careerDevelopmentAndTrainingActivities);
                    break;
                }
                case 65: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch.Factory.newInstance();
                    responsibleConductOfResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResponsibleConductOfResearch(responsibleConductOfResearch);
                    break;
                }
                case 66: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.MentoringPlan mentoringPlan = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.MentoringPlan)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.MentoringPlan.Factory.newInstance();
                    mentoringPlan.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setMentoringPlan(mentoringPlan);
                    break;
                }
                case 67: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.StatementsOfSupport statementsOfSupport = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.StatementsOfSupport)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.StatementsOfSupport.Factory.newInstance();
                    statementsOfSupport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setStatementsOfSupport(statementsOfSupport);
                    break;
                }
                case 68: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InsitutionalEnvironment insitutionalEnvironment = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InsitutionalEnvironment)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InsitutionalEnvironment.Factory.newInstance();
                    insitutionalEnvironment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInsitutionalEnvironment(insitutionalEnvironment);
                    break;
                }
                case 69: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InstitutionalCommitment institutionalCommitment = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InstitutionalCommitment)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.InstitutionalCommitment.Factory.newInstance();
                    institutionalCommitment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInstitutionalCommitment(institutionalCommitment);
                    break;
                }
                case 85: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    attachedFileList.add(attachedFileDataType);
                    break;
                }
                case 128: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResearchStrategy researchStrategy = (PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResearchStrategy)PHS398CareerDevelopmentAwardSup12Document.PHS398CareerDevelopmentAwardSup12.CareerDevelopmentAwardAttachments.ResearchStrategy.Factory.newInstance();
                    researchStrategy.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResearchStrategy(researchStrategy);
                }
            }
        }
        attachmentGroupMin0Max100DataType.setAttachedFileArray(attachedFileList.toArray(new AttachedFileDataType[0]));
        careerDevelopmentAwardAttachments.setAppendix(attachmentGroupMin0Max100DataType);
        return careerDevelopmentAwardAttachments;
    }

    @Override
    public PHS398CareerDevelopmentAwardSup12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398CareerDevelopmentAwardSup();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398CareerDevelopmentAwardSup12Document> factory() {
        return PHS398CareerDevelopmentAwardSup12Document.Factory;
    }
}

